/*
 * Decompiled with CFR 0.152.
 */
package ar.gabrielsuarez.glib.web;

import ar.gabrielsuarez.glib.data.Data;
import ar.gabrielsuarez.glib.web.WebParameters;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import spark.Request;

public class WebRequest {
    private Request sparkRequest;
    private Data headers;
    private WebParameters webParameters;

    void init(Request sparkRequest) {
        this.sparkRequest = sparkRequest;
    }

    public HttpServletRequest raw() {
        return this.sparkRequest != null ? this.sparkRequest.raw() : null;
    }

    public String method() {
        return this.sparkRequest != null ? this.sparkRequest.requestMethod() : null;
    }

    public String uri() {
        String uri = this.sparkRequest != null ? this.sparkRequest.uri() : "";
        return uri;
    }

    public Data headers() {
        if (this.headers == null) {
            this.headers = this.sparkRequest != null ? Data.fromList(this.sparkRequest.headers()) : new Data();
            this.headers.caseSensitive(false);
        }
        return this.headers;
    }

    public String header(String key) {
        return this.headers().string(key);
    }

    public WebParameters parameters() {
        if (this.webParameters == null) {
            this.webParameters = new WebParameters();
            this.webParameters.init(this.sparkRequest);
        }
        return this.webParameters;
    }

    public WebParameters parameters(Boolean failOnNull) {
        WebParameters parameters = this.parameters();
        parameters.failOnNull = failOnNull;
        return parameters;
    }

    public String ip() {
        String ip = "";
        if (this.sparkRequest != null) {
            String xForwardedFor = this.headers().string("x-forwarded-for", "");
            ip = !xForwardedFor.isEmpty() ? xForwardedFor.split(",")[0].trim() : this.sparkRequest.ip();
        }
        return ip;
    }

    public String userAgent() {
        String userAgent = this.sparkRequest != null ? this.headers().string("user-agent", "") : "";
        return userAgent;
    }

    public Boolean gzipEnabled() {
        String[] tokens;
        String acceptEncoding;
        Boolean gzipEnabled = false;
        if (this.sparkRequest != null && !(acceptEncoding = this.headers().string("Accept-Encoding", "")).isEmpty() && Arrays.stream(tokens = acceptEncoding.split(",")).map(String::trim).anyMatch(s -> s.equalsIgnoreCase("gzip"))) {
            return true;
        }
        return gzipEnabled;
    }
}

