/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.impl;

import as.leap.code.LASException;
import as.leap.code.impl.LASJsonParser;
import com.fasterxml.jackson.databind.JsonNode;

public class GlobalConfig {
    private String applicationName;
    private String applicationID;
    private String applicationKey;
    private String packageHook;
    private String packageEntity;
    private String codeMain;
    private String version;
    private String configJsonStr;

    public GlobalConfig() {
    }

    public GlobalConfig(String jsonStr) {
        this(LASJsonParser.asJsonNode(jsonStr));
        this.configJsonStr = jsonStr;
    }

    public GlobalConfig(JsonNode jsonNode) {
        if (!jsonNode.has("applicationId")) {
            throw new LASException("Your applicationId is miss.Please check your global.json config.");
        }
        this.applicationID = jsonNode.get("applicationId").asText();
        if (this.applicationID == null || this.applicationID.trim().equals("")) {
            throw new LASException("Your applicationId is empty.Please check your global.json config.");
        }
        if (!jsonNode.has("applicationKey")) {
            throw new LASException("Your applicationKey is miss.Please check your global.json config.");
        }
        this.applicationKey = jsonNode.get("applicationKey").asText();
        if (this.applicationKey == null || this.applicationKey.trim().equals("")) {
            throw new LASException("Your applicationKey is empty.Please check your global.json config.");
        }
        if (!jsonNode.has("applicationName")) {
            throw new LASException("Your applicationName is miss.Please check your global.json config.");
        }
        this.applicationName = jsonNode.get("applicationName").asText();
        if (this.applicationName == null || this.applicationName.trim().equals("")) {
            throw new LASException("Your applicationName is empty.Please check your global.json config.");
        }
        if (!jsonNode.has("java-main")) {
            throw new LASException("Your java-main is miss.Please check your global.json config.");
        }
        this.codeMain = jsonNode.get("java-main").asText();
        if (this.codeMain == null || this.codeMain.trim().equals("")) {
            throw new LASException("Your java-main is empty.Please check your global.json config.");
        }
        this.packageHook = jsonNode.has("package-hook") ? jsonNode.path("package-hook").asText() : null;
        String string = this.packageEntity = jsonNode.has("package-entity") ? jsonNode.path("package-entity").asText() : null;
        if (!jsonNode.has("global") || !jsonNode.get("global").has("zVersion")) {
            throw new LASException("Your global zVersion is miss.Please check your global.json config.");
        }
        this.version = jsonNode.get("global").get("zVersion").asText();
        if (this.version == null || this.version.trim().equals("")) {
            throw new LASException("Your global zVersion is empty.Please check your global.json config.");
        }
        this.configJsonStr = jsonNode.toString();
    }

    public String getConfigJsonStr() {
        return this.configJsonStr;
    }

    public void setConfigJsonStr(String configJsonStr) {
        this.configJsonStr = configJsonStr;
    }

    public String getCodeMain() {
        return this.codeMain;
    }

    public void setCodeMain(String codeMain) {
        this.codeMain = codeMain;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationID() {
        return this.applicationID;
    }

    public void setApplicationID(String applicationID) {
        this.applicationID = applicationID;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public String getPackageHook() {
        return this.packageHook;
    }

    public void setPackageHook(String packageHook) {
        this.packageHook = packageHook;
    }

    public String getPackageEntity() {
        return this.packageEntity;
    }

    public void setPackageEntity(String packageEntity) {
        this.packageEntity = packageEntity;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "GlobalConfig{applicationName='" + this.applicationName + '\'' + ", applicationID='" + this.applicationID + '\'' + ", applicationKey='" + this.applicationKey + '\'' + ", packageHook='" + this.packageHook + '\'' + ", packageEntity='" + this.packageEntity + '\'' + ", codeMain='" + this.codeMain + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

