/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.impl;

import as.leap.code.LogDelegate;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JULLogger
implements LogDelegate {
    private Logger logger;

    public JULLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void info(String message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void debug(String message) {
        this.log(Level.FINEST, message);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARNING, message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    @Override
    public void error(Object message) {
        this.log(Level.SEVERE, message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    private void log(Level level, Object message) {
        this.log(level, message, null);
    }

    private void log(Level level, Object message, Throwable t) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        String msg = message == null ? "NULL" : message.toString();
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.logger.getName());
        record.setThrown(t);
        this.logger.log(record);
    }
}

