/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.impl;

import as.leap.code.Request;
import as.leap.code.impl.LASJsonParser;
import java.util.Map;

public class LASRequest
implements Request {
    private String originParams;
    private boolean useMasterKey;

    public LASRequest(String originParams) {
        this.originParams = originParams;
    }

    @Override
    public <T> T parameter(Class<T> clazz) {
        Map<String, Object> value;
        if (this.originParams == null) {
            return null;
        }
        if (clazz.equals(String.class)) {
            value = this.originParams;
        } else if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            value = Integer.valueOf(this.originParams);
        } else if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            value = Float.valueOf(this.originParams);
        } else if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            value = Long.valueOf(this.originParams);
        } else if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            value = Boolean.valueOf(this.originParams);
        } else if (clazz.equals(Void.class)) {
            value = null;
        } else if (clazz.equals(Map.class)) {
            value = LASJsonParser.jsonNodeToMap(LASJsonParser.asJsonNode(this.originParams));
        } else {
            try {
                value = LASJsonParser.asObject(this.originParams, clazz);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("can not convert parameter to Java Object. " + this.originParams, e);
            }
        }
        return (T)value;
    }

    @Override
    public boolean isUseMasterKey() {
        return this.useMasterKey;
    }

    @Override
    public void useMasterKey() {
        this.useMasterKey = true;
    }
}

