/*
 * Decompiled with CFR 0.152.
 */
package as.leap.vertx.rpc.impl;

import as.leap.vertx.rpc.WireProtocol;
import io.vertx.core.Vertx;

public class RPCClientOptions<T> {
    private Vertx vertx;
    private String busAddress;
    private Class<T> serviceClass;
    private long timeout = 10000L;
    private WireProtocol wireProtocol = WireProtocol.PROTOBUF;

    public RPCClientOptions(Vertx vertx) {
        this.vertx = vertx;
    }

    public RPCClientOptions(Vertx vertx, RPCClientOptions<T> other) {
        this.vertx = vertx;
        this.busAddress = other.getBusAddress();
        this.timeout = other.getTimeout();
        this.wireProtocol = other.getWireProtocol();
        this.serviceClass = other.getServiceClass();
    }

    public RPCClientOptions<T> setBusAddress(String busAddress) {
        this.busAddress = busAddress;
        return this;
    }

    public RPCClientOptions<T> setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public RPCClientOptions<T> setServiceClass(Class<T> serviceClass) {
        this.serviceClass = serviceClass;
        return this;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public String getBusAddress() {
        return this.busAddress;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Class<T> getServiceClass() {
        return this.serviceClass;
    }

    public WireProtocol getWireProtocol() {
        return this.wireProtocol;
    }

    public RPCClientOptions<T> setWireProtocol(WireProtocol wireProtocol) {
        this.wireProtocol = wireProtocol;
        return this;
    }
}

