/*
 * Decompiled with CFR 0.152.
 */
package as.leap.vertx.rpc.impl;

import as.leap.vertx.rpc.WireProtocol;
import as.leap.vertx.rpc.impl.SharedWrapper;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.LocalMap;

public class RPCServerOptions {
    private Vertx vertx;
    private String busAddress;
    private int maxBufferedMessages;
    private static final String SERVICE_MAP_NAME = "VERTX_RPC_SERVICE";
    private WireProtocol wireProtocol = WireProtocol.PROTOBUF;
    LocalMap<String, SharedWrapper> serviceMapping;

    public RPCServerOptions(Vertx vertx) {
        this.vertx = vertx;
        this.serviceMapping = vertx.sharedData().getLocalMap(SERVICE_MAP_NAME);
    }

    public RPCServerOptions(Vertx vertx, RPCServerOptions other) {
        this.vertx = vertx;
        this.busAddress = other.getBusAddress();
        this.wireProtocol = other.getWireProtocol();
        this.serviceMapping = vertx.sharedData().getLocalMap(SERVICE_MAP_NAME);
    }

    LocalMap<String, SharedWrapper> getServiceMapping() {
        return this.serviceMapping;
    }

    public RPCServerOptions addService(Object service) {
        this.serviceMapping.put((Object)service.getClass().getInterfaces()[0].getCanonicalName(), new SharedWrapper<Object>(service));
        return this;
    }

    public int getMaxBufferedMessages() {
        return this.maxBufferedMessages;
    }

    public RPCServerOptions setMaxBufferedMessages(int maxBufferedMessages) {
        this.maxBufferedMessages = maxBufferedMessages;
        return this;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public RPCServerOptions setBusAddress(String busAddress) {
        this.busAddress = busAddress;
        return this;
    }

    public String getBusAddress() {
        return this.busAddress;
    }

    public WireProtocol getWireProtocol() {
        return this.wireProtocol;
    }

    public RPCServerOptions setWireProtocol(WireProtocol wireProtocol) {
        this.wireProtocol = wireProtocol;
        return this;
    }
}

