/*
 * Decompiled with CFR 0.152.
 */
package as.leap.vertx.rpc.impl;

import as.leap.vertx.rpc.RPCServer;
import as.leap.vertx.rpc.VertxRPCException;
import as.leap.vertx.rpc.impl.RPCBase;
import as.leap.vertx.rpc.impl.RPCRequest;
import as.leap.vertx.rpc.impl.RPCResponse;
import as.leap.vertx.rpc.impl.RPCServerOptions;
import as.leap.vertx.rpc.impl.SharedWrapper;
import as.leap.vertx.rpc.impl.WrapperType;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import rx.Observable;

public class VertxRPCServer
extends RPCBase
implements RPCServer {
    private static final Logger log = LoggerFactory.getLogger(VertxRPCServer.class);
    private final LocalMap<String, SharedWrapper> serviceMapping;
    private final MessageConsumer<byte[]> consumer;

    public VertxRPCServer(RPCServerOptions options) {
        super(options.getWireProtocol());
        this.checkBusAddress(options.getBusAddress());
        if (options.getServiceMapping().size() == 0) {
            throw new VertxRPCException("please add service implementation to RPCServerOptions.");
        }
        this.serviceMapping = options.getServiceMapping();
        this.consumer = options.getVertx().eventBus().consumer(options.getBusAddress());
        this.consumer.setMaxBufferedMessages(options.getMaxBufferedMessages());
        this.registryService();
    }

    private void registryService() {
        this.consumer.handler(message -> {
            try {
                RPCRequest request = this.asObject((byte[])message.body(), RPCRequest.class);
                this.call(request, (Message<byte[]>)message);
            }
            catch (Exception e) {
                this.replyFail(e, (Message<byte[]>)message);
            }
        });
    }

    private <T> void call(RPCRequest request, Message<byte[]> message) {
        try {
            Object service = ((SharedWrapper)this.serviceMapping.get((Object)request.getServiceName())).getValue();
            Class[] argClasses = new Class[]{};
            Object[] args = new Object[]{};
            if (request.getArgs() != null && request.getArgs().size() > 0) {
                List<Object> argList = request.getArgs();
                int argCount = argList.size() / 2;
                args = new Object[argCount];
                argClasses = new Class[argCount];
                for (int i = 0; i < argList.size(); i += 2) {
                    Class<?> argClass;
                    int index = i / 2;
                    String argClassName = (String)argList.get(i);
                    byte[] argBytes = (byte[])argList.get(i + 1);
                    Object arg = this.asObject(argBytes, argClass = Class.forName(argClassName));
                    if (arg instanceof WrapperType) {
                        argClasses[index] = ((WrapperType)arg).getClazz();
                        args[index] = ((WrapperType)arg).getValue();
                        continue;
                    }
                    argClasses[index] = arg.getClass();
                    args[index] = arg;
                }
            }
            switch (RPCBase.CallbackType.valueOf(message.headers().get("callbackType"))) {
                case REACTIVE: {
                    Observable observable = (Observable)service.getClass().getMethod(request.getMethodName(), argClasses).invoke(service, args);
                    observable.subscribe(result -> this.replySuccess(result, message), ex -> this.replyFail((Throwable)ex, message));
                    break;
                }
                case ASYNC_HANDLER: {
                    argClasses = Arrays.copyOf(argClasses, argClasses.length + 1);
                    argClasses[argClasses.length - 1] = Handler.class;
                    args = Arrays.copyOf(args, args.length + 1);
                    args[args.length - 1] = event -> {
                        if (event.succeeded()) {
                            this.replySuccess(event.result(), message);
                        } else {
                            this.replyFail(event.cause(), message);
                        }
                    };
                    service.getClass().getMethod(request.getMethodName(), argClasses).invoke(service, args);
                    break;
                }
                case COMPLETABLE_FUTURE: {
                    CompletableFuture future = (CompletableFuture)service.getClass().getMethod(request.getMethodName(), argClasses).invoke(service, args);
                    future.whenComplete((result, ex) -> {
                        if (ex != null) {
                            this.replyFail((Throwable)ex, message);
                        } else {
                            this.replySuccess(result, message);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            this.replyFail(e, message);
        }
    }

    private <T> void replySuccess(T result, Message<byte[]> message) {
        byte[] resultBytes = new byte[]{};
        try {
            String resultClassName;
            if (Optional.ofNullable(result).isPresent()) {
                Class<?> resultClass = result.getClass();
                resultClassName = this.isWrapType(resultClass) ? WrapperType.class.getName() : resultClass.getName();
                resultBytes = this.asBytes(result);
            } else {
                resultClassName = WrapperType.class.getName();
            }
            RPCResponse response = new RPCResponse(resultClassName, resultBytes);
            byte[] responseBytes = this.asBytes(response);
            message.reply((Object)responseBytes);
        }
        catch (Exception e) {
            this.replyFail(e, message);
        }
    }

    private void replyFail(Throwable ex, Message<byte[]> message) {
        log.error((Object)ex.getMessage(), ex);
        Throwable realEx = ex.getCause() != null && !ex.getCause().equals(ex) ? ex.getCause() : ex;
        message.fail(500, realEx.getClass().getName() + "|" + (realEx.getMessage() == null ? realEx.getStackTrace()[0].getMethodName() : realEx.getMessage()));
    }

    @Override
    public void shutdown(Handler<AsyncResult<Void>> handler) {
        if (Optional.ofNullable(handler).isPresent()) {
            this.consumer.unregister(handler);
        } else {
            this.consumer.unregister();
        }
    }
}

