/*
 * Decompiled with CFR 0.152.
 */
package asia.hombre.kyber;

import asia.hombre.kyber.KyberParameter;
import asia.hombre.kyber.exceptions.UnsupportedKyberVariantException;
import asia.hombre.kyber.interfaces.Convertible;
import asia.hombre.kyber.internal.KyberMath;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0000J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lasia/hombre/kyber/KyberCipherText;", "Lasia/hombre/kyber/interfaces/Convertible;", "parameter", "Lasia/hombre/kyber/KyberParameter;", "encodedCoefficients", "", "encodedTerms", "(Lasia/hombre/kyber/KyberParameter;[B[B)V", "getEncodedCoefficients$KyberKotlin", "()[B", "getEncodedTerms$KyberKotlin", "fullBytes", "getFullBytes", "getParameter", "()Lasia/hombre/kyber/KyberParameter;", "copy", "equals", "", "other", "", "hashCode", "", "toBase64", "", "toHex", "isUppercase", "toString", "Companion", "KyberKotlin"})
public final class KyberCipherText
implements Convertible {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KyberParameter parameter;
    @NotNull
    private final byte[] encodedCoefficients;
    @NotNull
    private final byte[] encodedTerms;

    public KyberCipherText(@NotNull KyberParameter parameter, @NotNull byte[] encodedCoefficients, @NotNull byte[] encodedTerms) {
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)encodedCoefficients, (String)"encodedCoefficients");
        Intrinsics.checkNotNullParameter((Object)encodedTerms, (String)"encodedTerms");
        this.parameter = parameter;
        byte[] byArray = Arrays.copyOf(encodedCoefficients, encodedCoefficients.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        this.encodedCoefficients = byArray;
        byte[] byArray2 = Arrays.copyOf(encodedTerms, encodedTerms.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        this.encodedTerms = byArray2;
    }

    @NotNull
    public final KyberParameter getParameter() {
        return this.parameter;
    }

    @NotNull
    public final byte[] getEncodedCoefficients$KyberKotlin() {
        return this.encodedCoefficients;
    }

    @NotNull
    public final byte[] getEncodedTerms$KyberKotlin() {
        return this.encodedTerms;
    }

    @JvmName(name="getFullBytes")
    @NotNull
    public final byte[] getFullBytes() {
        byte[] output = new byte[this.parameter.CIPHERTEXT_LENGTH];
        ArraysKt.copyInto$default((byte[])this.encodedCoefficients, (byte[])output, (int)0, (int)0, (int)0, (int)12, null);
        ArraysKt.copyInto$default((byte[])this.encodedTerms, (byte[])output, (int)this.encodedCoefficients.length, (int)0, (int)0, (int)12, null);
        return output;
    }

    @Override
    @NotNull
    public String toHex(boolean isUppercase) {
        return HexExtensionsKt.toHexString((byte[])this.getFullBytes(), (HexFormat)(isUppercase ? HexFormat.Companion.getUpperCase() : HexFormat.Companion.getDefault()));
    }

    @Override
    @NotNull
    public String toBase64() {
        return Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])this.getFullBytes(), (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public final KyberCipherText copy() {
        byte[] byArray = Arrays.copyOf(this.encodedCoefficients, this.encodedCoefficients.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        byte[] byArray2 = Arrays.copyOf(this.encodedTerms, this.encodedTerms.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        return new KyberCipherText(this.parameter, byArray, byArray2);
    }

    @NotNull
    public String toString() {
        return Convertible.DefaultImpls.toHex$default(this, false, 1, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KyberCipherText cfr_ignored_0 = (KyberCipherText)other;
        if (this.parameter != ((KyberCipherText)other).parameter) {
            return false;
        }
        if (!Arrays.equals(this.encodedCoefficients, ((KyberCipherText)other).encodedCoefficients)) {
            return false;
        }
        return Arrays.equals(this.encodedTerms, ((KyberCipherText)other).encodedTerms);
    }

    public int hashCode() {
        int result = this.parameter.hashCode();
        result = 31 * result + Arrays.hashCode(this.encodedCoefficients);
        result = 31 * result + Arrays.hashCode(this.encodedTerms);
        return result;
    }

    @JvmStatic
    @NotNull
    public static final KyberCipherText fromBytes(@NotNull byte[] bytes) throws UnsupportedKyberVariantException {
        return Companion.fromBytes(bytes);
    }

    @JvmStatic
    @NotNull
    public static final KyberCipherText fromHex(@NotNull String hexString) throws UnsupportedKyberVariantException, IllegalArgumentException {
        return Companion.fromHex(hexString);
    }

    @JvmStatic
    @NotNull
    public static final KyberCipherText fromBase64(@NotNull String base64String) throws UnsupportedKyberVariantException, IllegalArgumentException {
        return Companion.fromBase64(base64String);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lasia/hombre/kyber/KyberCipherText$Companion;", "", "()V", "fromBase64", "Lasia/hombre/kyber/KyberCipherText;", "base64String", "", "fromBytes", "bytes", "", "fromHex", "hexString", "KyberKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KyberCipherText fromBytes(@NotNull byte[] bytes) throws UnsupportedKyberVariantException {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            KyberParameter parameter = KyberParameter.Companion.findByCipherTextSize(bytes.length);
            int encodedCoefficientsSize = 32 * (parameter.getDU() * parameter.getK());
            byte[] byArray = bytes;
            int n = 0;
            byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)encodedCoefficientsSize);
            byArray = bytes;
            n = bytes.length;
            return new KyberCipherText(KyberParameter.Companion.findByCipherTextSize(bytes.length), byArray2, ArraysKt.copyOfRange((byte[])byArray, (int)encodedCoefficientsSize, (int)n));
        }

        @JvmStatic
        @NotNull
        public final KyberCipherText fromHex(@NotNull String hexString) throws UnsupportedKyberVariantException, IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
            return this.fromBytes(KyberMath.Companion.decodeHex(hexString));
        }

        @JvmStatic
        @NotNull
        public final KyberCipherText fromBase64(@NotNull String base64String) throws UnsupportedKyberVariantException, IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)base64String, (String)"base64String");
            return this.fromBytes(Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)base64String, (int)0, (int)0, (int)6, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

