/*
 * Decompiled with CFR 0.152.
 */
package asia.hombre.kyber;

import asia.hombre.keccak.api.SHA3_256;
import asia.hombre.kyber.KyberCipherText;
import asia.hombre.kyber.KyberDecryptionKey;
import asia.hombre.kyber.KyberEncryptionKey;
import asia.hombre.kyber.KyberParameter;
import asia.hombre.kyber.exceptions.InvalidKyberKeyException;
import asia.hombre.kyber.exceptions.UnsupportedKyberVariantException;
import asia.hombre.kyber.interfaces.KyberKEMKey;
import asia.hombre.kyber.internal.KyberAgreement;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bJ\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010\u00a8\u0006#"}, d2={"Lasia/hombre/kyber/KyberDecapsulationKey;", "Lasia/hombre/kyber/interfaces/KyberKEMKey;", "key", "Lasia/hombre/kyber/KyberDecryptionKey;", "encryptionKey", "Lasia/hombre/kyber/KyberEncryptionKey;", "hash", "", "randomSeed", "<init>", "(Lasia/hombre/kyber/KyberDecryptionKey;Lasia/hombre/kyber/KyberEncryptionKey;[B[B)V", "getKey", "()Lasia/hombre/kyber/KyberDecryptionKey;", "getEncryptionKey", "()Lasia/hombre/kyber/KyberEncryptionKey;", "getHash$KyberKotlin", "()[B", "getRandomSeed$KyberKotlin", "parameter", "Lasia/hombre/kyber/KyberParameter;", "getParameter", "()Lasia/hombre/kyber/KyberParameter;", "fullBytes", "getFullBytes", "copy", "decapsulate", "cipherText", "Lasia/hombre/kyber/KyberCipherText;", "equals", "", "other", "", "hashCode", "", "Companion", "KyberKotlin"})
public final class KyberDecapsulationKey
implements KyberKEMKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KyberDecryptionKey key;
    @NotNull
    private final KyberEncryptionKey encryptionKey;
    @NotNull
    private final byte[] hash;
    @NotNull
    private final byte[] randomSeed;
    @NotNull
    private final KyberParameter parameter;

    public KyberDecapsulationKey(@NotNull KyberDecryptionKey key, @NotNull KyberEncryptionKey encryptionKey, @NotNull byte[] hash, @NotNull byte[] randomSeed) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)randomSeed, (String)"randomSeed");
        this.key = key;
        this.encryptionKey = encryptionKey;
        byte[] byArray = Arrays.copyOf(hash, hash.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        this.hash = byArray;
        byte[] byArray2 = Arrays.copyOf(randomSeed, randomSeed.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        this.randomSeed = byArray2;
        byte[] ekHash = new SHA3_256(0, 1, null).digest(this.encryptionKey.getFullBytes());
        if (!Arrays.equals(ekHash, hash)) {
            throw new InvalidKyberKeyException("Hash Check failed! This is not a valid Decapsulation Key.");
        }
        this.parameter = this.getKey().getParameter();
    }

    @Override
    @NotNull
    public KyberDecryptionKey getKey() {
        return this.key;
    }

    @NotNull
    public final KyberEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    @NotNull
    public final byte[] getHash$KyberKotlin() {
        return this.hash;
    }

    @NotNull
    public final byte[] getRandomSeed$KyberKotlin() {
        return this.randomSeed;
    }

    @NotNull
    public final KyberParameter getParameter() {
        return this.parameter;
    }

    @JvmName(name="getFullBytes")
    @NotNull
    public final byte[] getFullBytes() {
        byte[] output = new byte[this.getKey().getParameter().DECAPSULATION_KEY_LENGTH];
        ArraysKt.copyInto$default((byte[])this.getKey().getKeyBytes$KyberKotlin(), (byte[])output, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.copyInto$default((byte[])this.encryptionKey.getFullBytes(), (byte[])output, (int)this.getKey().getKeyBytes$KyberKotlin().length, (int)0, (int)0, (int)12, null);
        ArraysKt.copyInto$default((byte[])this.hash, (byte[])output, (int)(this.getKey().getKeyBytes$KyberKotlin().length + this.encryptionKey.getFullBytes().length), (int)0, (int)0, (int)12, null);
        ArraysKt.copyInto$default((byte[])this.randomSeed, (byte[])output, (int)(output.length - this.randomSeed.length), (int)0, (int)0, (int)12, null);
        return output;
    }

    @NotNull
    public final KyberDecapsulationKey copy() {
        return new KyberDecapsulationKey(this.getKey().copy(), this.encryptionKey, this.hash, this.randomSeed);
    }

    @NotNull
    public final byte[] decapsulate(@NotNull KyberCipherText cipherText) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        return KyberAgreement.INSTANCE.decapsulate$KyberKotlin(this, cipherText);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KyberDecapsulationKey cfr_ignored_0 = (KyberDecapsulationKey)other;
        if (!Intrinsics.areEqual((Object)this.getKey(), (Object)((KyberDecapsulationKey)other).getKey())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.encryptionKey, (Object)((KyberDecapsulationKey)other).encryptionKey)) {
            return false;
        }
        if (!Arrays.equals(this.hash, ((KyberDecapsulationKey)other).hash)) {
            return false;
        }
        if (!Arrays.equals(this.randomSeed, ((KyberDecapsulationKey)other).randomSeed)) {
            return false;
        }
        return this.parameter == ((KyberDecapsulationKey)other).parameter;
    }

    public int hashCode() {
        int result = this.getKey().hashCode();
        result = 31 * result + this.encryptionKey.hashCode();
        result = 31 * result + Arrays.hashCode(this.hash);
        result = 31 * result + Arrays.hashCode(this.randomSeed);
        result = 31 * result + this.parameter.hashCode();
        return result;
    }

    @JvmStatic
    @NotNull
    public static final KyberDecapsulationKey fromBytes(@NotNull byte[] bytes) throws UnsupportedKyberVariantException, InvalidKyberKeyException {
        return Companion.fromBytes(bytes);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lasia/hombre/kyber/KyberDecapsulationKey$Companion;", "", "<init>", "()V", "fromBytes", "Lasia/hombre/kyber/KyberDecapsulationKey;", "bytes", "", "KyberKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KyberDecapsulationKey fromBytes(@NotNull byte[] bytes) throws UnsupportedKyberVariantException, InvalidKyberKeyException {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            KyberParameter parameter = KyberParameter.Companion.findByDecapsulationKeySize(bytes.length);
            byte[] byArray = bytes;
            int n = 0;
            int n2 = parameter.DECRYPTION_KEY_LENGTH;
            KyberDecryptionKey decryptionKey = KyberDecryptionKey.Companion.fromBytes(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
            byte[] byArray2 = bytes;
            n2 = parameter.DECRYPTION_KEY_LENGTH;
            int n3 = parameter.DECRYPTION_KEY_LENGTH + parameter.ENCRYPTION_KEY_LENGTH;
            KyberEncryptionKey encryptionKey = KyberEncryptionKey.Companion.fromBytes(ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3));
            byte[] byArray3 = bytes;
            n3 = bytes.length - 64;
            int n4 = bytes.length - 32;
            byte[] hash = ArraysKt.copyOfRange((byte[])byArray3, (int)n3, (int)n4);
            byte[] byArray4 = bytes;
            n4 = bytes.length - 32;
            int n5 = bytes.length;
            byte[] randomSeed = ArraysKt.copyOfRange((byte[])byArray4, (int)n4, (int)n5);
            return new KyberDecapsulationKey(decryptionKey, encryptionKey, hash, randomSeed);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

