/*
 * Decompiled with CFR 0.152.
 */
package asia.hombre.kyber;

import asia.hombre.kyber.KyberParameter;
import asia.hombre.kyber.exceptions.InvalidKyberKeyException;
import asia.hombre.kyber.exceptions.UnsupportedKyberVariantException;
import asia.hombre.kyber.interfaces.KyberPKEKey;
import asia.hombre.kyber.internal.KyberMath;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0000J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0018"}, d2={"Lasia/hombre/kyber/KyberEncryptionKey;", "Lasia/hombre/kyber/interfaces/KyberPKEKey;", "parameter", "Lasia/hombre/kyber/KyberParameter;", "keyBytes", "", "nttSeed", "<init>", "(Lasia/hombre/kyber/KyberParameter;[B[B)V", "getParameter", "()Lasia/hombre/kyber/KyberParameter;", "getKeyBytes$KyberKotlin", "()[B", "getNttSeed$KyberKotlin", "fullBytes", "getFullBytes", "copy", "equals", "", "other", "", "hashCode", "", "Companion", "KyberKotlin"})
public final class KyberEncryptionKey
implements KyberPKEKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KyberParameter parameter;
    @NotNull
    private final byte[] keyBytes;
    @NotNull
    private final byte[] nttSeed;

    public KyberEncryptionKey(@NotNull KyberParameter parameter, @NotNull byte[] keyBytes, @NotNull byte[] nttSeed) {
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)keyBytes, (String)"keyBytes");
        Intrinsics.checkNotNullParameter((Object)nttSeed, (String)"nttSeed");
        this.parameter = parameter;
        byte[] byArray = Arrays.copyOf(keyBytes, keyBytes.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        this.keyBytes = byArray;
        byte[] byArray2 = Arrays.copyOf(nttSeed, nttSeed.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        this.nttSeed = byArray2;
        for (int c : KyberMath.INSTANCE.byteDecode(keyBytes, 12)) {
            if (KyberMath.INSTANCE.isModuloOfQ(c)) continue;
            throw new InvalidKyberKeyException("Not modulus of 3329");
        }
    }

    @Override
    @NotNull
    public KyberParameter getParameter() {
        return this.parameter;
    }

    @NotNull
    public final byte[] getKeyBytes$KyberKotlin() {
        return this.keyBytes;
    }

    @NotNull
    public final byte[] getNttSeed$KyberKotlin() {
        return this.nttSeed;
    }

    @JvmName(name="getFullBytes")
    @NotNull
    public final byte[] getFullBytes() {
        byte[] output = new byte[this.getParameter().ENCAPSULATION_KEY_LENGTH];
        ArraysKt.copyInto$default((byte[])this.keyBytes, (byte[])output, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.copyInto$default((byte[])this.nttSeed, (byte[])output, (int)this.keyBytes.length, (int)0, (int)0, (int)12, null);
        return output;
    }

    @NotNull
    public final KyberEncryptionKey copy() {
        return new KyberEncryptionKey(this.getParameter(), this.keyBytes, this.nttSeed);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KyberEncryptionKey cfr_ignored_0 = (KyberEncryptionKey)other;
        if (this.getParameter() != ((KyberEncryptionKey)other).getParameter()) {
            return false;
        }
        if (!Arrays.equals(this.keyBytes, ((KyberEncryptionKey)other).keyBytes)) {
            return false;
        }
        return Arrays.equals(this.nttSeed, ((KyberEncryptionKey)other).nttSeed);
    }

    public int hashCode() {
        int result = this.getParameter().hashCode();
        result = 31 * result + Arrays.hashCode(this.keyBytes);
        result = 31 * result + Arrays.hashCode(this.nttSeed);
        return result;
    }

    @JvmStatic
    @NotNull
    public static final KyberEncryptionKey fromBytes(@NotNull byte[] bytes) throws UnsupportedKyberVariantException, InvalidKyberKeyException {
        return Companion.fromBytes(bytes);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lasia/hombre/kyber/KyberEncryptionKey$Companion;", "", "<init>", "()V", "fromBytes", "Lasia/hombre/kyber/KyberEncryptionKey;", "bytes", "", "KyberKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KyberEncryptionKey fromBytes(@NotNull byte[] bytes) throws UnsupportedKyberVariantException, InvalidKyberKeyException {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            int keyLength = bytes.length - 32;
            byte[] byArray = bytes;
            int n = 0;
            byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)keyLength);
            byArray = bytes;
            n = bytes.length;
            return new KyberEncryptionKey(KyberParameter.Companion.findByEncryptionKeySize(bytes.length), byArray2, ArraysKt.copyOfRange((byte[])byArray, (int)keyLength, (int)n));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

