/*
 * Decompiled with CFR 0.152.
 */
package asia.hombre.kyber;

import asia.hombre.keccak.api.SHA3_256;
import asia.hombre.keccak.api.SHA3_512;
import asia.hombre.kyber.KyberDecapsulationKey;
import asia.hombre.kyber.KyberDecryptionKey;
import asia.hombre.kyber.KyberEncapsulationKey;
import asia.hombre.kyber.KyberEncryptionKey;
import asia.hombre.kyber.KyberKEMKeyPair;
import asia.hombre.kyber.KyberPKEKeyPair;
import asia.hombre.kyber.KyberParameter;
import asia.hombre.kyber.internal.KyberMath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.random.CryptoRand;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J%\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lasia/hombre/kyber/KyberKeyGenerator;", "", "<init>", "()V", "generate", "Lasia/hombre/kyber/KyberKEMKeyPair;", "parameter", "Lasia/hombre/kyber/KyberParameter;", "randomSeed", "", "pkeSeed", "generate$KyberKotlin", "PKEGenerator", "KyberKotlin"})
@SourceDebugExtension(value={"SMAP\nKyberKeyGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KyberKeyGenerator.kt\nasia/hombre/kyber/KyberKeyGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class KyberKeyGenerator {
    @NotNull
    public static final KyberKeyGenerator INSTANCE = new KyberKeyGenerator();

    private KyberKeyGenerator() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final KyberKEMKeyPair generate(@NotNull KyberParameter parameter) {
        void $this$generate_u24lambda_u241;
        byte[] $this$generate_u24lambda_u240;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        byte[] byArray2 = byArray = new byte[32];
        KyberParameter kyberParameter = parameter;
        KyberKeyGenerator kyberKeyGenerator = INSTANCE;
        boolean bl = false;
        CryptoRand.Default.nextBytes($this$generate_u24lambda_u240);
        Object object = Unit.INSTANCE;
        byte[] byArray3 = byArray;
        $this$generate_u24lambda_u240 = byArray = new byte[32];
        object = byArray3;
        boolean bl2 = false;
        CryptoRand.Default.nextBytes((byte[])$this$generate_u24lambda_u241);
        Unit unit = Unit.INSTANCE;
        return kyberKeyGenerator.generate$KyberKotlin(kyberParameter, (byte[])object, byArray);
    }

    public final /* synthetic */ KyberKEMKeyPair generate$KyberKotlin(KyberParameter parameter, byte[] randomSeed, byte[] pkeSeed) {
        Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)randomSeed, (String)"randomSeed");
        Intrinsics.checkNotNullParameter((Object)pkeSeed, (String)"pkeSeed");
        KyberPKEKeyPair pkeKeyPair = PKEGenerator.INSTANCE.generate(parameter, pkeSeed);
        byte[] hash = new SHA3_256(0, 1, null).digest(pkeKeyPair.getEncryptionKey().getFullBytes());
        return new KyberKEMKeyPair(new KyberEncapsulationKey(pkeKeyPair.getEncryptionKey()), new KyberDecapsulationKey(pkeKeyPair.getDecryptionKey(), pkeKeyPair.getEncryptionKey(), hash, randomSeed));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lasia/hombre/kyber/KyberKeyGenerator$PKEGenerator;", "", "<init>", "()V", "generate", "Lasia/hombre/kyber/KyberPKEKeyPair;", "parameter", "Lasia/hombre/kyber/KyberParameter;", "byteArray", "", "KyberKotlin"})
    public static final class PKEGenerator {
        @NotNull
        public static final PKEGenerator INSTANCE = new PKEGenerator();

        private PKEGenerator() {
        }

        public final /* synthetic */ KyberPKEKeyPair generate(KyberParameter parameter, byte[] byteArray) {
            int i;
            int n;
            int n2;
            int n3;
            Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            byte[] seeds = new SHA3_512(0, 1, null).digest(byteArray);
            ArraysKt.fill$default((byte[])byteArray, (byte)0, (int)0, (int)0, (int)6, null);
            byte[] byArray = seeds;
            int n4 = 0;
            int n5 = 32;
            byte[] nttSeed = ArraysKt.copyOfRange((byte[])byArray, (int)n4, (int)n5);
            byte[] byArray2 = seeds;
            n5 = 32;
            int n6 = 64;
            byte[] cbdSeed = ArraysKt.copyOfRange((byte[])byArray2, (int)n5, (int)n6);
            ArraysKt.fill$default((byte[])seeds, (byte)0, (int)0, (int)0, (int)6, null);
            n6 = parameter.getK();
            int[][][] nArrayArray = new int[n6][][];
            for (n5 = 0; n5 < n6; ++n5) {
                int n7 = n5;
                n3 = 0;
                n2 = parameter.getK();
                int[][] nArrayArray2 = new int[n2][];
                int n8 = n7;
                int[][][] nArrayArray3 = nArrayArray;
                while (n3 < n2) {
                    n = n3++;
                    nArrayArray2[n] = new int[256];
                }
                nArrayArray3[n8] = nArrayArray2;
            }
            int[][][] matrix = nArrayArray;
            n6 = 0;
            int n9 = parameter.getK();
            int[][] nArrayArray4 = new int[n9][];
            while (n6 < n9) {
                n3 = n6++;
                nArrayArray4[n3] = new int[256];
            }
            int[][] secretVector = nArrayArray4;
            n9 = 0;
            int n10 = parameter.getK();
            int[][] nArrayArray5 = new int[n10][];
            while (n9 < n10) {
                n2 = n9++;
                nArrayArray5[n2] = new int[256];
            }
            int[][] noiseVector = nArrayArray5;
            n10 = parameter.getK();
            for (n9 = 0; n9 < n10; ++n9) {
                int nonce = n9;
                i = n9;
                n = parameter.getK();
                for (int j = 0; j < n; ++j) {
                    matrix[i][j] = KyberMath.INSTANCE.sampleNTT(KyberMath.INSTANCE.xof(nttSeed, (byte)i, (byte)j));
                }
                secretVector[i] = KyberMath.INSTANCE.samplePolyCBD(parameter.getETA1(), KyberMath.INSTANCE.prf(parameter.getETA1(), cbdSeed, (byte)nonce));
                secretVector[i] = KyberMath.INSTANCE.ntt(secretVector[i]);
                noiseVector[i] = KyberMath.INSTANCE.samplePolyCBD(parameter.getETA1(), KyberMath.INSTANCE.prf(parameter.getETA1(), cbdSeed, (byte)(nonce + parameter.getK())));
                noiseVector[i] = KyberMath.INSTANCE.ntt(noiseVector[i]);
            }
            ArraysKt.fill$default((byte[])cbdSeed, (byte)0, (int)0, (int)0, (int)6, null);
            int[][] systemVector = KyberMath.INSTANCE.vectorAddition(KyberMath.INSTANCE.nttMatrixToVectorDot(matrix, secretVector, true), noiseVector);
            byte[] encryptionKeyBytes = new byte[parameter.ENCRYPTION_KEY_LENGTH - 32];
            byte[] decryptionKeyBytes = new byte[parameter.DECRYPTION_KEY_LENGTH];
            int n11 = parameter.getK();
            for (i = 0; i < n11; ++i) {
                int n12 = parameter.getK();
                for (int j = 0; j < n12; ++j) {
                    ArraysKt.fill$default((int[])matrix[i][j], (int)0, (int)0, (int)0, (int)6, null);
                }
                ArraysKt.fill$default((int[])noiseVector[i], (int)0, (int)0, (int)0, (int)6, null);
                ArraysKt.copyInto$default((byte[])KyberMath.INSTANCE.byteEncode(KyberMath.INSTANCE.montVectorToVector(systemVector[i]), 12), (byte[])encryptionKeyBytes, (int)(i * 384), (int)0, (int)0, (int)12, null);
                ArraysKt.copyInto$default((byte[])KyberMath.INSTANCE.byteEncode(KyberMath.INSTANCE.montVectorToVector(secretVector[i]), 12), (byte[])decryptionKeyBytes, (int)(i * 384), (int)0, (int)0, (int)12, null);
            }
            return new KyberPKEKeyPair(new KyberEncryptionKey(parameter, encryptionKeyBytes, nttSeed), new KyberDecryptionKey(parameter, decryptionKeyBytes));
        }
    }
}

