/*
 * Decompiled with CFR 0.152.
 */
package asia.hombre.kyber;

import asia.hombre.kyber.exceptions.UnsupportedKyberVariantException;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\b\u0087\u0081\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0018B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0010\u0010\u0013\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0019"}, d2={"Lasia/hombre/kyber/KyberParameter;", "", "K", "", "ETA1", "ETA2", "DU", "DV", "<init>", "(Ljava/lang/String;IIIIII)V", "getK", "()I", "getETA1", "getETA2", "getDU", "getDV", "ML_KEM_512", "ML_KEM_768", "ML_KEM_1024", "CIPHERTEXT_LENGTH", "DECRYPTION_KEY_LENGTH", "ENCRYPTION_KEY_LENGTH", "ENCAPSULATION_KEY_LENGTH", "DECAPSULATION_KEY_LENGTH", "Companion", "KyberKotlin"})
public final class KyberParameter
extends Enum<KyberParameter> {
    @NotNull
    public static final Companion Companion;
    private final int K;
    private final int ETA1;
    private final int ETA2;
    private final int DU;
    private final int DV;
    @JvmField
    public final int CIPHERTEXT_LENGTH;
    @JvmField
    public final int DECRYPTION_KEY_LENGTH;
    @JvmField
    public final int ENCRYPTION_KEY_LENGTH;
    @JvmField
    public final int ENCAPSULATION_KEY_LENGTH;
    @JvmField
    public final int DECAPSULATION_KEY_LENGTH;
    public static final /* enum */ KyberParameter ML_KEM_512;
    public static final /* enum */ KyberParameter ML_KEM_768;
    public static final /* enum */ KyberParameter ML_KEM_1024;
    private static final /* synthetic */ KyberParameter[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private KyberParameter(int K, int ETA1, int ETA2, int DU, int DV) {
        this.K = K;
        this.ETA1 = ETA1;
        this.ETA2 = ETA2;
        this.DU = DU;
        this.DV = DV;
        this.CIPHERTEXT_LENGTH = 32 * (this.DU * this.K + this.DV);
        this.DECRYPTION_KEY_LENGTH = 384 * this.K;
        this.ENCAPSULATION_KEY_LENGTH = this.ENCRYPTION_KEY_LENGTH = this.DECRYPTION_KEY_LENGTH + 32;
        this.DECAPSULATION_KEY_LENGTH = this.ENCAPSULATION_KEY_LENGTH + this.DECRYPTION_KEY_LENGTH + 64;
    }

    public final int getK() {
        return this.K;
    }

    public final int getETA1() {
        return this.ETA1;
    }

    public final int getETA2() {
        return this.ETA2;
    }

    public final int getDU() {
        return this.DU;
    }

    public final int getDV() {
        return this.DV;
    }

    public static KyberParameter[] values() {
        return (KyberParameter[])$VALUES.clone();
    }

    public static KyberParameter valueOf(String value) {
        return Enum.valueOf(KyberParameter.class, value);
    }

    @NotNull
    public static EnumEntries<KyberParameter> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @NotNull
    public static final KyberParameter findByCipherTextSize(int length) throws UnsupportedKyberVariantException {
        return Companion.findByCipherTextSize(length);
    }

    @JvmStatic
    @NotNull
    public static final KyberParameter findByEncryptionKeySize(int length) throws UnsupportedKyberVariantException {
        return Companion.findByEncryptionKeySize(length);
    }

    @JvmStatic
    @NotNull
    public static final KyberParameter findByEncapsulationKeySize(int length) throws UnsupportedKyberVariantException {
        return Companion.findByEncapsulationKeySize(length);
    }

    @JvmStatic
    @NotNull
    public static final KyberParameter findByDecryptionKeySize(int length) throws UnsupportedKyberVariantException {
        return Companion.findByDecryptionKeySize(length);
    }

    @JvmStatic
    @NotNull
    public static final KyberParameter findByDecapsulationKeySize(int length) throws UnsupportedKyberVariantException {
        return Companion.findByDecapsulationKeySize(length);
    }

    static {
        ML_KEM_512 = new KyberParameter(2, 3, 2, 10, 4);
        ML_KEM_768 = new KyberParameter(3, 2, 2, 10, 4);
        ML_KEM_1024 = new KyberParameter(4, 2, 2, 11, 5);
        $VALUES = kyberParameterArray = new KyberParameter[]{KyberParameter.ML_KEM_512, KyberParameter.ML_KEM_768, KyberParameter.ML_KEM_1024};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\f"}, d2={"Lasia/hombre/kyber/KyberParameter$Companion;", "", "<init>", "()V", "findByCipherTextSize", "Lasia/hombre/kyber/KyberParameter;", "length", "", "findByEncryptionKeySize", "findByEncapsulationKeySize", "findByDecryptionKeySize", "findByDecapsulationKeySize", "KyberKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KyberParameter findByCipherTextSize(int length) throws UnsupportedKyberVariantException {
            KyberParameter kyberParameter;
            int n = length;
            if (n == KyberParameter.ML_KEM_512.CIPHERTEXT_LENGTH) {
                kyberParameter = ML_KEM_512;
            } else if (n == KyberParameter.ML_KEM_768.CIPHERTEXT_LENGTH) {
                kyberParameter = ML_KEM_768;
            } else if (n == KyberParameter.ML_KEM_1024.CIPHERTEXT_LENGTH) {
                kyberParameter = ML_KEM_1024;
            } else {
                throw new UnsupportedKyberVariantException("Cipher Text byte length is either bigger or smaller than expected.");
            }
            return kyberParameter;
        }

        @JvmStatic
        @NotNull
        public final KyberParameter findByEncryptionKeySize(int length) throws UnsupportedKyberVariantException {
            KyberParameter kyberParameter;
            int n = length;
            if (n == KyberParameter.ML_KEM_512.ENCAPSULATION_KEY_LENGTH) {
                kyberParameter = ML_KEM_512;
            } else if (n == KyberParameter.ML_KEM_768.ENCAPSULATION_KEY_LENGTH) {
                kyberParameter = ML_KEM_768;
            } else if (n == KyberParameter.ML_KEM_1024.ENCAPSULATION_KEY_LENGTH) {
                kyberParameter = ML_KEM_1024;
            } else {
                throw new UnsupportedKyberVariantException("Encryption Key byte length is either bigger or smaller than expected.");
            }
            return kyberParameter;
        }

        @JvmStatic
        @NotNull
        public final KyberParameter findByEncapsulationKeySize(int length) throws UnsupportedKyberVariantException {
            KyberParameter kyberParameter;
            try {
                kyberParameter = this.findByEncryptionKeySize(length);
            }
            catch (UnsupportedKyberVariantException exception) {
                throw new UnsupportedKyberVariantException("Encapsulation Key byte length is either bigger or smaller than expected.");
            }
            return kyberParameter;
        }

        @JvmStatic
        @NotNull
        public final KyberParameter findByDecryptionKeySize(int length) throws UnsupportedKyberVariantException {
            KyberParameter kyberParameter;
            int n = length;
            if (n == KyberParameter.ML_KEM_512.DECRYPTION_KEY_LENGTH) {
                kyberParameter = ML_KEM_512;
            } else if (n == KyberParameter.ML_KEM_768.DECRYPTION_KEY_LENGTH) {
                kyberParameter = ML_KEM_768;
            } else if (n == KyberParameter.ML_KEM_1024.DECRYPTION_KEY_LENGTH) {
                kyberParameter = ML_KEM_1024;
            } else {
                throw new UnsupportedKyberVariantException("Decryption Key byte length is either bigger or smaller than expected.");
            }
            return kyberParameter;
        }

        @JvmStatic
        @NotNull
        public final KyberParameter findByDecapsulationKeySize(int length) throws UnsupportedKyberVariantException {
            KyberParameter kyberParameter;
            int n = length;
            if (n == KyberParameter.ML_KEM_512.DECAPSULATION_KEY_LENGTH) {
                kyberParameter = ML_KEM_512;
            } else if (n == KyberParameter.ML_KEM_768.DECAPSULATION_KEY_LENGTH) {
                kyberParameter = ML_KEM_768;
            } else if (n == KyberParameter.ML_KEM_1024.DECAPSULATION_KEY_LENGTH) {
                kyberParameter = ML_KEM_1024;
            } else {
                throw new UnsupportedKyberVariantException("Decapsulation Key byte length is either bigger or smaller than expected.");
            }
            return kyberParameter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

