/*
 * Decompiled with CFR 0.152.
 */
package asia.hombre.kyber.internal;

import asia.hombre.keccak.api.SHA3_256;
import asia.hombre.keccak.api.SHA3_512;
import asia.hombre.keccak.api.SHAKE256;
import asia.hombre.kyber.KyberCipherText;
import asia.hombre.kyber.KyberDecapsulationKey;
import asia.hombre.kyber.KyberDecryptionKey;
import asia.hombre.kyber.KyberEncapsulationKey;
import asia.hombre.kyber.KyberEncapsulationResult;
import asia.hombre.kyber.KyberEncryptionKey;
import asia.hombre.kyber.KyberParameter;
import asia.hombre.kyber.internal.KyberMath;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001d\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0014J\u001d\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0018\u00a8\u0006\u0019"}, d2={"Lasia/hombre/kyber/internal/KyberAgreement;", "", "<init>", "()V", "toCipherText", "Lasia/hombre/kyber/KyberCipherText;", "encryptionKey", "Lasia/hombre/kyber/KyberEncryptionKey;", "plainText", "", "randomness", "fromCipherText", "decryptionKey", "Lasia/hombre/kyber/KyberDecryptionKey;", "kyberCipherText", "fromCipherText$KyberKotlin", "encapsulate", "Lasia/hombre/kyber/KyberEncapsulationResult;", "kyberEncapsulationKey", "Lasia/hombre/kyber/KyberEncapsulationKey;", "encapsulate$KyberKotlin", "decapsulate", "decapsulationKey", "Lasia/hombre/kyber/KyberDecapsulationKey;", "decapsulate$KyberKotlin", "KyberKotlin"})
public final class KyberAgreement {
    @NotNull
    public static final KyberAgreement INSTANCE = new KyberAgreement();

    private KyberAgreement() {
    }

    private final KyberCipherText toCipherText(KyberEncryptionKey encryptionKey, byte[] plainText, byte[] randomness) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        KyberParameter parameter = encryptionKey.getParameter();
        int[] decodedKey = KyberMath.INSTANCE.byteDecode(encryptionKey.getKeyBytes$KyberKotlin(), 12);
        int n6 = 0;
        int n7 = parameter.getK();
        int[][] nArrayArray = new int[n7][];
        while (n6 < n7) {
            n5 = n6++;
            nArrayArray[n5] = new int[256];
        }
        int[][] nttKeyVector = nArrayArray;
        byte[] nttSeed = encryptionKey.getNttSeed$KyberKotlin();
        n5 = parameter.getK();
        int[][][] nArrayArray2 = new int[n5][][];
        for (int i = 0; i < n5; ++i) {
            int n8 = i;
            n4 = 0;
            n3 = parameter.getK();
            int[][] nArrayArray3 = new int[n3][];
            int n9 = n8;
            int[][][] nArrayArray4 = nArrayArray2;
            while (n4 < n3) {
                n2 = n4++;
                nArrayArray3[n2] = new int[256];
            }
            nArrayArray4[n9] = nArrayArray3;
        }
        int[][][] matrix = nArrayArray2;
        n5 = 0;
        int n10 = parameter.getK();
        int[][] nArrayArray5 = new int[n10][];
        while (n5 < n10) {
            n4 = n5++;
            nArrayArray5[n4] = new int[256];
        }
        int[][] randomnessVector = nArrayArray5;
        n10 = 0;
        int n11 = parameter.getK();
        int[][] nArrayArray6 = new int[n11][];
        while (n10 < n11) {
            n3 = n10++;
            nArrayArray6[n3] = new int[256];
        }
        int[][] noiseVector = nArrayArray6;
        n11 = parameter.getK();
        for (n10 = 0; n10 < n11; ++n10) {
            int n12 = n10;
            int i = n10;
            ArraysKt.copyInto((int[])decodedKey, (int[])nttKeyVector[i], (int)0, (int)(256 * i), (int)(256 * (i + 1)));
            nttKeyVector[i] = KyberMath.INSTANCE.vectorToMontVector(nttKeyVector[i]);
            randomnessVector[i] = KyberMath.INSTANCE.samplePolyCBD(parameter.getETA1(), KyberMath.INSTANCE.prf(parameter.getETA1(), randomness, (byte)n12));
            randomnessVector[i] = KyberMath.INSTANCE.ntt(randomnessVector[i]);
            noiseVector[i] = KyberMath.INSTANCE.samplePolyCBD(parameter.getETA2(), KyberMath.INSTANCE.prf(parameter.getETA2(), randomness, (byte)(n12 + parameter.getK())));
            n2 = parameter.getK();
            for (int j = 0; j < n2; ++j) {
                matrix[i][j] = KyberMath.INSTANCE.sampleNTT(KyberMath.INSTANCE.xof(nttSeed, (byte)i, (byte)j));
            }
        }
        int[] noiseTerm = KyberMath.INSTANCE.samplePolyCBD(parameter.getETA2(), KyberMath.INSTANCE.prf(parameter.getETA2(), randomness, (byte)(parameter.getK() * 2 + 1)));
        int[] muse = KyberMath.INSTANCE.singleDecompress(KyberMath.INSTANCE.singleByteDecode(plainText));
        int[][] coefficients = KyberMath.nttMatrixToVectorDot$default(KyberMath.INSTANCE, matrix, randomnessVector, false, 4, null);
        int[] constantTerm = new int[256];
        n2 = parameter.getK();
        for (int i = 0; i < n2; ++i) {
            coefficients[i] = KyberMath.INSTANCE.nttInv(coefficients[i]);
            coefficients[i] = KyberMath.INSTANCE.vectorToVectorAdd(coefficients[i], noiseVector[i]);
            constantTerm = KyberMath.INSTANCE.vectorToVectorAdd(constantTerm, KyberMath.INSTANCE.multiplyNTTs(nttKeyVector[i], randomnessVector[i]));
            n = parameter.getK();
            for (int j = 0; j < n; ++j) {
                ArraysKt.fill$default((int[])matrix[i][j], (int)0, (int)0, (int)0, (int)6, null);
            }
            ArraysKt.fill$default((int[])noiseVector[i], (int)0, (int)0, (int)0, (int)6, null);
            ArraysKt.fill$default((int[])nttKeyVector[i], (int)0, (int)0, (int)0, (int)6, null);
            ArraysKt.fill$default((int[])randomnessVector[i], (int)0, (int)0, (int)0, (int)6, null);
        }
        constantTerm = KyberMath.INSTANCE.nttInv(constantTerm);
        constantTerm = KyberMath.INSTANCE.vectorToVectorAdd(constantTerm, noiseTerm);
        constantTerm = KyberMath.INSTANCE.vectorToVectorAdd(constantTerm, muse);
        ArraysKt.fill$default((int[])muse, (int)0, (int)0, (int)0, (int)6, null);
        byte[] encodedCoefficients = new byte[32 * (parameter.getDU() * parameter.getK())];
        byte[] encodedTerms = new byte[32 * parameter.getDV()];
        n = parameter.getK();
        for (int i = 0; i < n; ++i) {
            ArraysKt.copyInto$default((byte[])KyberMath.INSTANCE.byteEncode(KyberMath.INSTANCE.compress(KyberMath.INSTANCE.montVectorToVector(coefficients[i]), parameter.getDU()), parameter.getDU()), (byte[])encodedCoefficients, (int)(i * 32 * parameter.getDU()), (int)0, (int)0, (int)12, null);
        }
        ArraysKt.copyInto$default((byte[])KyberMath.INSTANCE.byteEncode(KyberMath.INSTANCE.compress(KyberMath.INSTANCE.montVectorToVector(constantTerm), parameter.getDV()), parameter.getDV()), (byte[])encodedTerms, (int)0, (int)0, (int)0, (int)14, null);
        return new KyberCipherText(parameter, encodedCoefficients, encodedTerms);
    }

    public final /* synthetic */ byte[] fromCipherText$KyberKotlin(KyberDecryptionKey decryptionKey, KyberCipherText kyberCipherText) {
        int n;
        Intrinsics.checkNotNullParameter((Object)decryptionKey, (String)"decryptionKey");
        Intrinsics.checkNotNullParameter((Object)kyberCipherText, (String)"kyberCipherText");
        KyberParameter parameter = kyberCipherText.getParameter();
        int n2 = 0;
        int n3 = kyberCipherText.getParameter().getK();
        Object object = new int[n3][];
        while (n2 < n3) {
            n = n2++;
            object[n] = new int[256];
        }
        int[][] coefficients = object;
        n3 = parameter.getK();
        for (int i = 0; i < n3; ++i) {
            object = kyberCipherText.getEncodedCoefficients$KyberKotlin();
            n = i * 32 * parameter.getDU();
            int n4 = (i + 1) * 32 * parameter.getDU();
            coefficients[i] = KyberMath.INSTANCE.decompress(KyberMath.INSTANCE.byteDecode(ArraysKt.copyOfRange((byte[])object, (int)n, (int)n4), parameter.getDU()), parameter.getDU());
            coefficients[i] = KyberMath.INSTANCE.vectorToMontVector(coefficients[i]);
        }
        int[] constantTerms = KyberMath.INSTANCE.decompress(KyberMath.INSTANCE.byteDecode(kyberCipherText.getEncodedTerms$KyberKotlin(), parameter.getDV()), parameter.getDV());
        constantTerms = KyberMath.INSTANCE.vectorToMontVector(constantTerms);
        int[] secretVector = KyberMath.INSTANCE.byteDecode(decryptionKey.getKeyBytes$KyberKotlin(), 12);
        n = parameter.getK();
        for (int i = 0; i < n; ++i) {
            int[] nArray = secretVector;
            int n5 = i * 256;
            int n6 = (i + 1) * 256;
            int[] subtraction = KyberMath.INSTANCE.nttInv(KyberMath.INSTANCE.multiplyNTTs(KyberMath.INSTANCE.vectorToMontVector(ArraysKt.copyOfRange((int[])nArray, (int)n5, (int)n6)), KyberMath.INSTANCE.ntt(coefficients[i])));
            for (int j = 0; j < 256; ++j) {
                constantTerms[j] = KyberMath.INSTANCE.barrettReduce(constantTerms[j] - subtraction[j]);
            }
        }
        constantTerms = KyberMath.INSTANCE.montVectorToVector(constantTerms);
        return KyberMath.INSTANCE.byteEncode(KyberMath.INSTANCE.compress(constantTerms, 1), 1);
    }

    public final /* synthetic */ KyberEncapsulationResult encapsulate$KyberKotlin(KyberEncapsulationKey kyberEncapsulationKey, byte[] plainText) {
        byte[] sharedKeyAndRandomness;
        Intrinsics.checkNotNullParameter((Object)kyberEncapsulationKey, (String)"kyberEncapsulationKey");
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        byte[] sha3512Bytes = new byte[plainText.length + 32];
        ArraysKt.copyInto$default((byte[])plainText, (byte[])sha3512Bytes, (int)0, (int)0, (int)0, (int)14, null);
        ArraysKt.copyInto$default((byte[])new SHA3_256(0, 1, null).digest(kyberEncapsulationKey.getKey().getFullBytes()), (byte[])sha3512Bytes, (int)plainText.length, (int)0, (int)0, (int)12, null);
        byte[] byArray = sharedKeyAndRandomness = new SHA3_512(0, 1, null).digest(sha3512Bytes);
        int n = 32;
        int n2 = sharedKeyAndRandomness.length;
        KyberCipherText cipherText = this.toCipherText(kyberEncapsulationKey.getKey(), plainText, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        byArray = sharedKeyAndRandomness;
        n = 0;
        n2 = 32;
        return new KyberEncapsulationResult(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2), cipherText);
    }

    public final /* synthetic */ byte[] decapsulate$KyberKotlin(KyberDecapsulationKey decapsulationKey, KyberCipherText kyberCipherText) {
        Intrinsics.checkNotNullParameter((Object)decapsulationKey, (String)"decapsulationKey");
        Intrinsics.checkNotNullParameter((Object)kyberCipherText, (String)"kyberCipherText");
        byte[] recoveredPlainText = this.fromCipherText$KyberKotlin(decapsulationKey.getKey(), kyberCipherText);
        SHA3_512 sha3_512 = new SHA3_512(0, 1, null);
        sha3_512.update(recoveredPlainText);
        sha3_512.update(decapsulationKey.getHash$KyberKotlin());
        byte[] decapsHash = sha3_512.digest();
        SHAKE256 shake256 = new SHAKE256(32);
        shake256.update(decapsulationKey.getRandomSeed$KyberKotlin());
        shake256.update(kyberCipherText.getFullBytes());
        byte[] secretKeyRejection = shake256.digest();
        byte[] byArray = decapsHash;
        int n = 0;
        int n2 = 32;
        byte[] secretKeyCandidate = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        byte[] byArray2 = decapsHash;
        n2 = 32;
        int n3 = decapsHash.length;
        KyberCipherText regeneratedCipherText = this.toCipherText(decapsulationKey.getEncryptionKey(), recoveredPlainText, ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3));
        ArraysKt.fill$default((byte[])decapsHash, (byte)0, (int)0, (int)0, (int)6, null);
        if (!Arrays.equals(kyberCipherText.getFullBytes(), regeneratedCipherText.getFullBytes())) {
            secretKeyCandidate = secretKeyRejection;
        }
        return secretKeyCandidate;
    }
}

