/*
 * Decompiled with CFR 0.152.
 */
package asia.hombre.kyber.internal;

import asia.hombre.keccak.api.SHAKE128;
import asia.hombre.keccak.api.SHAKE256;
import asia.hombre.keccak.streams.HashOutputStream;
import asia.hombre.kyber.KyberConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0016\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\nJ\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005\u00a2\u0006\u0004\b!\u0010\"J\u001e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005J\u0018\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J \u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0002J\u000e\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0010J\u000e\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u0010J\u0016\u0010/\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005J\u0016\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u0010J\u001e\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206J\u001e\u00108\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u00104\u001a\u00020\n2\u0006\u00109\u001a\u000206J=\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00100;2\u0012\u0010<\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100;0;2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00100;2\b\b\u0002\u0010>\u001a\u00020\u0006\u00a2\u0006\u0002\u0010?J-\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00100;2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00100;2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00100;\u00a2\u0006\u0002\u0010CJ\u0016\u0010D\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u0010J\u000e\u0010E\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u0010J\u000e\u0010F\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u0010J\u000e\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u0005J\u000e\u0010I\u001a\u00020\u00062\u0006\u0010H\u001a\u00020\u0005J\u000e\u0010J\u001a\u00020\u00052\u0006\u0010K\u001a\u00020\u0005J\u000e\u0010L\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010M\u001a\u00020\n2\u0006\u0010N\u001a\u00020OR\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006P"}, d2={"Lasia/hombre/kyber/internal/KyberMath;", "", "<init>", "()V", "int", "", "", "getInt", "(Z)I", "bitsToBytes", "", "bits", "", "bytesToBits", "bytes", "compress", "", "shorts", "bitSize", "decompress", "singleDecompress", "byteEncode", "byteDecode", "byteArray", "singleByteDecode", "sampleNTT", "byteStream", "Lasia/hombre/keccak/streams/HashOutputStream;", "samplePolyCBD", "eta", "reverseBits", "Lkotlin/UByte;", "x", "reverseBits-Wa3L5BU", "(I)B", "powMod", "", "b", "e", "m", "pow", "a", "modMulInv", "ntt", "polynomials", "nttInv", "nttPolynomials", "productOf", "multiplyNTTs", "ntt1", "ntt2", "xof", "seed", "byte1", "", "byte2", "prf", "byte", "nttMatrixToVectorDot", "", "matrix", "vector", "isTransposed", "([[[I[[IZ)[[I", "vectorAddition", "v1", "v2", "([[I[[I)[[I", "vectorToVectorAdd", "montVectorToVector", "vectorToMontVector", "barrettReduce", "n", "isModuloOfQ", "montgomeryReduce", "t", "toMontgomeryForm", "decodeHex", "string", "", "KyberKotlin"})
@SourceDebugExtension(value={"SMAP\nKyberMath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KyberMath.kt\nasia/hombre/kyber/internal/KyberMath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,442:1\n1557#2:443\n1628#2,3:444\n*S KotlinDebug\n*F\n+ 1 KyberMath.kt\nasia/hombre/kyber/internal/KyberMath\n*L\n439#1:443\n439#1:444,3\n*E\n"})
public final class KyberMath {
    @NotNull
    public static final KyberMath INSTANCE = new KyberMath();

    private KyberMath() {
    }

    public final /* synthetic */ int getInt(boolean $this$int) {
        return Boolean.compare($this$int, false);
    }

    public final /* synthetic */ byte[] bitsToBytes(boolean[] bits) {
        Intrinsics.checkNotNullParameter((Object)bits, (String)"bits");
        byte[] byteArray = new byte[bits.length >> 3];
        int n = byteArray.length;
        for (int i = 0; i < n; ++i) {
            byteArray[i] = (byte)(this.getInt(bits[i * 8]) | this.getInt(bits[i * 8 + 1]) << 1 | this.getInt(bits[i * 8 + 2]) << 2 | this.getInt(bits[i * 8 + 3]) << 3 | this.getInt(bits[i * 8 + 4]) << 4 | this.getInt(bits[i * 8 + 5]) << 5 | this.getInt(bits[i * 8 + 6]) << 6 | this.getInt(bits[i * 8 + 7]) << 7);
        }
        return byteArray;
    }

    public final /* synthetic */ boolean[] bytesToBits(byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        boolean[] bitArray = new boolean[bytes.length * 8];
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            int n2 = UByte.constructor-impl((byte)bytes[i]) & 0xFF;
            bitArray[8 * i] = (n2 & 1) == 1;
            bitArray[8 * i + 1] = (n2 >> 1 & 1) == 1;
            bitArray[8 * i + 2] = (n2 >> 2 & 1) == 1;
            bitArray[8 * i + 3] = (n2 >> 3 & 1) == 1;
            bitArray[8 * i + 4] = (n2 >> 4 & 1) == 1;
            bitArray[8 * i + 5] = (n2 >> 5 & 1) == 1;
            bitArray[8 * i + 6] = (n2 >> 6 & 1) == 1;
            bitArray[8 * i + 7] = (n2 >> 7 & 1) == 1;
        }
        return bitArray;
    }

    public final /* synthetic */ int[] compress(int[] shorts, int bitSize) {
        Intrinsics.checkNotNullParameter((Object)shorts, (String)"shorts");
        int[] compressed = new int[shorts.length];
        int n = shorts.length;
        for (int i = 0; i < n; ++i) {
            compressed[i] = ((1 << bitSize) * shorts[i] + 1665) / 3329;
        }
        return compressed;
    }

    public final /* synthetic */ int[] decompress(int[] shorts, int bitSize) {
        Intrinsics.checkNotNullParameter((Object)shorts, (String)"shorts");
        int[] decompressed = new int[shorts.length];
        int n = shorts.length;
        for (int i = 0; i < n; ++i) {
            decompressed[i] = (3329 * shorts[i] + (1 << bitSize - 1)) / (1 << bitSize);
        }
        return decompressed;
    }

    public final /* synthetic */ int[] singleDecompress(int[] shorts) {
        Intrinsics.checkNotNullParameter((Object)shorts, (String)"shorts");
        int[] decompressed = new int[shorts.length];
        int decompressConstant = 1665;
        int n = shorts.length;
        for (int i = 0; i < n; ++i) {
            decompressed[i] = this.toMontgomeryForm(shorts[i] * decompressConstant);
        }
        return decompressed;
    }

    public final /* synthetic */ byte[] byteEncode(int[] shorts, int bitSize) {
        Intrinsics.checkNotNullParameter((Object)shorts, (String)"shorts");
        if (bitSize > 16) {
            throw new ArithmeticException("There are not enough bits to encode! Bit Size: " + bitSize + " is too big!");
        }
        boolean[] bits = new boolean[shorts.length * bitSize];
        int n = shorts.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < bitSize; ++j) {
                bits[i * bitSize + j] = (this.barrettReduce(shorts[i]) >> j & 1) == 1;
            }
        }
        return this.bitsToBytes(bits);
    }

    public final /* synthetic */ int[] byteDecode(byte[] byteArray, int bitSize) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        boolean[] bits = this.bytesToBits(byteArray);
        int[] shorts = new int[bits.length / bitSize];
        int n = shorts.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < bitSize; ++j) {
                shorts[i] = shorts[i] + (this.getInt(bits[i * bitSize + j]) << j);
            }
        }
        return shorts;
    }

    public final /* synthetic */ int[] singleByteDecode(byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        boolean[] bits = this.bytesToBits(byteArray);
        int[] shorts = new int[bits.length];
        int n = shorts.length;
        for (int i = 0; i < n; ++i) {
            shorts[i] = this.getInt(bits[i]);
        }
        return shorts;
    }

    public final /* synthetic */ int[] sampleNTT(HashOutputStream byteStream) {
        Intrinsics.checkNotNullParameter((Object)byteStream, (String)"byteStream");
        int[] nttCoefficients = new int[256];
        byte[] buffer = new byte[3];
        int j = 0;
        while (j < 256) {
            byteStream.nextBytes(buffer);
            int d1 = (buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8) & 0xFFF;
            int d2 = ((buffer[1] & 0xFF) >> 4 | (buffer[2] & 0xFF) << 4) & 0xFFF;
            if (d1 < 3329) {
                nttCoefficients[j] = this.toMontgomeryForm(d1);
                ++j;
            }
            if (d2 >= 3329 || j >= 256) continue;
            nttCoefficients[j] = this.toMontgomeryForm(d2);
            ++j;
        }
        return nttCoefficients;
    }

    public final /* synthetic */ int[] samplePolyCBD(int eta, byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int[] f = new int[256];
        boolean[] bits = this.bytesToBits(bytes);
        ArraysKt.fill((byte[])bytes, (byte)0, (int)0, (int)bytes.length);
        for (int i = 0; i < 256; ++i) {
            int x = 0;
            int y = 0;
            for (int j = 0; j < eta; ++j) {
                x += this.getInt(bits[2 * i * eta + j]);
                y += this.getInt(bits[2 * i * eta + eta + j]);
            }
            f[i] = this.toMontgomeryForm(x - y);
        }
        return f;
    }

    public final /* synthetic */ byte reverseBits-Wa3L5BU(int x) {
        return UByte.constructor-impl((byte)((byte)((1 & x) << 6 | (2 & x) << 4 | (4 & x) << 2 | 8 & x | (0x10 & x) >>> 2 | (0x20 & x) >>> 4 | (0x40 & x) >>> 6)));
    }

    public final /* synthetic */ long powMod(int b, int e, int m) {
        if (e == 0) {
            return 1L;
        }
        if (e < 0) {
            return this.modMulInv(b, Math.abs(e), m);
        }
        long c = 1L;
        for (int i = 0; i < e; ++i) {
            c = (long)b * c % (long)m;
        }
        return c;
    }

    private final /* synthetic */ long pow(int a, int b) {
        long out = 1L;
        for (int i = 0; i < b; ++i) {
            out *= (long)a;
        }
        return out;
    }

    private final /* synthetic */ long modMulInv(int b, int e, int m) {
        long s = 0L;
        long r = m;
        long oldS = 1L;
        long oldR = this.pow(b, e);
        while (r != 0L) {
            long quotient = oldR / r;
            long tempR = r;
            r = oldR - quotient * r;
            oldR = tempR;
            long tempS = s;
            s = oldS - quotient * s;
            oldS = tempS;
        }
        if (oldS < 0L) {
            oldS += (long)m;
        }
        return oldS;
    }

    public final /* synthetic */ int[] ntt(int[] polynomials) {
        Intrinsics.checkNotNullParameter((Object)polynomials, (String)"polynomials");
        int[] nArray = Arrays.copyOf(polynomials, polynomials.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        int[] output = nArray;
        int k = 1;
        block0: for (int len = 128; len >= 2; len >>= 1) {
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)256)), (int)(2 * len));
            int start = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if ((n2 <= 0 || start > n) && (n2 >= 0 || n > start)) continue;
            while (true) {
                int n3 = start + len;
                for (int j = start; j < n3; ++j) {
                    int temp = this.productOf(KyberConstants.PRECOMPUTED_ZETAS_TABLE[k], output[j + len]);
                    output[j + len] = this.barrettReduce(output[j] - temp);
                    output[j] = output[j] + temp;
                }
                ++k;
                if (start == n) continue block0;
                start += n2;
            }
        }
        int n = output.length;
        for (int i = 0; i < n; ++i) {
            output[i] = this.barrettReduce(output[i]);
        }
        return output;
    }

    public final /* synthetic */ int[] nttInv(int[] nttPolynomials) {
        Intrinsics.checkNotNullParameter((Object)nttPolynomials, (String)"nttPolynomials");
        int[] nArray = Arrays.copyOf(nttPolynomials, nttPolynomials.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        int[] output = nArray;
        int k = 127;
        block0: for (int len = 2; len <= 128; len <<= 1) {
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)256)), (int)(2 * len));
            int start = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if ((n2 <= 0 || start > n) && (n2 >= 0 || n > start)) continue;
            while (true) {
                int n3 = start + len;
                for (int j = start; j < n3; ++j) {
                    int temp = output[j];
                    output[j] = temp + output[j + len];
                    output[j + len] = this.productOf(KyberConstants.PRECOMPUTED_ZETAS_TABLE[k], this.barrettReduce(output[j + len] - temp));
                }
                --k;
                if (start == n) continue block0;
                start += n2;
            }
        }
        int n = output.length;
        for (int i = 0; i < n; ++i) {
            output[i] = this.barrettReduce(this.productOf(output[i], 512));
        }
        return output;
    }

    public final /* synthetic */ int productOf(int a, int b) {
        return this.montgomeryReduce(a * b);
    }

    public final /* synthetic */ int[] multiplyNTTs(int[] ntt1, int[] ntt2) {
        Intrinsics.checkNotNullParameter((Object)ntt1, (String)"ntt1");
        Intrinsics.checkNotNullParameter((Object)ntt2, (String)"ntt2");
        int[] multipliedNtt = new int[256];
        for (int i = 0; i < 128; ++i) {
            int x = this.productOf(ntt1[2 * i], ntt2[2 * i]);
            int y = this.productOf(ntt1[2 * i + 1], ntt2[2 * i + 1]);
            multipliedNtt[2 * i] = this.barrettReduce(x + this.productOf(y, KyberConstants.PRECOMPUTED_GAMMAS_TABLE[i]));
            multipliedNtt[2 * i + 1] = this.barrettReduce(this.productOf(ntt1[2 * i] + ntt1[2 * i + 1], ntt2[2 * i] + ntt2[2 * i + 1]) - x - y);
        }
        return multipliedNtt;
    }

    public final /* synthetic */ HashOutputStream xof(byte[] seed, byte byte1, byte byte2) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        SHAKE128 shake128 = new SHAKE128(0, 1, null);
        shake128.update(seed);
        shake128.update(byte1);
        shake128.update(byte2);
        return shake128.stream();
    }

    public final /* synthetic */ byte[] prf(int eta, byte[] seed, byte by) {
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        byte[] shakeBytes = new byte[seed.length + 1];
        ArraysKt.copyInto$default((byte[])seed, (byte[])shakeBytes, (int)0, (int)0, (int)0, (int)14, null);
        shakeBytes[ArraysKt.getLastIndex((byte[])shakeBytes)] = by;
        return new SHAKE256(64 * eta).digest(shakeBytes);
    }

    public final /* synthetic */ int[][] nttMatrixToVectorDot(int[][][] matrix, int[][] vector, boolean isTransposed) {
        int n;
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        int n2 = 0;
        int n3 = ((Object[])vector).length;
        int[][] nArrayArray = new int[n3][];
        while (n2 < n3) {
            n = n2++;
            nArrayArray[n] = new int[256];
        }
        int[][] result = nArrayArray;
        n3 = ((Object[])matrix).length;
        for (int i = 0; i < n3; ++i) {
            n = ((Object[])vector).length;
            for (int j = 0; j < n; ++j) {
                int a = isTransposed ? j : i;
                int b = isTransposed ? i : j;
                result[i] = this.vectorToVectorAdd(result[i], this.multiplyNTTs(matrix[a][b], vector[j]));
            }
        }
        return result;
    }

    public static /* synthetic */ int[][] nttMatrixToVectorDot$default(KyberMath kyberMath, int[][][] nArray, int[][] nArray2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return kyberMath.nttMatrixToVectorDot(nArray, nArray2, bl);
    }

    public final /* synthetic */ int[][] vectorAddition(int[][] v1, int[][] v2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        int n = 0;
        int n2 = ((Object[])v1).length;
        int[][] nArrayArray = new int[n2][];
        while (n < n2) {
            int n3 = n++;
            nArrayArray[n3] = new int[v2[0].length];
        }
        int[][] result = nArrayArray;
        n2 = ((Object[])v1).length;
        for (int i = 0; i < n2; ++i) {
            result[i] = this.vectorToVectorAdd(v1[i], v2[i]);
        }
        return result;
    }

    public final /* synthetic */ int[] vectorToVectorAdd(int[] v1, int[] v2) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        int[] result = new int[v1.length];
        int n = v1.length;
        for (int i = 0; i < n; ++i) {
            result[i] = v1[i] + v2[i];
        }
        return result;
    }

    public final /* synthetic */ int[] montVectorToVector(int[] v1) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        int[] result = new int[v1.length];
        int n = v1.length;
        for (int i = 0; i < n; ++i) {
            result[i] = this.montgomeryReduce(v1[i]);
        }
        return result;
    }

    public final /* synthetic */ int[] vectorToMontVector(int[] v1) {
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        int[] result = new int[v1.length];
        int n = v1.length;
        for (int i = 0; i < n; ++i) {
            result[i] = this.toMontgomeryForm(v1[i]);
        }
        return result;
    }

    public final /* synthetic */ int barrettReduce(int n) {
        int q = n * 20159 >> 26;
        return n - q * 3329;
    }

    public final /* synthetic */ boolean isModuloOfQ(int n) {
        return n * 20159 >> 26 == 0;
    }

    public final /* synthetic */ int montgomeryReduce(int t) {
        int m = t * -62209 & 0xFFFF;
        int u = t + m * 3329 >> 16;
        return u;
    }

    public final /* synthetic */ int toMontgomeryForm(int a) {
        return this.montgomeryReduce(a * 1353);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ byte[] decodeHex(String string) throws IllegalArgumentException {
        void $this$mapTo$iv$iv;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String hexString = string;
        if (string.length() % 2 == 1) {
            hexString = hexString + '0';
        }
        if (new Regex("[^A-Fa-f0-9]").containsMatchIn(charSequence = (CharSequence)string)) {
            throw new IllegalArgumentException("String cannot contain characters that is not hex characters.");
        }
        Iterable $this$map$iv = StringsKt.chunked((CharSequence)hexString, (int)2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)Integer.parseInt((String)it, CharsKt.checkRadix((int)16)));
        }
        return CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
    }
}

