/*
 * Copyright 2024 Ron Lauren Hombre
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *        and included as LICENSE.txt in this Project.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package asia.hombre.kyber

import kotlin.js.ExperimentalJsExport
import kotlin.js.JsExport
import kotlin.jvm.JvmName

/**
 * A class for ML-KEM Encapsulation Results.
 *
 * This class contains the Secret Key and the Cipher Text.
 *
 * @constructor Stores the Secret Key and the Cipher Text.
 * @author Ron Lauren Hombre
 */
@OptIn(ExperimentalJsExport::class)
@JsExport
class KyberEncapsulationResult internal constructor(
    private val secretKey_: ByteArray,
    private val cipherText_: KyberCipherText
) {
    /**
     * The Secret Key generated by the Encapsulation.
     *
     * @return [ByteArray] - 32 Bytes.
     */
    @get:JvmName("getSecretKey")
    val secretKey: ByteArray
        get() = secretKey_.copyOf()

    /**
     * The [KyberCipherText] generated by the Encapsulation.
     *
     * @return [KyberCipherText]
     */
    @get:JvmName("getCipherText")
    val cipherText: KyberCipherText
        get() = cipherText_.copy()
}