/*
 * Decompiled with CFR 0.152.
 */
package asia.hombre.kyber;

import asia.hombre.keccak.KeccakHash;
import asia.hombre.keccak.KeccakParameter;
import asia.hombre.kyber.KyberCipherText;
import asia.hombre.kyber.KyberDecapsulationKey;
import asia.hombre.kyber.KyberDecryptionKey;
import asia.hombre.kyber.KyberEncapsulationKey;
import asia.hombre.kyber.KyberEncapsulationResult;
import asia.hombre.kyber.KyberEncryptionKey;
import asia.hombre.kyber.KyberKEMKeyPair;
import asia.hombre.kyber.KyberParameter;
import asia.hombre.kyber.internal.KyberMath;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.SecureRandom;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lasia/hombre/kyber/KyberAgreement;", "", "kemKeyPair", "Lasia/hombre/kyber/KyberKEMKeyPair;", "(Lasia/hombre/kyber/KyberKEMKeyPair;)V", "keypair", "parameter", "Lasia/hombre/kyber/KyberParameter;", "getParameter", "()Lasia/hombre/kyber/KyberParameter;", "decapsulate", "", "kyberCipherText", "Lasia/hombre/kyber/KyberCipherText;", "encapsulate", "Lasia/hombre/kyber/KyberEncapsulationResult;", "kyberEncapsulationKey", "Lasia/hombre/kyber/KyberEncapsulationKey;", "Companion", "KyberKotlin"})
public final class KyberAgreement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KyberParameter parameter;
    @NotNull
    private final KyberKEMKeyPair keypair;

    public KyberAgreement(@NotNull KyberKEMKeyPair kemKeyPair) {
        Intrinsics.checkNotNullParameter((Object)kemKeyPair, (String)"kemKeyPair");
        this.parameter = kemKeyPair.getEncapsulationKey().getKey().getParameter();
        this.keypair = kemKeyPair;
    }

    @NotNull
    public final KyberParameter getParameter() {
        return this.parameter;
    }

    @NotNull
    public final KyberEncapsulationResult encapsulate(@NotNull KyberEncapsulationKey kyberEncapsulationKey) {
        Intrinsics.checkNotNullParameter((Object)kyberEncapsulationKey, (String)"kyberEncapsulationKey");
        return Companion.encapsulate$KyberKotlin(kyberEncapsulationKey, new SecureRandom().nextBytesOf(32));
    }

    @NotNull
    public final byte[] decapsulate(@NotNull KyberCipherText kyberCipherText) {
        Intrinsics.checkNotNullParameter((Object)kyberCipherText, (String)"kyberCipherText");
        return Companion.decapsulate(this.keypair.getDecapsulationKey(), kyberCipherText);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000eJ\u001d\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0012J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u00a8\u0006\u0017"}, d2={"Lasia/hombre/kyber/KyberAgreement$Companion;", "", "()V", "decapsulate", "", "decapsulationKey", "Lasia/hombre/kyber/KyberDecapsulationKey;", "kyberCipherText", "Lasia/hombre/kyber/KyberCipherText;", "encapsulate", "Lasia/hombre/kyber/KyberEncapsulationResult;", "kyberEncapsulationKey", "Lasia/hombre/kyber/KyberEncapsulationKey;", "plainText", "encapsulate$KyberKotlin", "fromCipherText", "decryptionKey", "Lasia/hombre/kyber/KyberDecryptionKey;", "fromCipherText$KyberKotlin", "toCipherText", "encryptionKey", "Lasia/hombre/kyber/KyberEncryptionKey;", "randomness", "KyberKotlin"})
    public static final class Companion {
        private Companion() {
        }

        private final KyberCipherText toCipherText(KyberEncryptionKey encryptionKey, byte[] plainText, byte[] randomness) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            KyberParameter parameter = encryptionKey.getParameter();
            int[] decodedKey = KyberMath.Companion.byteDecode(encryptionKey.getKeyBytes$KyberKotlin(), 12);
            int n6 = 0;
            int n7 = parameter.getK();
            int[][] nArrayArray = new int[n7][];
            while (n6 < n7) {
                n5 = n6++;
                nArrayArray[n5] = new int[256];
            }
            int[][] nttKeyVector = nArrayArray;
            byte[] nttSeed = encryptionKey.getNttSeed$KyberKotlin();
            n5 = parameter.getK();
            int[][][] nArrayArray2 = new int[n5][][];
            for (int i = 0; i < n5; ++i) {
                int n8 = i;
                n4 = 0;
                n3 = parameter.getK();
                int[][] nArrayArray3 = new int[n3][];
                int n9 = n8;
                int[][][] nArrayArray4 = nArrayArray2;
                while (n4 < n3) {
                    n2 = n4++;
                    nArrayArray3[n2] = new int[256];
                }
                nArrayArray4[n9] = nArrayArray3;
            }
            int[][][] matrix = nArrayArray2;
            n5 = 0;
            int n10 = parameter.getK();
            int[][] nArrayArray5 = new int[n10][];
            while (n5 < n10) {
                n4 = n5++;
                nArrayArray5[n4] = new int[256];
            }
            int[][] randomnessVector = nArrayArray5;
            n10 = 0;
            int n11 = parameter.getK();
            int[][] nArrayArray6 = new int[n11][];
            while (n10 < n11) {
                n3 = n10++;
                nArrayArray6[n3] = new int[256];
            }
            int[][] noiseVector = nArrayArray6;
            n11 = parameter.getK();
            for (n10 = 0; n10 < n11; ++n10) {
                int n12 = n10;
                int i = n10;
                ArraysKt.copyInto((int[])decodedKey, (int[])nttKeyVector[i], (int)0, (int)(256 * i), (int)(256 * (i + 1)));
                nttKeyVector[i] = KyberMath.Companion.vectorToMontVector(nttKeyVector[i]);
                randomnessVector[i] = KyberMath.Companion.samplePolyCBD(parameter.getETA1(), KyberMath.Companion.prf(parameter.getETA1(), randomness, (byte)n12));
                randomnessVector[i] = KyberMath.Companion.NTT(randomnessVector[i]);
                noiseVector[i] = KyberMath.Companion.samplePolyCBD(parameter.getETA2(), KyberMath.Companion.prf(parameter.getETA2(), randomness, (byte)(n12 + parameter.getK())));
                n2 = parameter.getK();
                for (int j = 0; j < n2; ++j) {
                    matrix[i][j] = KyberMath.Companion.sampleNTT(KyberMath.Companion.xof(nttSeed, (byte)i, (byte)j));
                }
            }
            int[] noiseTerm = KyberMath.Companion.samplePolyCBD(parameter.getETA2(), KyberMath.Companion.prf(parameter.getETA2(), randomness, (byte)(parameter.getK() * 2 + 1)));
            int[] muse = KyberMath.Companion.singleDecompress(KyberMath.Companion.singleByteDecode(plainText));
            int[][] coefficients = KyberMath.Companion.nttMatrixToVectorDot$default(KyberMath.Companion, matrix, randomnessVector, false, 4, null);
            int[] constantTerm = new int[256];
            n2 = parameter.getK();
            for (int i = 0; i < n2; ++i) {
                coefficients[i] = KyberMath.Companion.invNTT(coefficients[i]);
                coefficients[i] = KyberMath.Companion.vectorToVectorAdd(coefficients[i], noiseVector[i]);
                constantTerm = KyberMath.Companion.vectorToVectorAdd(constantTerm, KyberMath.Companion.multiplyNTTs(nttKeyVector[i], randomnessVector[i]));
                n = parameter.getK();
                for (int j = 0; j < n; ++j) {
                    ArraysKt.fill((int[])matrix[i][j], (int)0, (int)0, (int)matrix[i][j].length);
                }
                ArraysKt.fill((int[])noiseVector[i], (int)0, (int)0, (int)noiseVector[i].length);
                ArraysKt.fill((int[])nttKeyVector[i], (int)0, (int)0, (int)nttKeyVector[i].length);
                ArraysKt.fill((int[])randomnessVector[i], (int)0, (int)0, (int)randomnessVector[i].length);
            }
            constantTerm = KyberMath.Companion.invNTT(constantTerm);
            constantTerm = KyberMath.Companion.vectorToVectorAdd(constantTerm, noiseTerm);
            constantTerm = KyberMath.Companion.vectorToVectorAdd(constantTerm, muse);
            ArraysKt.fill((int[])muse, (int)0, (int)0, (int)muse.length);
            byte[] encodedCoefficients = new byte[32 * (parameter.getDU() * parameter.getK())];
            byte[] encodedTerms = new byte[32 * parameter.getDV()];
            n = parameter.getK();
            for (int i = 0; i < n; ++i) {
                ArraysKt.copyInto$default((byte[])KyberMath.Companion.byteEncode(KyberMath.Companion.compress(KyberMath.Companion.montVectorToVector(coefficients[i]), parameter.getDU()), parameter.getDU()), (byte[])encodedCoefficients, (int)(i * 32 * parameter.getDU()), (int)0, (int)0, (int)12, null);
            }
            ArraysKt.copyInto$default((byte[])KyberMath.Companion.byteEncode(KyberMath.Companion.compress(KyberMath.Companion.montVectorToVector(constantTerm), parameter.getDV()), parameter.getDV()), (byte[])encodedTerms, (int)0, (int)0, (int)0, (int)14, null);
            return new KyberCipherText(parameter, encodedCoefficients, encodedTerms);
        }

        public final /* synthetic */ byte[] fromCipherText$KyberKotlin(KyberDecryptionKey decryptionKey, KyberCipherText kyberCipherText) {
            int n;
            Intrinsics.checkNotNullParameter((Object)decryptionKey, (String)"decryptionKey");
            Intrinsics.checkNotNullParameter((Object)kyberCipherText, (String)"kyberCipherText");
            KyberParameter parameter = kyberCipherText.getParameter();
            int n2 = 0;
            int n3 = kyberCipherText.getParameter().getK();
            Object object = new int[n3][];
            while (n2 < n3) {
                n = n2++;
                object[n] = new int[256];
            }
            int[][] coefficients = object;
            n3 = parameter.getK();
            for (int i = 0; i < n3; ++i) {
                object = kyberCipherText.getEncodedCoefficients$KyberKotlin();
                n = i * 32 * parameter.getDU();
                int n4 = (i + 1) * 32 * parameter.getDU();
                coefficients[i] = KyberMath.Companion.decompress(KyberMath.Companion.byteDecode(ArraysKt.copyOfRange((byte[])object, (int)n, (int)n4), parameter.getDU()), parameter.getDU());
                coefficients[i] = KyberMath.Companion.vectorToMontVector(coefficients[i]);
            }
            int[] constantTerms = KyberMath.Companion.decompress(KyberMath.Companion.byteDecode(kyberCipherText.getEncodedTerms$KyberKotlin(), parameter.getDV()), parameter.getDV());
            constantTerms = KyberMath.Companion.vectorToMontVector(constantTerms);
            int[] secretVector = KyberMath.Companion.byteDecode(decryptionKey.getKeyBytes$KyberKotlin(), 12);
            n = parameter.getK();
            for (int i = 0; i < n; ++i) {
                int[] nArray = secretVector;
                int n5 = i * 256;
                int n6 = (i + 1) * 256;
                int[] subtraction = KyberMath.Companion.invNTT(KyberMath.Companion.multiplyNTTs(KyberMath.Companion.vectorToMontVector(ArraysKt.copyOfRange((int[])nArray, (int)n5, (int)n6)), KyberMath.Companion.NTT(coefficients[i])));
                for (int j = 0; j < 256; ++j) {
                    constantTerms[j] = KyberMath.Companion.barrettReduce(constantTerms[j] - subtraction[j]);
                }
            }
            constantTerms = KyberMath.Companion.montVectorToVector(constantTerms);
            return KyberMath.Companion.byteEncode(KyberMath.Companion.compress(constantTerms, 1), 1);
        }

        public final /* synthetic */ KyberEncapsulationResult encapsulate$KyberKotlin(KyberEncapsulationKey kyberEncapsulationKey, byte[] plainText) {
            byte[] sharedKeyAndRandomness;
            Intrinsics.checkNotNullParameter((Object)kyberEncapsulationKey, (String)"kyberEncapsulationKey");
            Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
            byte[] sha3512Bytes = new byte[plainText.length + KeccakParameter.SHA3_256.getMaxLength() / 8];
            ArraysKt.copyInto$default((byte[])plainText, (byte[])sha3512Bytes, (int)0, (int)0, (int)0, (int)14, null);
            ArraysKt.copyInto$default((byte[])KeccakHash.Companion.generate$default((KeccakHash.Companion)KeccakHash.Companion, (KeccakParameter)KeccakParameter.SHA3_256, (byte[])kyberEncapsulationKey.getKey().getFullBytes(), (int)0, (int)4, null), (byte[])sha3512Bytes, (int)plainText.length, (int)0, (int)0, (int)12, null);
            byte[] byArray = sharedKeyAndRandomness = KeccakHash.Companion.generate$default((KeccakHash.Companion)KeccakHash.Companion, (KeccakParameter)KeccakParameter.SHA3_512, (byte[])sha3512Bytes, (int)0, (int)4, null);
            int n = 32;
            int n2 = 64;
            KyberCipherText cipherText = this.toCipherText(kyberEncapsulationKey.getKey(), plainText, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
            byArray = sharedKeyAndRandomness;
            n = 0;
            n2 = 32;
            return new KyberEncapsulationResult(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2), cipherText);
        }

        @NotNull
        public final byte[] decapsulate(@NotNull KyberDecapsulationKey decapsulationKey, @NotNull KyberCipherText kyberCipherText) {
            Intrinsics.checkNotNullParameter((Object)decapsulationKey, (String)"decapsulationKey");
            Intrinsics.checkNotNullParameter((Object)kyberCipherText, (String)"kyberCipherText");
            byte[] recoveredPlainText = this.fromCipherText$KyberKotlin(decapsulationKey.getKey(), kyberCipherText);
            byte[] sha3512Bytes = new byte[recoveredPlainText.length + decapsulationKey.getHash$KyberKotlin().length];
            ArraysKt.copyInto$default((byte[])recoveredPlainText, (byte[])sha3512Bytes, (int)0, (int)0, (int)0, (int)14, null);
            ArraysKt.copyInto$default((byte[])decapsulationKey.getHash$KyberKotlin(), (byte[])sha3512Bytes, (int)recoveredPlainText.length, (int)0, (int)0, (int)12, null);
            byte[] decapsHash = KeccakHash.Companion.generate$default((KeccakHash.Companion)KeccakHash.Companion, (KeccakParameter)KeccakParameter.SHA3_512, (byte[])sha3512Bytes, (int)0, (int)4, null);
            byte[] shake256Bytes = new byte[decapsulationKey.getRandomSeed$KyberKotlin().length + kyberCipherText.getFullBytes().length];
            ArraysKt.copyInto$default((byte[])decapsulationKey.getRandomSeed$KyberKotlin(), (byte[])shake256Bytes, (int)0, (int)0, (int)0, (int)14, null);
            ArraysKt.copyInto$default((byte[])kyberCipherText.getFullBytes(), (byte[])shake256Bytes, (int)decapsulationKey.getRandomSeed$KyberKotlin().length, (int)0, (int)0, (int)12, null);
            byte[] secretKeyRejection = KeccakHash.Companion.generate(KeccakParameter.SHAKE_256, shake256Bytes, 32);
            byte[] byArray = decapsHash;
            int n = 0;
            int n2 = 32;
            byte[] secretKeyCandidate = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            byte[] byArray2 = decapsHash;
            n2 = 32;
            int n3 = 64;
            KyberCipherText regeneratedCipherText = this.toCipherText(decapsulationKey.getEncryptionKey(), recoveredPlainText, ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3));
            ArraysKt.fill((byte[])decapsHash, (byte)0, (int)0, (int)decapsHash.length);
            if (!Arrays.equals(kyberCipherText.getFullBytes(), regeneratedCipherText.getFullBytes())) {
                secretKeyCandidate = secretKeyRejection;
            }
            return secretKeyCandidate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

