/*
 * Decompiled with CFR 0.152.
 */
package asia.hombre.kyber;

import asia.hombre.keccak.KeccakHash;
import asia.hombre.keccak.KeccakParameter;
import asia.hombre.kyber.KyberDecapsulationKey;
import asia.hombre.kyber.KyberDecryptionKey;
import asia.hombre.kyber.KyberEncapsulationKey;
import asia.hombre.kyber.KyberEncryptionKey;
import asia.hombre.kyber.KyberKEMKeyPair;
import asia.hombre.kyber.KyberPKEKeyPair;
import asia.hombre.kyber.KyberParameter;
import asia.hombre.kyber.internal.KyberMath;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.SecureRandom;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b7\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lasia/hombre/kyber/KyberKeyGenerator;", "", "()V", "Companion", "KyberKotlin"})
public abstract class KyberKeyGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private KyberKeyGenerator() {
    }

    @JvmStatic
    @NotNull
    public static final KyberKEMKeyPair generate(@NotNull KyberParameter parameter) {
        return Companion.generate(parameter);
    }

    public /* synthetic */ KyberKeyGenerator(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\f"}, d2={"Lasia/hombre/kyber/KyberKeyGenerator$Companion;", "", "()V", "generate", "Lasia/hombre/kyber/KyberKEMKeyPair;", "parameter", "Lasia/hombre/kyber/KyberParameter;", "randomSeed", "", "pkeSeed", "generate$KyberKotlin", "PKEGenerator", "KyberKotlin"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KyberKEMKeyPair generate(@NotNull KyberParameter parameter) {
            Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
            SecureRandom secureRandom = new SecureRandom();
            return this.generate$KyberKotlin(parameter, secureRandom.nextBytesOf(32), secureRandom.nextBytesOf(32));
        }

        public final /* synthetic */ KyberKEMKeyPair generate$KyberKotlin(KyberParameter parameter, byte[] randomSeed, byte[] pkeSeed) {
            Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
            Intrinsics.checkNotNullParameter((Object)randomSeed, (String)"randomSeed");
            Intrinsics.checkNotNullParameter((Object)pkeSeed, (String)"pkeSeed");
            KyberPKEKeyPair pkeKeyPair = PKEGenerator.Companion.generate(parameter, pkeSeed);
            byte[] hash = KeccakHash.Companion.generate(KeccakParameter.SHA3_256, pkeKeyPair.getEncryptionKey().getFullBytes(), 32);
            return new KyberKEMKeyPair(new KyberEncapsulationKey(pkeKeyPair.getEncryptionKey()), new KyberDecapsulationKey(pkeKeyPair.getDecryptionKey(), pkeKeyPair.getEncryptionKey(), hash, randomSeed));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lasia/hombre/kyber/KyberKeyGenerator$Companion$PKEGenerator;", "", "()V", "Companion", "KyberKotlin"})
        public static final class PKEGenerator {
            @NotNull
            public static final Companion Companion = new Companion(null);

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lasia/hombre/kyber/KyberKeyGenerator$Companion$PKEGenerator$Companion;", "", "()V", "generate", "Lasia/hombre/kyber/KyberPKEKeyPair;", "parameter", "Lasia/hombre/kyber/KyberParameter;", "byteArray", "", "KyberKotlin"})
            public static final class Companion {
                private Companion() {
                }

                public final /* synthetic */ KyberPKEKeyPair generate(KyberParameter parameter, byte[] byteArray) {
                    int i;
                    int n;
                    int n2;
                    int n3;
                    Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
                    Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
                    byte[] seeds = KeccakHash.Companion.generate$default((KeccakHash.Companion)KeccakHash.Companion, (KeccakParameter)KeccakParameter.SHA3_512, (byte[])byteArray, (int)0, (int)4, null);
                    ArraysKt.fill((byte[])byteArray, (byte)0, (int)0, (int)byteArray.length);
                    byte[] byArray = seeds;
                    int n4 = 0;
                    int n5 = 32;
                    byte[] nttSeed = ArraysKt.copyOfRange((byte[])byArray, (int)n4, (int)n5);
                    byte[] byArray2 = seeds;
                    n5 = 32;
                    int n6 = 64;
                    byte[] cbdSeed = ArraysKt.copyOfRange((byte[])byArray2, (int)n5, (int)n6);
                    ArraysKt.fill((byte[])seeds, (byte)0, (int)0, (int)seeds.length);
                    n6 = parameter.getK();
                    int[][][] nArrayArray = new int[n6][][];
                    for (n5 = 0; n5 < n6; ++n5) {
                        int n7 = n5;
                        n3 = 0;
                        n2 = parameter.getK();
                        int[][] nArrayArray2 = new int[n2][];
                        int n8 = n7;
                        int[][][] nArrayArray3 = nArrayArray;
                        while (n3 < n2) {
                            n = n3++;
                            nArrayArray2[n] = new int[256];
                        }
                        nArrayArray3[n8] = nArrayArray2;
                    }
                    int[][][] matrix = nArrayArray;
                    n6 = 0;
                    int n9 = parameter.getK();
                    int[][] nArrayArray4 = new int[n9][];
                    while (n6 < n9) {
                        n3 = n6++;
                        nArrayArray4[n3] = new int[256];
                    }
                    int[][] secretVector = nArrayArray4;
                    n9 = 0;
                    int n10 = parameter.getK();
                    int[][] nArrayArray5 = new int[n10][];
                    while (n9 < n10) {
                        n2 = n9++;
                        nArrayArray5[n2] = new int[256];
                    }
                    int[][] noiseVector = nArrayArray5;
                    n10 = parameter.getK();
                    for (n9 = 0; n9 < n10; ++n9) {
                        int nonce = n9;
                        i = n9;
                        n = parameter.getK();
                        for (int j = 0; j < n; ++j) {
                            matrix[i][j] = KyberMath.Companion.sampleNTT(KyberMath.Companion.xof(nttSeed, (byte)i, (byte)j));
                        }
                        secretVector[i] = KyberMath.Companion.samplePolyCBD(parameter.getETA1(), KyberMath.Companion.prf(parameter.getETA1(), cbdSeed, (byte)nonce));
                        secretVector[i] = KyberMath.Companion.NTT(secretVector[i]);
                        noiseVector[i] = KyberMath.Companion.samplePolyCBD(parameter.getETA1(), KyberMath.Companion.prf(parameter.getETA1(), cbdSeed, (byte)(nonce + parameter.getK())));
                        noiseVector[i] = KyberMath.Companion.NTT(noiseVector[i]);
                    }
                    ArraysKt.fill((byte[])cbdSeed, (byte)0, (int)0, (int)cbdSeed.length);
                    int[][] systemVector = KyberMath.Companion.vectorAddition(KyberMath.Companion.nttMatrixToVectorDot(matrix, secretVector, true), noiseVector);
                    byte[] encryptionKeyBytes = new byte[parameter.ENCRYPTION_KEY_LENGTH - 32];
                    byte[] decryptionKeyBytes = new byte[parameter.DECRYPTION_KEY_LENGTH];
                    int n11 = parameter.getK();
                    for (i = 0; i < n11; ++i) {
                        int n12 = parameter.getK();
                        for (int j = 0; j < n12; ++j) {
                            ArraysKt.fill((int[])matrix[i][j], (int)0, (int)0, (int)matrix[i][j].length);
                        }
                        ArraysKt.fill((int[])noiseVector[i], (int)0, (int)0, (int)noiseVector[i].length);
                        ArraysKt.copyInto$default((byte[])KyberMath.Companion.byteEncode(KyberMath.Companion.montVectorToVector(systemVector[i]), 12), (byte[])encryptionKeyBytes, (int)(i * 384), (int)0, (int)0, (int)12, null);
                        ArraysKt.copyInto$default((byte[])KyberMath.Companion.byteEncode(KyberMath.Companion.montVectorToVector(secretVector[i]), 12), (byte[])decryptionKeyBytes, (int)(i * 384), (int)0, (int)0, (int)12, null);
                    }
                    return new KyberPKEKeyPair(new KyberEncryptionKey(parameter, encryptionKeyBytes, nttSeed), new KyberDecryptionKey(parameter, decryptionKeyBytes));
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

