/*
 * Decompiled with CFR 0.152.
 */
package asia.ivity.android.tiledscrollview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.Scroller;

public class TwoDScrollView
extends FrameLayout {
    static final int ANIMATED_SCROLL_GAP = 250;
    static final float MAX_SCROLL_FACTOR = 0.5f;
    private long mLastScroll;
    private Scroller mScroller;
    private float mLastMotionY;
    private float mLastMotionX;
    private boolean mIsBeingDragged = false;
    private VelocityTracker mVelocityTracker;
    private int mTouchSlop;
    private int mMinimumVelocity;

    public TwoDScrollView(Context context) {
        super(context);
        this.initTwoDScrollView();
    }

    public TwoDScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initTwoDScrollView();
    }

    public TwoDScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initTwoDScrollView();
    }

    protected float getTopFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getVerticalFadingEdgeLength();
        if (this.getScrollY() < length) {
            return (float)this.getScrollY() / (float)length;
        }
        return 1.0f;
    }

    protected float getBottomFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getVerticalFadingEdgeLength();
        int bottomEdge = this.getHeight() - this.getPaddingBottom();
        int span = this.getChildAt(0).getBottom() - this.getScrollY() - bottomEdge;
        if (span < length) {
            return (float)span / (float)length;
        }
        return 1.0f;
    }

    protected float getLeftFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getHorizontalFadingEdgeLength();
        if (this.getScrollX() < length) {
            return (float)this.getScrollX() / (float)length;
        }
        return 1.0f;
    }

    protected float getRightFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getHorizontalFadingEdgeLength();
        int rightEdge = this.getWidth() - this.getPaddingRight();
        int span = this.getChildAt(0).getRight() - this.getScrollX() - rightEdge;
        if (span < length) {
            return (float)span / (float)length;
        }
        return 1.0f;
    }

    private void initTwoDScrollView() {
        this.mScroller = new Scroller(this.getContext());
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setWillNotDraw(false);
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
    }

    public void addView(View child) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("TwoDScrollView can host only one direct child");
        }
        super.addView(child);
    }

    public void addView(View child, int index) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("TwoDScrollView can host only one direct child");
        }
        super.addView(child, index);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("TwoDScrollView can host only one direct child");
        }
        super.addView(child, params);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("TwoDScrollView can host only one direct child");
        }
        super.addView(child, index, params);
    }

    private boolean canScroll() {
        View child = this.getChildAt(0);
        if (child != null) {
            int childHeight = child.getHeight();
            int childWidth = child.getWidth();
            return this.getHeight() < childHeight + this.getPaddingTop() + this.getPaddingBottom() || this.getWidth() < childWidth + this.getPaddingLeft() + this.getPaddingRight();
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.mIsBeingDragged) {
            return true;
        }
        if (!this.canScroll()) {
            this.mIsBeingDragged = false;
            return false;
        }
        float y = ev.getY();
        float x = ev.getX();
        switch (action) {
            case 2: {
                int yDiff = (int)Math.abs(y - this.mLastMotionY);
                int xDiff = (int)Math.abs(x - this.mLastMotionX);
                if (yDiff <= this.mTouchSlop && xDiff <= this.mTouchSlop) break;
                this.mIsBeingDragged = true;
                break;
            }
            case 0: {
                this.mLastMotionY = y;
                this.mLastMotionX = x;
                this.mIsBeingDragged = !this.mScroller.isFinished();
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0 && ev.getEdgeFlags() != 0) {
            return false;
        }
        if (!this.canScroll()) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        float y = ev.getY();
        float x = ev.getX();
        switch (action) {
            case 0: {
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mLastMotionY = y;
                this.mLastMotionX = x;
                break;
            }
            case 2: {
                int availableToScroll;
                int deltaX = (int)(this.mLastMotionX - x);
                int deltaY = (int)(this.mLastMotionY - y);
                this.mLastMotionX = x;
                this.mLastMotionY = y;
                if (deltaX < 0) {
                    if (this.getScrollX() < 0) {
                        deltaX = 0;
                    }
                } else if (deltaX > 0) {
                    int rightEdge = this.getWidth() - this.getPaddingRight();
                    availableToScroll = this.getChildAt(0).getRight() - this.getScrollX() - rightEdge;
                    deltaX = availableToScroll > 0 ? Math.min(availableToScroll, deltaX) : 0;
                }
                if (deltaY < 0) {
                    if (this.getScrollY() < 0) {
                        deltaY = 0;
                    }
                } else if (deltaY > 0) {
                    int bottomEdge = this.getHeight() - this.getPaddingBottom();
                    availableToScroll = this.getChildAt(0).getBottom() - this.getScrollY() - bottomEdge;
                    deltaY = availableToScroll > 0 ? Math.min(availableToScroll, deltaY) : 0;
                }
                if (deltaY == 0 && deltaX == 0) break;
                this.scrollBy(deltaX, deltaY);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000);
                int initialXVelocity = (int)velocityTracker.getXVelocity();
                int initialYVelocity = (int)velocityTracker.getYVelocity();
                if (Math.abs(initialXVelocity) + Math.abs(initialYVelocity) > this.mMinimumVelocity && this.getChildCount() > 0) {
                    this.fling(-initialXVelocity, -initialYVelocity);
                }
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }

    public boolean fullScroll(int direction_vert, int direction_horz) {
        boolean handled;
        View view;
        int count;
        int scrollAmountY = 0;
        int scrollAmountX = 0;
        switch (direction_vert) {
            case 33: {
                scrollAmountY = -this.getScrollY();
                break;
            }
            case 130: {
                count = this.getChildCount();
                if (count <= 0) break;
                view = this.getChildAt(count - 1);
                scrollAmountY = view.getBottom() - this.getHeight() - this.getScrollY();
            }
        }
        switch (direction_horz) {
            case 17: {
                scrollAmountX = -this.getScrollX();
                break;
            }
            case 66: {
                count = this.getChildCount();
                if (count <= 0) break;
                view = this.getChildAt(count - 1);
                scrollAmountX = view.getRight() - this.getWidth() - this.getScrollX();
            }
        }
        boolean bl = handled = scrollAmountX != 0 || scrollAmountY != 0;
        if (handled) {
            this.doScroll(scrollAmountX, scrollAmountY);
        }
        return handled;
    }

    private void doScroll(int deltaX, int deltaY) {
        if (deltaX != 0 || deltaY != 0) {
            this.smoothScrollBy(deltaX, deltaY);
        }
    }

    public final void smoothScrollBy(int dx, int dy) {
        long duration = AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll;
        if (duration > 250L) {
            this.mScroller.startScroll(this.getScrollX(), this.getScrollY(), dx, dy);
            this.awakenScrollBars(this.mScroller.getDuration());
            this.invalidate();
        } else {
            if (!this.mScroller.isFinished()) {
                this.mScroller.abortAnimation();
            }
            this.scrollBy(dx, dy);
        }
        this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
    }

    public final void smoothScrollTo(int x, int y) {
        this.smoothScrollBy(x - this.getScrollX(), y - this.getScrollY());
    }

    protected int computeVerticalScrollRange() {
        int count = this.getChildCount();
        return count == 0 ? this.getHeight() : this.getChildAt(0).getBottom();
    }

    protected int computeHorizontalScrollRange() {
        int count = this.getChildCount();
        return count == 0 ? this.getWidth() : this.getChildAt(0).getRight();
    }

    protected void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = TwoDScrollView.getChildMeasureSpec((int)parentWidthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)lp.width);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = TwoDScrollView.getChildMeasureSpec((int)parentWidthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp.leftMargin + lp.rightMargin + widthUsed), (int)lp.width);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(lp.topMargin + lp.bottomMargin), (int)0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                this.scrollTo(this.clamp(x, this.getWidth() - this.getPaddingRight() - this.getPaddingLeft(), child.getWidth()), this.clamp(y, this.getHeight() - this.getPaddingBottom() - this.getPaddingTop(), child.getHeight()));
            } else {
                this.scrollTo(x, y);
            }
            if (oldX != this.getScrollX() || oldY != this.getScrollY()) {
                this.onScrollChanged(this.getScrollX(), this.getScrollY(), oldX, oldY);
            }
            this.postInvalidate();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.scrollTo(this.getScrollX(), this.getScrollY());
    }

    public void fling(int velocityX, int velocityY) {
        if (this.getChildCount() > 0) {
            int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
            int bottom = this.getChildAt(0).getHeight();
            int width = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
            int right = this.getChildAt(0).getWidth();
            this.mScroller.fling(this.getScrollX(), this.getScrollY(), velocityX, velocityY, 0, right - width, 0, bottom - height);
            this.awakenScrollBars(this.mScroller.getDuration());
            this.invalidate();
        }
    }

    public void scrollTo(int x, int y) {
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            x = this.clamp(x, this.getWidth() - this.getPaddingRight() - this.getPaddingLeft(), child.getWidth());
            y = this.clamp(y, this.getHeight() - this.getPaddingBottom() - this.getPaddingTop(), child.getHeight());
            if (x != this.getScrollX() || y != this.getScrollY()) {
                super.scrollTo(x, y);
            }
        }
    }

    private int clamp(int n, int my, int child) {
        if (my >= child || n < 0) {
            return 0;
        }
        if (my + n > child) {
            return child - my;
        }
        return n;
    }
}

