package asia.redact.bracket.properties.mgmt;

import java.io.File;

/**
 * 
 * Data type to represent one of:
 * 
 * <table>
 * <tr>
 * <td>
 * ReferenceType.EXTERNAL, in which case data is understood to be an Operating system path to a properties file
 * </td>
 * </tr>
 * <tr>
 * <td>
 * ReferenceType.CLASSLOADED, in which case data is understood as a path to a class loadable properties file
 * </td>
 * </tr>
 * <tr>
 * <td>
 * ReferenceType.DIRECT, in which case data is understood as raw properties name value pairs to be parsed as such
 * </td>
 * </tr>
 * <tr>
 * <td>
 * ReferenceType.COMMANDLINE_OVERRIDE in which case data is the name of a property to be searched for from the command line 
 * </td>
 * </tr>
 * </table>
 * 
 * @author Dave
 *
 */
public class PropertiesReference {
	
	public final ReferenceType type;
	public final String data;
	
	
	public PropertiesReference(ReferenceType type, String data) {
		super();
		this.type = type;
		this.data = data;
	}

}
