/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.attrs.Annotation;

public class AnnotationMemberValue {
    private static final String TAGS = "BCDFIJSZsec@[";
    private static final Class[] TYPES = new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = AnnotationMemberValue.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Character == null ? (class$java$lang$Character = AnnotationMemberValue.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Double == null ? (class$java$lang$Double = AnnotationMemberValue.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Float == null ? (class$java$lang$Float = AnnotationMemberValue.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Integer == null ? (class$java$lang$Integer = AnnotationMemberValue.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = AnnotationMemberValue.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Short == null ? (class$java$lang$Short = AnnotationMemberValue.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Boolean == null ? (class$java$lang$Boolean = AnnotationMemberValue.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = AnnotationMemberValue.class$("java.lang.String")) : class$java$lang$String, class$org$objectweb$asm$attrs$AnnotationMemberValue$EnumConstValue == null ? (class$org$objectweb$asm$attrs$AnnotationMemberValue$EnumConstValue = AnnotationMemberValue.class$("org.objectweb.asm.attrs.AnnotationMemberValue$EnumConstValue")) : class$org$objectweb$asm$attrs$AnnotationMemberValue$EnumConstValue, class$org$objectweb$asm$Type == null ? (class$org$objectweb$asm$Type = AnnotationMemberValue.class$("org.objectweb.asm.Type")) : class$org$objectweb$asm$Type, class$org$objectweb$asm$attrs$Annotation == null ? (class$org$objectweb$asm$attrs$Annotation = AnnotationMemberValue.class$("org.objectweb.asm.attrs.Annotation")) : class$org$objectweb$asm$attrs$Annotation, array$Lorg$objectweb$asm$attrs$AnnotationMemberValue == null ? (array$Lorg$objectweb$asm$attrs$AnnotationMemberValue = AnnotationMemberValue.class$("[Lorg.objectweb.asm.attrs.AnnotationMemberValue;")) : array$Lorg$objectweb$asm$attrs$AnnotationMemberValue};
    private Object value;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$objectweb$asm$attrs$AnnotationMemberValue$EnumConstValue;
    static /* synthetic */ Class class$org$objectweb$asm$Type;
    static /* synthetic */ Class class$org$objectweb$asm$attrs$Annotation;
    static /* synthetic */ Class array$Lorg$objectweb$asm$attrs$AnnotationMemberValue;

    public AnnotationMemberValue() {
    }

    public AnnotationMemberValue(Object object) {
        this.value = object;
    }

    public int getTag() {
        int n = 0;
        while (n < TYPES.length) {
            if (this.value.getClass().equals(TYPES[n])) {
                return TAGS.charAt(n);
            }
            ++n;
        }
        return -1;
    }

    public Object getValue() {
        return this.value;
    }

    public int read(ClassReader classReader, int n, char[] cArray) {
        int n2 = classReader.readByte(n++);
        switch (n2) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                this.value = classReader.readConst(classReader.readUnsignedShort(n), cArray);
                n += 2;
                break;
            }
            case 115: {
                this.value = classReader.readUTF8(n, cArray);
                n += 2;
                break;
            }
            case 101: {
                this.value = new EnumConstValue(classReader.readUTF8(n, cArray), classReader.readUTF8(n + 2, cArray));
                n += 4;
                break;
            }
            case 99: {
                this.value = Type.getType((String)classReader.readClass(n, cArray));
                n += 2;
                break;
            }
            case 64: {
                this.value = new Annotation();
                n = ((Annotation)this.value).read(classReader, n, cArray);
                break;
            }
            case 91: {
                AnnotationMemberValue[] annotationMemberValueArray;
                int n3 = classReader.readUnsignedShort(n);
                n += 2;
                this.value = annotationMemberValueArray = new AnnotationMemberValue[n3];
                int n4 = 0;
                while (n4 < n3) {
                    annotationMemberValueArray[n4] = new AnnotationMemberValue();
                    n = annotationMemberValueArray[n4].read(classReader, n, cArray);
                    ++n4;
                }
                break;
            }
        }
        return n;
    }

    public ByteVector write(ByteVector byteVector, ClassWriter classWriter) {
        int n = this.getTag();
        byteVector.putByte(n);
        switch (n) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                byteVector.putShort(classWriter.newConst(this.value));
                break;
            }
            case 115: {
                byteVector.putShort(classWriter.newUTF8((String)this.value));
                break;
            }
            case 101: {
                ((EnumConstValue)this.value).write(byteVector, classWriter);
                break;
            }
            case 99: {
                byteVector.putShort(classWriter.newClass(((Type)this.value).getDescriptor()));
                break;
            }
            case 64: {
                ((Annotation)this.value).write(byteVector, classWriter);
                break;
            }
            case 91: {
                AnnotationMemberValue[] annotationMemberValueArray = (AnnotationMemberValue[])this.value;
                byteVector.putShort(annotationMemberValueArray.length);
                int n2 = 0;
                while (n2 < annotationMemberValueArray.length) {
                    annotationMemberValueArray[n2].write(byteVector, classWriter);
                    ++n2;
                }
                break;
            }
        }
        return byteVector;
    }

    public void dump(StringBuffer stringBuffer, String string) {
        int n = this.getTag();
        String string2 = string.concat("obj");
        switch (n) {
            case 66: {
                stringBuffer.append("Object ").append(string2).append(" = new Byte(").append(this.value).append(");\n");
                break;
            }
            case 67: {
                stringBuffer.append("Object ").append(string2).append(" = new Character((char)").append(this.value).append(");\n");
                break;
            }
            case 68: {
                stringBuffer.append("Object ").append(string2).append(" = new Double((double)").append(this.value).append(");\n");
                break;
            }
            case 70: {
                stringBuffer.append("Object ").append(string2).append(" = new Float((float)").append(this.value).append(");\n");
                break;
            }
            case 73: {
                stringBuffer.append("Object ").append(string2).append(" = new Integer((int)").append(this.value).append(");\n");
                break;
            }
            case 74: {
                stringBuffer.append("Object ").append(string2).append(" = new Long((long)").append(this.value).append(");\n");
                break;
            }
            case 83: {
                stringBuffer.append("Object ").append(string2).append(" = new Short((short)").append(this.value).append(");\n");
                break;
            }
            case 90: {
                stringBuffer.append("Object ").append(string2).append(" = new Boolean(").append(this.value).append(");\n");
                break;
            }
            case 115: {
                stringBuffer.append("Object ").append(string2).append(" = \"").append(this.value).append("\";\n");
                break;
            }
            case 101: {
                EnumConstValue enumConstValue = (EnumConstValue)this.value;
                stringBuffer.append("Object ").append(string2).append(" = new AnnotationMemberValue.EnumConstValue(\"").append(enumConstValue.typeName).append("\", \"").append(enumConstValue.constName).append("\"));\n");
                break;
            }
            case 99: {
                Type type = (Type)this.value;
                stringBuffer.append("Object ").append(string2).append(" = Type.getType(\"" + type.getDescriptor() + "\");\n");
                break;
            }
            case 64: {
                ((Annotation)this.value).dump(stringBuffer, string2);
                break;
            }
            case 91: {
                AnnotationMemberValue[] annotationMemberValueArray = (AnnotationMemberValue[])this.value;
                stringBuffer.append("AnnotationMemberValue[] ").append(string2).append(" = new AnnotationMemberValue[").append(annotationMemberValueArray.length).append("]\n;");
                stringBuffer.append("{\n");
                stringBuffer.append("Object av = null;\n");
                int n2 = 0;
                while (n2 < annotationMemberValueArray.length) {
                    annotationMemberValueArray[n2].dump(stringBuffer, string2 + n2);
                    stringBuffer.append(string2).append("[").append(n2).append("] = ").append(string2 + n2);
                    ++n2;
                }
                stringBuffer.append("};\n");
            }
        }
        stringBuffer.append("AnnotationMemberValue ").append(string);
        stringBuffer.append(" = new AnnotationMemberValue( ").append(string2).append(");\n");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getTag();
        switch (n) {
            case 115: {
                stringBuffer.append('\"').append(this.value).append('\"');
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 101: {
                stringBuffer.append(this.value);
                break;
            }
            case 99: {
                stringBuffer.append(this.value);
                break;
            }
            case 64: {
                stringBuffer.append(this.value);
                break;
            }
            case 91: {
                AnnotationMemberValue[] annotationMemberValueArray = (AnnotationMemberValue[])this.value;
                if (annotationMemberValueArray.length <= 0) break;
                stringBuffer.append("{ ");
                String string = "";
                int n2 = 0;
                while (n2 < annotationMemberValueArray.length) {
                    stringBuffer.append(string).append(annotationMemberValueArray[n2].toString());
                    string = ", ";
                    ++n2;
                }
                stringBuffer.append(" }");
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class EnumConstValue {
        public String typeName;
        public String constName;

        public EnumConstValue(String string, String string2) {
            this.typeName = string;
            this.constName = string2;
        }

        public void write(ByteVector byteVector, ClassWriter classWriter) {
            byteVector.putShort(classWriter.newUTF8(this.typeName));
            byteVector.putShort(classWriter.newUTF8(this.constName));
        }

        public String toString() {
            return this.typeName + "." + this.constName;
        }
    }
}

