/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.attrs.Dumpable;
import org.objectweb.asm.attrs.StackMapFrame;

public class StackMapAttribute
extends Attribute
implements Dumpable {
    static final int MAX_SIZE = 65535;
    public LinkedList frames = new LinkedList();

    public StackMapAttribute() {
        super("StackMap");
    }

    public StackMapFrame getFrame(Label label) {
        int n = 0;
        while (n < this.frames.size()) {
            StackMapFrame stackMapFrame = (StackMapFrame)this.frames.get(n);
            if (stackMapFrame.label == label) {
                return stackMapFrame;
            }
            ++n;
        }
        return null;
    }

    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        StackMapAttribute stackMapAttribute = new StackMapAttribute();
        int n4 = classReader.readInt(n3 + 4);
        int n5 = 0;
        if (n4 > 65535) {
            n5 = classReader.readInt(n);
            n += 4;
        } else {
            n5 = classReader.readShort(n);
            n += 2;
        }
        int n6 = 0;
        while (n6 < n5) {
            StackMapFrame stackMapFrame = new StackMapFrame();
            n = stackMapFrame.read(classReader, n, cArray, n3, labelArray);
            stackMapAttribute.frames.add(stackMapFrame);
            ++n6;
        }
        return stackMapAttribute;
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n, int n2, int n3) {
        ByteVector byteVector = new ByteVector();
        if (byArray.length > 65535) {
            byteVector.putInt(this.frames.size());
        } else {
            byteVector.putShort(this.frames.size());
        }
        int n4 = 0;
        while (n4 < this.frames.size()) {
            ((StackMapFrame)this.frames.get(n4)).write(classWriter, n2, n3, byteVector);
            ++n4;
        }
        return byteVector;
    }

    protected Label[] getLabels() {
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < this.frames.size()) {
            ((StackMapFrame)this.frames.get(n)).getLabels(hashSet);
            ++n;
        }
        return ((AbstractCollection)hashSet).toArray(new Label[hashSet.size()]);
    }

    public void dump(StringBuffer stringBuffer, String string, Map map) {
        stringBuffer.append("{\n");
        stringBuffer.append("StackMapAttribute ").append(string).append("Attr");
        stringBuffer.append(" = new StackMapAttribute();\n");
        if (this.frames.size() > 0) {
            int n = 0;
            while (n < this.frames.size()) {
                ((StackMapFrame)this.frames.get(n)).dump(stringBuffer, string + "frame" + n, map);
                ++n;
            }
        }
        stringBuffer.append(string).append(".visitAttribute(").append(string);
        stringBuffer.append("Attr);\n}\n");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StackMap[");
        int n = 0;
        while (n < this.frames.size()) {
            stringBuffer.append('\n').append('[').append(this.frames.get(n)).append(']');
            ++n;
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

