/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.attrs.Annotation;

public class AnnotationMemberValue {
    private Object value;

    public AnnotationMemberValue() {
    }

    public AnnotationMemberValue(Object object) {
        this.value = object;
    }

    public int getTag() {
        if (this.value instanceof Byte) {
            return 66;
        }
        if (this.value instanceof Character) {
            return 67;
        }
        if (this.value instanceof Double) {
            return 68;
        }
        if (this.value instanceof Float) {
            return 70;
        }
        if (this.value instanceof Integer) {
            return 73;
        }
        if (this.value instanceof Long) {
            return 74;
        }
        if (this.value instanceof Short) {
            return 83;
        }
        if (this.value instanceof Boolean) {
            return 90;
        }
        if (this.value instanceof String) {
            return 115;
        }
        if (this.value instanceof EnumConstValue) {
            return 101;
        }
        if (this.value instanceof Type) {
            return 99;
        }
        if (this.value instanceof Annotation) {
            return 64;
        }
        if (this.value instanceof AnnotationMemberValue[]) {
            return 91;
        }
        return -1;
    }

    public Object getValue() {
        return this.value;
    }

    public int read(ClassReader classReader, int n, char[] cArray) {
        int n2 = classReader.readByte(n++);
        switch (n2) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                this.value = classReader.readConst(classReader.readUnsignedShort(n), cArray);
                n += 2;
                break;
            }
            case 115: {
                this.value = classReader.readUTF8(n, cArray);
                n += 2;
                break;
            }
            case 101: {
                this.value = new EnumConstValue(classReader.readUTF8(n, cArray), classReader.readUTF8(n + 2, cArray));
                n += 4;
                break;
            }
            case 99: {
                this.value = Type.getType((String)classReader.readClass(n, cArray));
                n += 2;
                break;
            }
            case 64: {
                this.value = new Annotation();
                n = ((Annotation)this.value).read(classReader, n, cArray);
                break;
            }
            case 91: {
                AnnotationMemberValue[] annotationMemberValueArray;
                int n3 = classReader.readUnsignedShort(n);
                n += 2;
                this.value = annotationMemberValueArray = new AnnotationMemberValue[n3];
                for (int i = 0; i < n3; ++i) {
                    annotationMemberValueArray[i] = new AnnotationMemberValue();
                    n = annotationMemberValueArray[i].read(classReader, n, cArray);
                }
                break;
            }
        }
        return n;
    }

    public ByteVector write(ByteVector byteVector, ClassWriter classWriter) {
        int n = this.getTag();
        byteVector.putByte(n);
        switch (n) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                byteVector.putShort(classWriter.newConst(this.value));
                break;
            }
            case 115: {
                byteVector.putShort(classWriter.newUTF8((String)this.value));
                break;
            }
            case 101: {
                byteVector.putShort(classWriter.newUTF8(((EnumConstValue)this.value).typeName));
                byteVector.putShort(classWriter.newUTF8(((EnumConstValue)this.value).constName));
                break;
            }
            case 99: {
                byteVector.putShort(classWriter.newClass(((Type)this.value).getDescriptor()));
                break;
            }
            case 64: {
                ((Annotation)this.value).write(byteVector, classWriter);
                break;
            }
            case 91: {
                AnnotationMemberValue[] annotationMemberValueArray = (AnnotationMemberValue[])this.value;
                byteVector.putShort(annotationMemberValueArray.length);
                for (int i = 0; i < annotationMemberValueArray.length; ++i) {
                    annotationMemberValueArray[i].write(byteVector, classWriter);
                }
                break;
            }
        }
        return byteVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getTag();
        switch (n) {
            case 115: {
                stringBuffer.append('\"').append(this.value).append('\"');
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 101: {
                stringBuffer.append(this.value);
                break;
            }
            case 99: {
                stringBuffer.append(this.value);
                break;
            }
            case 64: {
                stringBuffer.append(this.value);
                break;
            }
            case 91: {
                AnnotationMemberValue[] annotationMemberValueArray = (AnnotationMemberValue[])this.value;
                if (annotationMemberValueArray.length <= 0) break;
                stringBuffer.append("{ ");
                String string = "";
                for (int i = 0; i < annotationMemberValueArray.length; ++i) {
                    stringBuffer.append(string).append(annotationMemberValueArray[i].toString());
                    string = ", ";
                }
                stringBuffer.append(" }");
            }
        }
        return stringBuffer.toString();
    }

    public static class EnumConstValue {
        public String typeName;
        public String constName;

        public EnumConstValue(String string, String string2) {
            this.typeName = string;
            this.constName = string2;
        }

        public String toString() {
            return this.typeName + "." + this.constName;
        }
    }
}

