/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import org.objectweb.asm.Attribute;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TreeCodeAdapter
extends CodeAdapter {
    public MethodNode methodNode;

    public TreeCodeAdapter(MethodNode methodNode) {
        super(null);
        this.methodNode = methodNode;
    }

    public void visitInsn(int n) {
        InsnNode insnNode = new InsnNode(n);
        this.methodNode.instructions.add(insnNode);
    }

    public void visitIntInsn(int n, int n2) {
        IntInsnNode intInsnNode = new IntInsnNode(n, n2);
        this.methodNode.instructions.add(intInsnNode);
    }

    public void visitVarInsn(int n, int n2) {
        VarInsnNode varInsnNode = new VarInsnNode(n, n2);
        this.methodNode.instructions.add(varInsnNode);
    }

    public void visitTypeInsn(int n, String string) {
        TypeInsnNode typeInsnNode = new TypeInsnNode(n, string);
        this.methodNode.instructions.add(typeInsnNode);
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        FieldInsnNode fieldInsnNode = new FieldInsnNode(n, string, string2, string3);
        this.methodNode.instructions.add(fieldInsnNode);
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        MethodInsnNode methodInsnNode = new MethodInsnNode(n, string, string2, string3);
        this.methodNode.instructions.add(methodInsnNode);
    }

    public void visitJumpInsn(int n, Label label) {
        JumpInsnNode jumpInsnNode = new JumpInsnNode(n, label);
        this.methodNode.instructions.add(jumpInsnNode);
    }

    public void visitLabel(Label label) {
        this.methodNode.instructions.add(label);
    }

    public void visitLdcInsn(Object object) {
        LdcInsnNode ldcInsnNode = new LdcInsnNode(object);
        this.methodNode.instructions.add(ldcInsnNode);
    }

    public void visitIincInsn(int n, int n2) {
        IincInsnNode iincInsnNode = new IincInsnNode(n, n2);
        this.methodNode.instructions.add(iincInsnNode);
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        TableSwitchInsnNode tableSwitchInsnNode = new TableSwitchInsnNode(n, n2, label, labelArray);
        this.methodNode.instructions.add(tableSwitchInsnNode);
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        LookupSwitchInsnNode lookupSwitchInsnNode = new LookupSwitchInsnNode(label, nArray, labelArray);
        this.methodNode.instructions.add(lookupSwitchInsnNode);
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        MultiANewArrayInsnNode multiANewArrayInsnNode = new MultiANewArrayInsnNode(string, n);
        this.methodNode.instructions.add(multiANewArrayInsnNode);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        TryCatchBlockNode tryCatchBlockNode = new TryCatchBlockNode(label, label2, label3, string);
        this.methodNode.tryCatchBlocks.add(tryCatchBlockNode);
    }

    public void visitMaxs(int n, int n2) {
        this.methodNode.maxStack = n;
        this.methodNode.maxLocals = n2;
    }

    public void visitLocalVariable(String string, String string2, Label label, Label label2, int n) {
        LocalVariableNode localVariableNode = new LocalVariableNode(string, string2, label, label2, n);
        this.methodNode.localVariables.add(localVariableNode);
    }

    public void visitLineNumber(int n, Label label) {
        LineNumberNode lineNumberNode = new LineNumberNode(n, label);
        this.methodNode.lineNumbers.add(lineNumberNode);
    }

    public void visitAttribute(Attribute attribute) {
        attribute.next = this.methodNode.codeAttrs;
        this.methodNode.codeAttrs = attribute;
    }
}

