/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.TraceAbstractVisitor;
import org.objectweb.asm.util.TraceFieldVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;

public class TraceClassVisitor
extends TraceAbstractVisitor
implements ClassVisitor {
    protected final PrintWriter pw;

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        boolean bl = true;
        boolean bl2 = true;
        if (stringArray.length < 1 || stringArray.length > 2) {
            bl2 = false;
        }
        if (bl2 && stringArray[0].equals("-debug")) {
            n = 1;
            bl = false;
            if (stringArray.length != 2) {
                bl2 = false;
            }
        }
        if (!bl2) {
            System.err.println("Prints a disassembled view of the given class.");
            System.err.println("Usage: TraceClassVisitor [-debug] <fully qualified class name or class file name>");
            System.exit(-1);
        }
        ClassReader classReader = stringArray[n].endsWith(".class") ? new ClassReader((InputStream)new FileInputStream(stringArray[n])) : new ClassReader(stringArray[n]);
        classReader.accept((ClassVisitor)new TraceClassVisitor(new PrintWriter(System.out)), TraceClassVisitor.getDefaultAttributes(), bl);
    }

    public TraceClassVisitor(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        int n3 = n & 0xFFFF;
        int n4 = n >>> 16;
        this.buf.setLength(0);
        this.buf.append("// class version ").append(n3).append('.').append(n4).append(" (").append(n).append(")\n");
        if ((n2 & 0x20000) != 0) {
            this.buf.append("// DEPRECATED\n");
        }
        this.buf.append("// access flags ").append(n2).append('\n');
        this.appendAccess(n2 & 0xFFFFFFDF);
        if ((n2 & 0x2000) != 0) {
            this.buf.append("@interface ");
        } else if ((n2 & 0x200) != 0) {
            this.buf.append("interface ");
        } else if ((n2 & 0x4000) != 0) {
            this.buf.append("enum ");
        } else {
            this.buf.append("class ");
        }
        this.appendDescriptor(0, string);
        this.buf.append(' ');
        if (string3 != null && !string3.equals("java/lang/Object")) {
            this.buf.append("extends ");
            this.appendDescriptor(0, string3);
            this.buf.append(' ');
        }
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append("implements ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.appendDescriptor(0, stringArray[i]);
                this.buf.append(' ');
            }
        }
        if (string2 != null) {
            this.buf.append("/* ");
            this.appendDescriptor(5, string2);
            this.buf.append(" */ {\n\n");
        } else {
            this.buf.append("{\n\n");
        }
        this.text.add(this.buf.toString());
    }

    public void visitSource(String string, String string2) {
        this.buf.setLength(0);
        if (string != null) {
            this.buf.append(this.tab).append("// compiled from: ").append(string).append('\n');
        }
        if (string2 != null) {
            this.buf.append(this.tab).append("// debug info: ").append(string2).append('\n');
        }
        if (this.buf.length() > 0) {
            this.text.add(this.buf.toString());
        }
    }

    public void visitOuterClass(String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("OUTERCLASS ");
        this.appendDescriptor(0, string);
        this.buf.append(' ').append(string2).append(' ');
        this.appendDescriptor(3, string3);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.text.add("\n");
        return super.visitAnnotation(Type.getType((String)string).getClassName(), bl);
    }

    public void visitAttribute(Attribute attribute) {
        this.text.add("\n");
        super.visitAttribute(attribute);
    }

    public void visitInnerClass(String string, String string2, String string3, int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("INNERCLASS ");
        this.appendDescriptor(0, string);
        this.buf.append(' ');
        this.appendDescriptor(0, string2);
        this.buf.append(' ');
        this.appendDescriptor(0, string3);
        this.buf.append(' ').append(n & 0xFFFFFFDF);
        if ((n & 0x4000) != 0) {
            this.buf.append("enum ");
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        this.buf.setLength(0);
        this.buf.append('\n');
        if ((n & 0x20000) != 0) {
            this.buf.append(this.tab).append("// DEPRECATED\n");
        }
        this.buf.append(this.tab).append("// access flags ").append(n).append('\n');
        this.buf.append(this.tab);
        this.appendAccess(n);
        if ((n & 0x4000) != 0) {
            this.buf.append("enum ");
        }
        this.appendDescriptor(1, string2);
        this.buf.append(' ').append(string);
        if (object != null) {
            this.buf.append(" = ");
            if (object instanceof String) {
                this.buf.append("\"").append(object).append("\"");
            } else {
                this.buf.append(object);
            }
        }
        if (string3 != null) {
            this.buf.append("// ");
            this.appendDescriptor(2, string3);
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        TraceFieldVisitor traceFieldVisitor = this.createTraceFieldVisitor();
        this.text.add(traceFieldVisitor.getText());
        return traceFieldVisitor;
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        this.buf.setLength(0);
        this.buf.append('\n');
        if ((n & 0x20000) != 0) {
            this.buf.append(this.tab).append("// DEPRECATED\n");
        }
        this.buf.append(this.tab).append("// access flags ").append(n).append('\n');
        this.buf.append(this.tab);
        this.appendAccess(n);
        if ((n & 0x100) != 0) {
            this.buf.append("native ");
        }
        if ((n & 0x80) != 0) {
            this.buf.append("varargs ");
        }
        if ((n & 0x40) != 0) {
            this.buf.append("bridge ");
        }
        this.buf.append(string).append(' ');
        this.appendDescriptor(3, string2);
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append(" throws ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.appendDescriptor(0, stringArray[i]);
                this.buf.append(' ');
            }
        }
        if (string3 != null) {
            this.buf.append("// ");
            this.appendDescriptor(4, string3);
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        TraceMethodVisitor traceMethodVisitor = this.createTraceMethodVisitor();
        this.text.add(traceMethodVisitor.getText());
        return traceMethodVisitor;
    }

    public void visitEnd() {
        this.text.add("}\n");
        this.printList(this.pw, this.text);
        this.pw.flush();
    }

    protected TraceFieldVisitor createTraceFieldVisitor() {
        return new TraceFieldVisitor();
    }

    protected TraceMethodVisitor createTraceMethodVisitor() {
        return new TraceMethodVisitor();
    }

    private void appendAccess(int n) {
        if ((n & 1) != 0) {
            this.buf.append("public ");
        }
        if ((n & 2) != 0) {
            this.buf.append("private ");
        }
        if ((n & 4) != 0) {
            this.buf.append("protected ");
        }
        if ((n & 0x10) != 0) {
            this.buf.append("final ");
        }
        if ((n & 8) != 0) {
            this.buf.append("static ");
        }
        if ((n & 0x20) != 0) {
            this.buf.append("synchronized ");
        }
        if ((n & 0x40) != 0) {
            this.buf.append("volatile ");
        }
        if ((n & 0x80) != 0) {
            this.buf.append("transient ");
        }
        if ((n & 0x400) != 0) {
            this.buf.append("abstract ");
        }
        if ((n & 0x800) != 0) {
            this.buf.append("strictfp ");
        }
    }
}

