/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.HashMap;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.AbstractVisitor;
import org.objectweb.asm.util.TraceAbstractVisitor;
import org.objectweb.asm.util.TraceAnnotationVisitor;

public class TraceMethodVisitor
extends TraceAbstractVisitor
implements MethodVisitor {
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    protected final HashMap labelNames = new HashMap();

    public AnnotationVisitor visitAnnotationDefault() {
        this.text.add(this.tab2 + "default=");
        TraceAnnotationVisitor traceAnnotationVisitor = new TraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add("\n");
        return traceAnnotationVisitor;
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append('@');
        this.appendDescriptor(1, string);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor traceAnnotationVisitor = new TraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add(bl ? ") // parameter " : ") // invisible, parameter ");
        this.text.add(new Integer(n));
        this.text.add("\n");
        return traceAnnotationVisitor;
    }

    public void visitInsn(int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitIntInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ').append(n2).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitVarInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ').append(n2).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitTypeInsn(int n, String string) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        if (string.startsWith("[")) {
            this.appendDescriptor(1, string);
        } else {
            this.appendDescriptor(0, string);
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendDescriptor(0, string);
        this.buf.append(' ').append(string2).append(' ');
        this.appendDescriptor(1, string3);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendDescriptor(0, string);
        this.buf.append(' ').append(string2).append(' ');
        this.appendDescriptor(3, string3);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitJumpInsn(int n, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitLdcInsn(Object object) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LDC ");
        if (object instanceof String) {
            if (object == null) {
                this.buf.append("null");
            } else if (object instanceof String) {
                AbstractVisitor.appendString(this.buf, (String)object);
            }
        } else if (object instanceof Type) {
            this.buf.append(((Type)object).getDescriptor() + ".class");
        } else {
            this.buf.append(object);
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitIincInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("IINC ").append(n).append(' ').append(n2).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TABLESWITCH\n");
        for (int i = 0; i < labelArray.length; ++i) {
            this.buf.append(this.tab3).append(n + i).append(": ");
            this.appendLabel(labelArray[i]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOOKUPSWITCH\n");
        for (int i = 0; i < labelArray.length; ++i) {
            this.buf.append(this.tab3).append(nArray[i]).append(": ");
            this.appendLabel(labelArray[i]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MULTIANEWARRAY ");
        this.appendDescriptor(1, string);
        this.buf.append(' ').append(n).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TRYCATCHBLOCK ");
        this.appendLabel(label);
        this.buf.append(' ');
        this.appendLabel(label2);
        this.buf.append(' ');
        this.appendLabel(label3);
        this.buf.append(' ');
        this.appendDescriptor(0, string);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOCALVARIABLE ").append(string).append(' ');
        this.appendDescriptor(1, string2);
        this.buf.append(' ');
        this.appendDescriptor(2, string3);
        this.buf.append(' ');
        this.appendLabel(label);
        this.buf.append(' ');
        this.appendLabel(label2);
        this.buf.append(' ').append(n).append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitLineNumber(int n, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LINENUMBER ").append(n).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
    }

    public void visitMaxs(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXSTACK = ").append(n).append('\n').append(this.tab2).append("MAXLOCALS = ").append(n2).append('\n');
        this.text.add(this.buf.toString());
    }

    protected void appendLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = "L" + this.labelNames.size();
            this.labelNames.put(label, string);
        }
        this.buf.append(string);
    }
}

