/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.xml;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.PrintCodeVisitor;
import org.objectweb.asm.xml.SAXClassAdapter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXCodeAdapter
implements CodeVisitor {
    private ContentHandler h;
    private Map labelNames;

    public SAXCodeAdapter(ContentHandler contentHandler) {
        this.h = contentHandler;
        this.labelNames = new HashMap();
    }

    public final void visitInsn(int n) {
        this.addElement(PrintCodeVisitor.OPCODES[n], new AttributesImpl());
    }

    public final void visitIntInsn(int n, int n2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "value", "value", "", Integer.toString(n2));
        this.addElement(PrintCodeVisitor.OPCODES[n], attributesImpl);
    }

    public final void visitVarInsn(int n, int n2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "var", "var", "", Integer.toString(n2));
        this.addElement(PrintCodeVisitor.OPCODES[n], attributesImpl);
    }

    public final void visitTypeInsn(int n, String string) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "desc", "desc", "", string);
        this.addElement(PrintCodeVisitor.OPCODES[n], attributesImpl);
    }

    public final void visitFieldInsn(int n, String string, String string2, String string3) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "owner", "owner", "", string);
        attributesImpl.addAttribute("", "name", "name", "", string2);
        attributesImpl.addAttribute("", "desc", "desc", "", string3);
        this.addElement(PrintCodeVisitor.OPCODES[n], attributesImpl);
    }

    public final void visitMethodInsn(int n, String string, String string2, String string3) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "owner", "owner", "", string);
        attributesImpl.addAttribute("", "name", "name", "", string2);
        attributesImpl.addAttribute("", "desc", "desc", "", string3);
        this.addElement(PrintCodeVisitor.OPCODES[n], attributesImpl);
    }

    public final void visitJumpInsn(int n, Label label) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "label", "label", "", this.getLabel(label));
        this.addElement(PrintCodeVisitor.OPCODES[n], attributesImpl);
    }

    public final void visitLabel(Label label) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "", this.getLabel(label));
        this.addElement("Label", attributesImpl);
    }

    public final void visitLdcInsn(Object object) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "cst", "cst", "", SAXClassAdapter.encode(object.toString()));
        attributesImpl.addAttribute("", "desc", "desc", "", Type.getDescriptor(object.getClass()));
        this.addElement(PrintCodeVisitor.OPCODES[18], attributesImpl);
    }

    public final void visitIincInsn(int n, int n2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "var", "var", "", Integer.toString(n));
        attributesImpl.addAttribute("", "inc", "inc", "", Integer.toString(n2));
        this.addElement(PrintCodeVisitor.OPCODES[132], attributesImpl);
    }

    public final void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "min", "min", "", Integer.toString(n));
        attributesImpl.addAttribute("", "max", "max", "", Integer.toString(n2));
        attributesImpl.addAttribute("", "dflt", "dflt", "", this.getLabel(label));
        String string = PrintCodeVisitor.OPCODES[170];
        this.addStart(string, attributesImpl);
        for (int i = 0; i < labelArray.length; ++i) {
            AttributesImpl attributesImpl2 = new AttributesImpl();
            attributesImpl2.addAttribute("", "name", "name", "", this.getLabel(labelArray[i]));
            this.addElement("label", attributesImpl2);
        }
        this.addEnd(string);
    }

    public final void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "dflt", "dflt", "", this.getLabel(label));
        String string = PrintCodeVisitor.OPCODES[171];
        this.addStart(string, attributesImpl);
        for (int i = 0; i < labelArray.length; ++i) {
            AttributesImpl attributesImpl2 = new AttributesImpl();
            attributesImpl2.addAttribute("", "name", "name", "", this.getLabel(labelArray[i]));
            attributesImpl2.addAttribute("", "key", "key", "", Integer.toString(nArray[i]));
            this.addElement("label", attributesImpl2);
        }
        this.addEnd(string);
    }

    public final void visitMultiANewArrayInsn(String string, int n) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "desc", "desc", "", string);
        attributesImpl.addAttribute("", "dims", "dims", "", Integer.toString(n));
        this.addElement(PrintCodeVisitor.OPCODES[197], attributesImpl);
    }

    public final void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "start", "start", "", this.getLabel(label));
        attributesImpl.addAttribute("", "end", "end", "", this.getLabel(label2));
        attributesImpl.addAttribute("", "handler", "handler", "", this.getLabel(label3));
        if (string != null) {
            attributesImpl.addAttribute("", "type", "type", "", string);
        }
        this.addElement("TryCatch", attributesImpl);
    }

    public final void visitMaxs(int n, int n2) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "maxStack", "maxStack", "", Integer.toString(n));
        attributesImpl.addAttribute("", "maxLocals", "maxLocals", "", Integer.toString(n2));
        this.addElement("Max", attributesImpl);
        this.addEnd("code");
        this.addEnd("method");
    }

    public final void visitLocalVariable(String string, String string2, Label label, Label label2, int n) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "name", "name", "", string);
        attributesImpl.addAttribute("", "desc", "desc", "", string2);
        attributesImpl.addAttribute("", "start", "start", "", this.getLabel(label));
        attributesImpl.addAttribute("", "end", "end", "", this.getLabel(label2));
        attributesImpl.addAttribute("", "var", "var", "", Integer.toString(n));
        this.addElement("LocalVar", attributesImpl);
    }

    public final void visitLineNumber(int n, Label label) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "line", "line", "", Integer.toString(n));
        attributesImpl.addAttribute("", "start", "start", "", this.getLabel(label));
        this.addElement("LineNumber", attributesImpl);
    }

    public final void visitAttribute(Attribute attribute) {
    }

    private final String getLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = Integer.toString(this.labelNames.size());
            this.labelNames.put(label, string);
        }
        return string;
    }

    private final void addElement(String string, Attributes attributes) {
        this.addStart(string, attributes);
        this.addEnd(string);
    }

    private final void addStart(String string, Attributes attributes) {
        try {
            this.h.startElement("", string, string, attributes);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
    }

    private final void addEnd(String string) {
        try {
            this.h.endElement("", string, string);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException(sAXException.toString());
        }
    }
}

