/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ant.taskdefs;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Ajc
extends MatchingTask {
    public static final String AJC_CLASSNAME = "org.aspectj.tools.ajc.Main";
    public static final String FALSE_MAIN = "org.aspectj.tools.ant.taskdefs.Ajc";
    protected boolean version;
    protected boolean source14;
    protected Set ignoredOptions;
    protected Commandline cmd;
    protected Commandline vmcmd;
    private int threads = -1;
    private File destdir;
    private File workingdir;
    private Path internalclasspath;
    private Path classpath;
    private Path bootclasspath;
    private Path extdirs;
    private Path srcdir;
    private List argfiles;
    private boolean fork;
    private boolean failonerror;
    static /* synthetic */ Class array$Ljava$lang$String;

    public Ajc() {
        this.reset();
    }

    public void setVerbose(boolean verbose) {
        this.setif(verbose, "-verbose");
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public void setNocomments(boolean nocomments) {
        this.setif(nocomments, "-nocomments");
    }

    public void setEmacssym(boolean input) {
        this.setif(input, "-emacssym");
    }

    public void setUsejavac(boolean input) {
        this.setif(input, "-usejavac");
    }

    public void setPreprocess(boolean preprocess) {
        this.setif(preprocess, "-preprocess");
    }

    public void setWorkingdir(String workingdir) {
        this.workingdir = ((ProjectComponent)this).project.resolveFile(workingdir);
    }

    public void setDestdir(String destdir) {
        this.destdir = ((ProjectComponent)this).project.resolveFile(destdir);
    }

    public void setOptimize(boolean optimize) {
        this.setif(optimize, "-O");
    }

    public void setClasspath(Path classpath) {
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(((ProjectComponent)this).project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathref(Reference classpathref) {
        this.createClasspath().setRefid(classpathref);
    }

    public void setBootclasspath(Path bootclasspath) {
        if (this.bootclasspath == null) {
            this.bootclasspath = bootclasspath;
        } else {
            this.bootclasspath.append(bootclasspath);
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(((ProjectComponent)this).project);
        }
        return this.bootclasspath.createPath();
    }

    public void setBootclasspathref(Reference bootclasspathref) {
        this.createBootclasspath().setRefid(bootclasspathref);
    }

    public void setExtdirs(Path extdirs) {
        if (this.extdirs == null) {
            this.extdirs = extdirs;
        } else {
            this.extdirs.append(extdirs);
        }
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(((ProjectComponent)this).project);
        }
        return this.extdirs.createPath();
    }

    public void setArgfile(File argfile) {
        if (this.argfiles == null) {
            this.argfiles = new Vector();
        }
        this.argfiles.add(argfile);
    }

    public void setArgfiles(String argfiles) {
        StringTokenizer tok = new StringTokenizer(argfiles, ", ", false);
        if (tok.hasMoreTokens() && this.argfiles == null) {
            this.argfiles = new Vector();
        }
        while (tok.hasMoreTokens()) {
            this.argfiles.add(((ProjectComponent)this).project.resolveFile(tok.nextToken().trim()));
        }
    }

    public void setEncoding(String encoding) {
        this.ignore("encoding");
    }

    public void setSource(String input) {
        this.source14 = "1.4".equals(input);
    }

    public void setLenient(boolean input) {
        this.setif(input, "-lenient");
    }

    public void setStrict(boolean input) {
        this.setif(input, "-strict");
    }

    public void setPorting(boolean input) {
        this.setif(input, "-porting");
    }

    public void setX(String input) {
        StringTokenizer tokens = new StringTokenizer(input, ",", false);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (1 >= token.length()) continue;
            this.setif(true, "-X" + token);
        }
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setDumpstack(boolean dumpstack) {
        this.setif(dumpstack, "-dumpstack");
    }

    public void setInternalclasspath(Path internalclasspath) {
        if (this.internalclasspath == null) {
            this.internalclasspath = internalclasspath;
        } else {
            this.internalclasspath.append(internalclasspath);
        }
    }

    public Path createInternalclasspath() {
        if (this.internalclasspath == null) {
            this.internalclasspath = new Path(((ProjectComponent)this).project);
        }
        return this.internalclasspath.createPath();
    }

    public void setInternalclasspathref(Reference internalclasspathref) {
        this.createInternalclasspath().setRefid(internalclasspathref);
    }

    public void setSrcdir(Path srcdir) {
        if (this.srcdir == null) {
            this.srcdir = srcdir;
        } else {
            this.srcdir.append(srcdir);
        }
    }

    public Path createSrc() {
        return this.createSrcdir();
    }

    public Path createSrcdir() {
        if (this.srcdir == null) {
            this.srcdir = new Path(((ProjectComponent)this).project);
        }
        return this.srcdir.createPath();
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setMaxmemory(String max) {
        this.createJvmarg().setValue((Project.getJavaVersion().startsWith("1.1") ? "-mx" : "-Xmx") + max);
    }

    public void setJvmarg(String input) {
        this.vmcmd.createArgument().setValue(input);
    }

    public Commandline.Argument createJvmarg() {
        return this.vmcmd.createArgument();
    }

    public void setNosymbols(boolean nosymbols) {
        this.setif(nosymbols, "-nosymbols");
    }

    public void setDebug(boolean debug) {
        this.setif(debug, "-g");
    }

    public void setDeprecation(boolean deprecation) {
        this.setif(deprecation, "-deprecation");
    }

    public void setTarget(String target) {
        this.ignore("target");
    }

    public void setDepend(String depend) {
        this.ignore("depend");
    }

    public void setIncludeantruntime(boolean includeAntruntime) {
        this.ignore("includeantruntime");
    }

    public void setIncludejavaruntime(boolean includeJavaruntime) {
        this.ignore("includeJavaruntime");
    }

    protected final void ignore(String attribute) {
        this.ignoredOptions.add(attribute);
    }

    public void backdoorSetFile(File file) {
        if (null != file) {
            this.cmd.createArgument().setFile(file);
        }
    }

    public void reset() {
        this.cmd = new Commandline();
        this.vmcmd = new Commandline();
        this.threads = -1;
        this.destdir = null;
        this.workingdir = null;
        this.internalclasspath = null;
        this.classpath = null;
        this.bootclasspath = null;
        this.extdirs = null;
        this.srcdir = null;
        this.argfiles = null;
        this.fork = false;
        this.failonerror = true;
        this.version = false;
        this.ignoredOptions = new HashSet();
    }

    protected final void setif(boolean b, String flag) {
        if (b) {
            this.cmd.createArgument().setValue(flag);
        }
    }

    public void execute() throws BuildException {
        int result;
        if (this.srcdir == null && this.argfiles == null) {
            throw new BuildException("one of srcdir or argfiles must be set!", ((Task)this).location);
        }
        if (this.threads != -1) {
            this.cmd.createArgument().setValue("-threads");
            this.cmd.createArgument().setValue(this.threads + "");
        }
        if (this.workingdir != null) {
            this.cmd.createArgument().setValue("-workingdir");
            this.cmd.createArgument().setFile(this.workingdir);
        }
        if (this.destdir != null) {
            this.cmd.createArgument().setValue("-d");
            this.cmd.createArgument().setFile(this.destdir);
        }
        if (this.classpath != null) {
            this.cmd.createArgument().setValue("-classpath");
            this.cmd.createArgument().setPath(this.classpath);
        }
        if (this.bootclasspath != null) {
            this.cmd.createArgument().setValue("-bootclasspath");
            this.cmd.createArgument().setPath(this.bootclasspath);
        }
        if (this.extdirs != null) {
            this.cmd.createArgument().setValue("-extdirs");
            this.cmd.createArgument().setPath(this.extdirs);
        }
        if (this.source14) {
            this.cmd.createArgument().setValue("-source");
            this.cmd.createArgument().setValue("1.4");
        }
        int numargfiles = 0;
        if (this.argfiles != null) {
            Iterator i = this.argfiles.iterator();
            while (i.hasNext()) {
                String name = i.next() + "";
                File argfile = ((ProjectComponent)this).project.resolveFile(name);
                if (!this.check(argfile, name, false, ((Task)this).location)) continue;
                this.cmd.createArgument().setValue("-argfile");
                this.cmd.createArgument().setFile(argfile);
                ++numargfiles;
            }
        }
        int numfiles = 0;
        if (this.srcdir != null) {
            String[] dirs = this.srcdir.list();
            int i = 0;
            while (i < dirs.length) {
                File dir = ((ProjectComponent)this).project.resolveFile(dirs[i]);
                this.check(dir, dirs[i], true, ((Task)this).location);
                String[] files = this.getDirectoryScanner(dir).getIncludedFiles();
                int j = 0;
                while (j < files.length) {
                    File file = new File(dir, files[j]);
                    if (file.getName().endsWith(".java") || file.getName().endsWith(".aj")) {
                        this.cmd.createArgument().setFile(file);
                        ++numfiles;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (null != this.ignoredOptions && this.ignoredOptions.size() > 0) {
            this.log("The following attributes were ignored " + this.ignoredOptions, 1);
        }
        this.log("Compiling " + numfiles + " source and " + numargfiles + " arg files" + (null == this.destdir ? "" : " to " + this.destdir.getPath()));
        int n = result = this.fork || this.internalclasspath != null ? this.fork() : this.spoon();
        if (result != 0) {
            String msg = "Compilation error: " + result;
            if (this.failonerror) {
                this.reset();
                throw new BuildException(msg);
            }
            this.log(msg, 1);
        }
        this.reset();
    }

    protected void version(Path classpath) {
        try {
            Class main = this.findClass(AJC_CLASSNAME, classpath);
            Method printVersion = main.getDeclaredMethod("printVersion", new Class[0]);
            ((AccessibleObject)printVersion).setAccessible(true);
            printVersion.invoke(main.newInstance(), new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Class findClass(String classname, Path classpathPath) {
        String classpath = (classpathPath != null ? classpathPath + "" : "").trim();
        if (classpath.length() == 0) {
            try {
                return Class.forName(classname);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer t = new StringTokenizer(classpath, File.pathSeparator);
        while (t.hasMoreTokens()) {
            File f = new File(t.nextToken().trim());
            try {
                URL url;
                if (!f.exists() || (url = f.toURL()) == null) continue;
                urls.add(url);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (urls.size() == 0) {
            return null;
        }
        try {
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), null).loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected int fork() throws BuildException {
        Path compileClasspath;
        Java java = (Java)((ProjectComponent)this).project.createTask("java");
        java.setTaskName(this.getTaskName());
        if (this.internalclasspath != null) {
            compileClasspath = this.internalclasspath;
            compileClasspath.append(Path.systemClasspath);
        } else {
            compileClasspath = Path.systemClasspath;
        }
        if (this.version) {
            this.version(compileClasspath);
        }
        java.setClasspath(compileClasspath);
        java.setClassname(FALSE_MAIN);
        String[] args = this.cmd.getArguments();
        int i = 0;
        while (i < args.length) {
            java.createArg().setValue(args[i]);
            ++i;
        }
        args = this.vmcmd.getArguments();
        int i2 = 0;
        while (i2 < args.length) {
            java.createJvmarg().setValue(args[i2]);
            ++i2;
        }
        java.setFork(this.fork);
        return java.executeJava();
    }

    public static String render(String[] args) {
        if (null == args) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            sb.append(args[i]);
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    protected int spoon() throws BuildException {
        if (this.version) {
            this.version(null);
        }
        try {
            this.log("Running  in-process org.aspectj.tools.ajc.Main using " + Ajc.render(this.cmd.getCommandline()), 3);
            Object main = Class.forName(AJC_CLASSNAME).newInstance();
            return (Integer)main.getClass().getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Ajc.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).invoke(main, new Object[]{this.cmd.getCommandline()});
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new BuildException("Couldn't create compiler!", t, ((Task)this).location);
        }
    }

    protected final boolean check(File file, String name, boolean isDir, Location loc) {
        Location location = loc = loc != null ? loc : ((Task)this).location;
        if (file == null) {
            throw new BuildException(name + " is null!", loc);
        }
        if (!file.exists()) {
            throw new BuildException(file + "doesn't exist!", loc);
        }
        if (isDir ^ file.isDirectory()) {
            String e = file + " should" + (isDir ? "" : "n't") + " be a directory!";
            throw new BuildException(e, loc);
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            Class<?> main = Class.forName(AJC_CLASSNAME);
            main.getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Ajc.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).invoke(main.newInstance(), new Object[]{args});
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

