/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.internal;

import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.internal.AjdeBuildErrorHandler;
import org.aspectj.ajde.internal.BadRuntimeError;
import org.aspectj.ajde.internal.MissingRuntimeError;
import org.aspectj.asm.StructureModelManager;
import org.aspectj.compiler.crosscuts.AspectJCompiler;

public class AjdeCompiler
extends AspectJCompiler {
    boolean structureDirty = true;
    private boolean doPostSymbolPasses = true;
    private String configFile = null;
    private StructureModelManager structureManager;
    private BuildProgressMonitor progressMonitor;
    private static final int MAX_PROGRESS_VAL = 100;

    public AjdeCompiler(StructureModelManager structureManager) {
        this.structureManager = structureManager;
    }

    public AjdeCompiler(StructureModelManager structureManager, BuildProgressMonitor progressMonitor) {
        super(new AjdeBuildErrorHandler(Ajde.getDefault().getTaskListManager()));
        ((AjdeBuildErrorHandler)this.errorHandler).setCompiler(this);
        this.structureManager = structureManager;
        this.progressMonitor = progressMonitor;
        this.progressMonitor.setProgressBarMax(100);
    }

    public void setDoPostSymbolPasses(boolean doPostSymbolPasses) {
        this.doPostSymbolPasses = doPostSymbolPasses;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getBuildConfigFile() {
        return this.configFile;
    }

    public void abort() {
        this.clearState();
    }

    public void addPostSymbolPasses() {
        this.addPass(new StructureModelManager.UpdateStructurePass(this.getCompiler(), this.structureManager));
        if (this.doPostSymbolPasses) {
            super.addPostSymbolPasses();
        }
    }

    protected void addBytecodeGenerationPasses() {
        if (this.doPostSymbolPasses) {
            super.addBytecodeGenerationPasses();
        }
    }

    protected void updateCompileState(String section, String subSection, double pct) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setProgressBarVal((int)(pct * 100.0));
            this.progressMonitor.setProgressText(section + ":" + subSection);
        }
    }

    protected void initializeWorld(List filenames) {
        super.initializeWorld(filenames);
        this.structureDirty = true;
    }

    protected void warnNoRuntime(boolean foundOld) {
        if (foundOld) {
            throw new BadRuntimeError();
        }
        throw new MissingRuntimeError();
    }

    public AjdeBuildErrorHandler getAjdeBuildErrorHandler() {
        return (AjdeBuildErrorHandler)this.errorHandler;
    }
}

