/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildListener;
import org.aspectj.ajde.BuildManager;
import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.internal.AjdeCompiler;
import org.aspectj.ajde.internal.BadRuntimeError;
import org.aspectj.ajde.internal.ConfigFileDoesNotExistException;
import org.aspectj.ajde.internal.MissingRuntimeError;
import org.aspectj.asm.SourceLocation;
import org.aspectj.asm.StructureMessage;
import org.aspectj.asm.StructureNode;
import org.aspectj.compiler.base.CompilerErrors;
import org.aspectj.compiler.base.ExitRequestException;
import org.aspectj.compiler.base.InternalCompilerError;
import org.aspectj.util.ConfigParser;

public class AspectJBuildManager
implements BuildManager {
    private AjdeCompiler currCompiler = null;
    private TaskListManager compilerMessages = null;
    private BuildProgressMonitor progressMonitor = null;
    private BuildOptionsAdapter buildOptions = null;
    private ArrayList compilerListeners = new ArrayList();
    private String configFile = "";
    private int lastCompileTime = 50;
    private boolean buildStrucutreOnly = false;

    public AspectJBuildManager(TaskListManager compilerMessages, BuildProgressMonitor progressMonitor, BuildOptionsAdapter buildOptions) {
        this.compilerMessages = compilerMessages;
        this.progressMonitor = progressMonitor;
        this.buildOptions = buildOptions;
    }

    public void build() {
        if (Ajde.getDefault().getConfigurationManager().getActiveConfigFile() == null) {
            Ajde.getDefault().getErrorHandler().handleWarning("Nothing to compile, please add a \".lst\" file.");
            return;
        }
        this.build(Ajde.getDefault().getConfigurationManager().getActiveConfigFile());
    }

    public void buildStructure() {
        this.buildStrucutreOnly = true;
        this.build();
    }

    public void build(String configFile) {
        this.buildStrucutreOnly = false;
        this.buildOptions = this.buildOptions;
        if (configFile == null) {
            Ajde.getDefault().getErrorHandler().handleWarning("Please add a configuration file to compile.");
        } else {
            this.configFile = configFile;
            CompilerThread compilerThread = new CompilerThread();
            compilerThread.start();
        }
    }

    public void abortBuild() {
        if (this.currCompiler != null) {
            this.currCompiler.requestCompileExit();
        }
    }

    public AjdeCompiler getCurrCompiler() {
        return this.currCompiler;
    }

    public boolean isStructureDirty() {
        if (this.currCompiler != null) {
            return this.currCompiler.structureDirty;
        }
        return false;
    }

    public void setStructureDirty(boolean structureDirty) {
        if (this.currCompiler != null) {
            this.currCompiler.structureDirty = structureDirty;
        }
    }

    public void addListener(BuildListener compilerListener) {
        this.compilerListeners.add(compilerListener);
    }

    public void removeListener(BuildListener compilerListener) {
        ((AbstractCollection)this.compilerListeners).remove(compilerListener);
    }

    private void notifyCompileFinished(String configFile, int buildTime, boolean succeeded, boolean warnings) {
        Ajde.getDefault().logEvent("build finished, succeeded: " + succeeded);
        Iterator it = ((AbstractList)this.compilerListeners).iterator();
        while (it.hasNext()) {
            ((BuildListener)it.next()).compileFinished(configFile, buildTime, succeeded, warnings);
        }
    }

    private void notifyCompileStarted(String configFile) {
        Ajde.getDefault().logEvent("build started: " + configFile);
        Iterator it = ((AbstractList)this.compilerListeners).iterator();
        while (it.hasNext()) {
            ((BuildListener)it.next()).compileStarted(configFile);
        }
    }

    private void notifyCompileAborted(String configFile, String message) {
        Iterator it = ((AbstractList)this.compilerListeners).iterator();
        while (it.hasNext()) {
            ((BuildListener)it.next()).compileAborted(configFile, message);
        }
    }

    private void displayMessages(CompileResult compileResult) {
        String[] descriptions = compileResult.getDescriptions();
        String[] files = compileResult.getfiles();
        Integer[] lineNumbers = compileResult.getLineNumbers();
        if (descriptions.length == 0 && compileResult.getResult().trim() != "") {
            this.compilerMessages.addSourcelineTask(compileResult.getResult(), new SourceLocation("", 0, 0), StructureMessage.Kind.ERROR);
            return;
        }
        int i = 0;
        while (i < descriptions.length && i < files.length && i < lineNumbers.length) {
            String message = "";
            if (files[i] != "") {
                message = message + "\"" + files[i] + "\": ";
            }
            if ((message = lineNumbers[i] != -1 && lineNumbers[i] != 0 ? message + descriptions[i] + ", at line: " + lineNumbers[i] : message + descriptions[i]).startsWith("Nothing to compile.")) {
                message = "Nothing to compile, please select the project, package(s), or class(es) to compile.";
            }
            StructureMessage.Kind kind = StructureMessage.Kind.ERROR;
            if (descriptions[i].endsWith("(warning)")) {
                kind = StructureMessage.Kind.WARNING;
            }
            this.compilerMessages.addSourcelineTask(message, new SourceLocation(files[i], lineNumbers[i], 0), kind);
            StructureNode node = Ajde.getDefault().getStructureModelManager().getStructureModel().findNodeForSourceLine(files[i], lineNumbers[i]);
            if (node != null) {
                node.setMessage(new StructureMessage(message, kind));
            }
            ++i;
        }
    }

    public BuildOptionsAdapter getBuildOptions() {
        return this.buildOptions;
    }

    private void setCompilerOptions(AjdeCompiler compiler) {
        String nonstandardOptions = this.buildOptions.getNonStandardOptions();
        if (nonstandardOptions != null && !nonstandardOptions.trim().equals("")) {
            StringTokenizer st = new StringTokenizer(nonstandardOptions, " ");
            while (st.hasMoreTokens()) {
                String flag = st.nextToken();
                compiler.getOptions().set(flag.substring(1, flag.length()), Boolean.TRUE);
            }
        }
        if (Ajde.getDefault().getProjectProperties().getOutputPath() != null && !compiler.getOptions().XtargetNearSource) {
            compiler.getOptions().outputDir = new File(Ajde.getDefault().getProjectProperties().getOutputPath());
        }
        if (Ajde.getDefault().getProjectProperties().getBootClasspath() != null) {
            compiler.getOptions().bootclasspath = Ajde.getDefault().getProjectProperties().getBootClasspath();
        }
        if (Ajde.getDefault().getProjectProperties().getClasspath() != null) {
            compiler.getOptions().classpath = Ajde.getDefault().getProjectProperties().getClasspath();
        }
        if (this.buildOptions.getWorkingOutputPath() != null) {
            compiler.getOptions().workingDir = new File(this.buildOptions.getWorkingOutputPath());
        }
        compiler.getOptions().lenient = this.buildOptions.getLenientSpecMode();
        compiler.getOptions().strict = this.buildOptions.getStrictSpecMode();
        compiler.getOptions().usejavac = this.buildOptions.getUseJavacMode();
        compiler.getOptions().porting = this.buildOptions.getPortingMode();
        compiler.getOptions().preprocess = this.buildOptions.getPreprocessMode();
        if (this.buildOptions.getSourceOnePointFourMode()) {
            compiler.getOptions().source = "1.4";
        }
    }

    static class CompileResult {
        private String[] files = null;
        private Integer[] lineNumbers = null;
        private String[] descriptions = null;
        private String resultString = "";
        private boolean resultContainsErrors = false;

        public CompileResult(String result) {
            this.resultString = result;
            BufferedReader reader = new BufferedReader(new StringReader(result));
            Vector<String> fileV = new Vector<String>();
            Vector<Integer> lineV = new Vector<Integer>();
            Vector<String> descV = new Vector<String>();
            try {
                String line = reader.readLine();
                while (line != null) {
                    String originalLine = line;
                    String description = "";
                    String file = "";
                    Integer lineNo = new Integer(0);
                    int index = line.indexOf(":", 2);
                    try {
                        if (line.indexOf("Note: ") != -1) {
                            int index1 = line.indexOf(".java");
                            if (index1 != -1) {
                                description = line.substring(index1 + 5) + " (warning)";
                                file = line.substring("Note: ".length(), index1 + 5);
                                lineNo = new Integer(0);
                            } else {
                                description = line + " (warning)";
                                file = "";
                                lineNo = new Integer(-1);
                            }
                        } else if (line.indexOf("file not found: ") != -1) {
                            description = "file not found: ";
                            file = line.substring("file not found: ".length());
                            lineNo = new Integer(0);
                        } else if (index != -1 && line.indexOf("java") != -1) {
                            file = line.substring(0, index);
                            line = line.substring(index + 1);
                            index = line.indexOf(":");
                            lineNo = new Integer(Integer.parseInt(line.substring(0, index)));
                            line = line.substring(index + 1);
                            if (!this.resultContainsErrors && !line.endsWith("(warning)")) {
                                this.resultContainsErrors = true;
                            }
                            description = line.substring(line.indexOf(":") + 2);
                        }
                    }
                    catch (Exception e) {
                        description = "Internal ajc message: " + originalLine;
                        file = "";
                        lineNo = new Integer(-1);
                    }
                    if (description.trim() != "") {
                        descV.addElement(description);
                        fileV.addElement(file);
                        lineV.addElement(lineNo);
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException ioe) {
                this.resultString = "ERROR: could not parse result at line for string: " + result;
            }
            this.files = new String[fileV.size()];
            this.lineNumbers = new Integer[lineV.size()];
            this.descriptions = new String[descV.size()];
            fileV.copyInto(this.files);
            lineV.copyInto(this.lineNumbers);
            descV.copyInto(this.descriptions);
        }

        public String toString() {
            return this.resultString;
        }

        public String[] getfiles() {
            return this.files;
        }

        public Integer[] getLineNumbers() {
            return this.lineNumbers;
        }

        public String[] getDescriptions() {
            return this.descriptions;
        }

        public String getResult() {
            return this.resultString;
        }

        public boolean containsErrors() {
            return this.resultContainsErrors;
        }
    }

    public class CompilerThread
    extends Thread {
        public void run() {
            boolean warnings;
            boolean succeeded;
            block22: {
                succeeded = true;
                warnings = false;
                try {
                    try {
                        long timeStart = System.currentTimeMillis();
                        AspectJBuildManager.this.notifyCompileStarted(AspectJBuildManager.this.configFile);
                        AspectJBuildManager.this.progressMonitor.start(AspectJBuildManager.this.configFile);
                        AspectJBuildManager.this.compilerMessages.clearTasks();
                        AjdeCompiler compiler = new AjdeCompiler(Ajde.getDefault().getStructureModelManager(), AspectJBuildManager.this.progressMonitor);
                        AspectJBuildManager.this.setCompilerOptions(compiler);
                        Ajde.getDefault().logEvent("building with options: " + this.getFormattedOptionsString(AspectJBuildManager.this.buildOptions, Ajde.getDefault().getProjectProperties()));
                        compiler.setConfigFile(AspectJBuildManager.this.configFile);
                        if (AspectJBuildManager.this.buildStrucutreOnly) {
                            compiler.setDoPostSymbolPasses(false);
                        }
                        AspectJBuildManager.this.currCompiler = compiler;
                        File config = new File(AspectJBuildManager.this.configFile);
                        if (!config.exists()) {
                            throw new ConfigFileDoesNotExistException(AspectJBuildManager.this.configFile);
                        }
                        ConfigParser configParser = new ConfigParser();
                        configParser.parseConfigFile(config);
                        try {
                            compiler.compile(configParser.getFiles());
                        }
                        catch (CompilerErrors ce) {
                            // empty catch block
                        }
                        if (compiler.getAjdeBuildErrorHandler().getErrorCount() > 0) {
                            succeeded = false;
                        }
                        if (compiler.getAjdeBuildErrorHandler().getWarningCount() > 0) {
                            warnings = true;
                        }
                        long timeEnd = System.currentTimeMillis();
                        AspectJBuildManager.this.lastCompileTime = (int)(timeEnd - timeStart);
                    }
                    catch (ConfigParser.ParseException pe) {
                        Ajde.getDefault().getErrorHandler().handleWarning("Config file entry invalid, file: " + pe.getFile().getPath() + ", line number: " + pe.getLine());
                        Object var11_14 = null;
                        AspectJBuildManager.this.progressMonitor.finish();
                        break block22;
                    }
                    catch (ConfigFileDoesNotExistException cfdne) {
                        Ajde.getDefault().getErrorHandler().handleWarning("Config file \"" + AspectJBuildManager.this.configFile + "\" does not exist.");
                        Object var11_15 = null;
                        AspectJBuildManager.this.progressMonitor.finish();
                        break block22;
                    }
                    catch (ExitRequestException ere) {
                        if (ere.getValue() == 0) {
                            AspectJBuildManager.this.notifyCompileAborted(AspectJBuildManager.this.configFile, "Build cancelled by user.");
                        } else {
                            Ajde.getDefault().getErrorHandler().handleWarning("Compile could not complete. See the console for more details. If no console is available re-launch the application from the command line.");
                        }
                        Object var11_16 = null;
                        AspectJBuildManager.this.progressMonitor.finish();
                        break block22;
                    }
                    catch (InternalCompilerError compilerError) {
                        if (compilerError.uncaughtThrowable instanceof OutOfMemoryError) {
                            Ajde.getDefault().getErrorHandler().handleError("Out of memory.  Increase memory by setting the -Xmx parameter that this VM was launched with.\nNote that some AJDE structure persists across compiles.", compilerError.uncaughtThrowable);
                        } else if (compilerError.uncaughtThrowable instanceof MissingRuntimeError) {
                            Ajde.getDefault().getErrorHandler().handleWarning("Compilation aborted because the AspectJ runtime was not found. Please place aspectjrt.jar in the lib/ext directory.");
                        } else if (compilerError.uncaughtThrowable instanceof BadRuntimeError) {
                            Ajde.getDefault().getErrorHandler().handleWarning("Compilation aborted because an out-of-date version of the AspectJ runtime was found.  Please place a current version of aspectjrt.jar in the lib/ext directory.");
                        } else {
                            Ajde.getDefault().getErrorHandler().handleError("Compile error.", compilerError.uncaughtThrowable);
                        }
                        Object var11_17 = null;
                        AspectJBuildManager.this.progressMonitor.finish();
                        break block22;
                    }
                    catch (Throwable e) {
                        Ajde.getDefault().getErrorHandler().handleError("Compile error, caught Throwable: " + e.toString(), e);
                        Object var11_18 = null;
                        AspectJBuildManager.this.progressMonitor.finish();
                    }
                    Object var11_13 = null;
                    AspectJBuildManager.this.progressMonitor.finish();
                }
                catch (Throwable throwable) {
                    Object var11_19 = null;
                    AspectJBuildManager.this.progressMonitor.finish();
                    throw throwable;
                }
            }
            AspectJBuildManager.this.notifyCompileFinished(AspectJBuildManager.this.configFile, AspectJBuildManager.this.lastCompileTime, succeeded, warnings);
        }

        private String getFormattedOptionsString(BuildOptionsAdapter buildOptions, ProjectPropertiesAdapter properties) {
            return "Building with settings: \n-> output path: " + properties.getOutputPath() + "\n-> classpath: " + properties.getClasspath() + "\n-> bootclasspath: " + properties.getBootClasspath() + "\n-> non-standard options: " + buildOptions.getNonStandardOptions() + "\n-> porting mode: " + buildOptions.getPortingMode() + "\n-> source 1.4 mode: " + buildOptions.getSourceOnePointFourMode() + "\n-> strict spec mode: " + buildOptions.getStrictSpecMode() + "\n-> lenient spec mode: " + buildOptions.getLenientSpecMode() + "\n-> use javac mode: " + buildOptions.getUseJavacMode() + "\n-> preprocess mode: " + buildOptions.getPreprocessMode() + "\n-> working dir: " + buildOptions.getWorkingOutputPath();
        }
    }
}

