/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.internal;

import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.ui.UserPreferencesAdapter;

public class AjcBuildOptions
implements BuildOptionsAdapter {
    private UserPreferencesAdapter preferencesAdapter = null;
    private static final String AJC = "ajc";
    private static final String USE_JAVAC_MODE = "ajc.useJavacMode";
    private static final String WORKING_DIR = "ajc.workingDir";
    private static final String PREPROCESS_MODE = "ajc.preprocessMode";
    private static final String CHARACTER_ENCODING = "ajc.characterEncoding";
    private static final String SOURCE_ONE_POINT_FOUR_MODE = "ajc.sourceOnePointFourMode";
    private static final String LENIENT_MODE = "ajc.lenientSpecMode";
    private static final String STRICT_MODE = "ajc.strictSpecMode";
    private static final String PORTING_MODE = "ajc.portingMode";
    private static final String VERBOSE_MODE = "ajc.verboseMode";
    private static final String NONSTANDARD_OPTIONS = "ajc.nonStandardOptions";

    public AjcBuildOptions(UserPreferencesAdapter userPreferencesAdapter) {
        this.preferencesAdapter = userPreferencesAdapter;
    }

    public boolean getUseJavacMode() {
        return this.getBooleanOptionVal(USE_JAVAC_MODE);
    }

    public void setUseJavacMode(boolean value) {
        this.setBooleanOptionVal(USE_JAVAC_MODE, value);
    }

    public String getWorkingOutputPath() {
        return this.preferencesAdapter.getProjectPreference(WORKING_DIR);
    }

    public void setWorkingDir(String path) {
        this.preferencesAdapter.setProjectPreference(WORKING_DIR, path);
    }

    public boolean getPreprocessMode() {
        return this.getBooleanOptionVal(PREPROCESS_MODE);
    }

    public void setPreprocessMode(boolean value) {
        this.setBooleanOptionVal(PREPROCESS_MODE, value);
    }

    public String getCharacterEncoding() {
        return this.preferencesAdapter.getProjectPreference(CHARACTER_ENCODING);
    }

    public void setCharacterEncoding(String value) {
        this.preferencesAdapter.setProjectPreference(CHARACTER_ENCODING, value);
    }

    public boolean getSourceOnePointFourMode() {
        return this.getBooleanOptionVal(SOURCE_ONE_POINT_FOUR_MODE);
    }

    public void setSourceOnePointFourMode(boolean value) {
        this.setBooleanOptionVal(SOURCE_ONE_POINT_FOUR_MODE, value);
    }

    public boolean getLenientSpecMode() {
        return this.getBooleanOptionVal(LENIENT_MODE);
    }

    public void setLenientSpecMode(boolean value) {
        this.setBooleanOptionVal(LENIENT_MODE, value);
    }

    public boolean getStrictSpecMode() {
        return this.getBooleanOptionVal(STRICT_MODE);
    }

    public void setStrictSpecMode(boolean value) {
        this.setBooleanOptionVal(STRICT_MODE, value);
    }

    public boolean getPortingMode() {
        return this.getBooleanOptionVal(PORTING_MODE);
    }

    public void setPortingMode(boolean value) {
        this.setBooleanOptionVal(PORTING_MODE, value);
    }

    public boolean getVerboseMode() {
        return this.getBooleanOptionVal(VERBOSE_MODE);
    }

    public void setVerboseMode(boolean value) {
        this.setBooleanOptionVal(VERBOSE_MODE, value);
    }

    public String getNonStandardOptions() {
        return this.preferencesAdapter.getProjectPreference(NONSTANDARD_OPTIONS);
    }

    public void setNonStandardOptions(String value) {
        this.preferencesAdapter.setProjectPreference(NONSTANDARD_OPTIONS, value);
    }

    private boolean getBooleanOptionVal(String name) {
        if (this.preferencesAdapter.getProjectPreference(name) != null) {
            return this.preferencesAdapter.getProjectPreference(name).equals("true");
        }
        return false;
    }

    private void setBooleanOptionVal(String name, boolean value) {
        if (value) {
            this.preferencesAdapter.setProjectPreference(name, "true");
        } else {
            this.preferencesAdapter.setProjectPreference(name, "false");
        }
    }
}

