/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.GlobalStructureView;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewNode;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.Relation;
import org.aspectj.asm.RelationNode;
import org.aspectj.asm.StructureBuilder;
import org.aspectj.asm.StructureModel;
import org.aspectj.asm.StructureNode;

public class TreeStructureViewBuilder
implements StructureBuilder {
    private StructureViewNodeFactory nodeFactory;
    private static final Comparator ALPHABETICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            StructureNode sv1 = ((StructureViewNode)o1).getStructureNode();
            StructureNode sv2 = ((StructureViewNode)o2).getStructureNode();
            if (sv1 instanceof ProgramElementNode && sv2 instanceof ProgramElementNode) {
                ProgramElementNode p1 = (ProgramElementNode)sv1;
                ProgramElementNode p2 = (ProgramElementNode)sv2;
                return p1.getName().compareTo(p2.getName());
            }
            return 0;
        }
    };
    private static final Comparator DECLARATIONAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            StructureNode sv1 = ((StructureViewNode)o1).getStructureNode();
            StructureNode sv2 = ((StructureViewNode)o2).getStructureNode();
            if (sv1 instanceof ProgramElementNode && sv2 instanceof ProgramElementNode) {
                ProgramElementNode p1 = (ProgramElementNode)sv1;
                ProgramElementNode p2 = (ProgramElementNode)sv2;
                if (p1.getSourceLocation() == null) {
                    return 0;
                }
                if (p1.getSourceLocation().getLineNumber() < p2.getSourceLocation().getLineNumber()) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    };

    public TreeStructureViewBuilder(StructureViewNodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public void buildView(StructureView view, StructureModel model) {
        StructureViewProperties.Hierarchy hierarchy;
        StructureViewProperties properties = view.getViewProperties();
        StructureNode modelRoot = null;
        boolean noStructure = false;
        if (this.isFileView(view)) {
            FileStructureView fileView = (FileStructureView)view;
            if (fileView.getSourceFile() == null) {
                modelRoot = StructureModel.NO_STRUCTURE;
                noStructure = true;
            } else {
                modelRoot = model.findRootNodeForSourceFile(fileView.getSourceFile());
            }
        } else {
            modelRoot = model.getRoot();
        }
        StructureViewNode viewRoot = null;
        if (!this.isFileView(view) && ((hierarchy = ((GlobalStructureView)view).getGlobalViewProperties().getHierarchy()).equals(StructureViewProperties.Hierarchy.CROSSCUTTING) || hierarchy.equals(StructureViewProperties.Hierarchy.INHERITANCE))) {
            viewRoot = this.buildCustomTree((GlobalStructureView)view, model);
        }
        if (viewRoot == null) {
            viewRoot = this.createViewNode(modelRoot, view.getViewProperties());
        }
        if (view.getViewProperties().getSorting() == StructureViewProperties.Sorting.ALPHABETICAL || !this.isFileView(view) && ((GlobalStructureView)view).getGlobalViewProperties().getHierarchy().equals(StructureViewProperties.Hierarchy.DECLARATION)) {
            this.sortView(viewRoot, ALPHABETICAL_COMPARATOR);
        } else {
            this.sortView(viewRoot, DECLARATIONAL_COMPARATOR);
        }
        this.addPackageNode(view, viewRoot);
        view.setRootNode(viewRoot);
    }

    private void addPackageNode(StructureView view, StructureViewNode viewRoot) {
        ProgramElementNode fileNode;
        if (this.isFileView(view) && (fileNode = (ProgramElementNode)viewRoot.getStructureNode()).getPackageName() != null) {
            ProgramElementNode packageNode = new ProgramElementNode(fileNode.getPackageName(), ProgramElementNode.Kind.PACKAGE, null);
            packageNode.setSourceLocation(fileNode.getSourceLocation());
            StructureViewNode packageViewNode = this.createViewNode(packageNode, view.getViewProperties());
            viewRoot.getChildren().add(0, packageViewNode);
        }
    }

    private StructureViewNode createViewNode(StructureNode node, StructureViewProperties properties) {
        ArrayList<StructureViewNode> children = new ArrayList<StructureViewNode>();
        if (node instanceof ProgramElementNode) {
            ProgramElementNode parent;
            ProgramElementNode pNode = (ProgramElementNode)node;
            if (pNode.getRelations() != null) {
                Iterator it = pNode.getRelations().iterator();
                while (it.hasNext()) {
                    StructureNode structureNode = (StructureNode)it.next();
                    if (!this.acceptNode(structureNode, properties)) continue;
                    children.add(this.createViewNode(structureNode, properties));
                }
            }
            if (pNode.isRunnable() && pNode.getParent() != null && ((parent = (ProgramElementNode)pNode.getParent()).getProgramElementKind().equals(ProgramElementNode.Kind.CLASS) || parent.getProgramElementKind().equals(ProgramElementNode.Kind.ASPECT))) {
                parent.setRunnable(true);
                pNode.setRunnable(false);
            }
        }
        if (node.getChildren() != null) {
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                StructureNode structureNode = (StructureNode)it.next();
                if (!this.acceptNode(structureNode, properties)) continue;
                children.add(this.createViewNode(structureNode, properties));
            }
        }
        StructureViewNode viewNode = this.nodeFactory.createNode(node, children);
        return viewNode;
    }

    private boolean isFileView(StructureView view) {
        return view instanceof FileStructureView && !(view instanceof GlobalStructureView);
    }

    private boolean acceptGranularity(ProgramElementNode.Kind kind, StructureViewProperties.Granularity granularity) {
        if (kind == ProgramElementNode.Kind.CODE) {
            return false;
        }
        if (granularity == StructureViewProperties.Granularity.MEMBER) {
            return true;
        }
        if (granularity == StructureViewProperties.Granularity.TYPE && (kind == ProgramElementNode.Kind.PROJECT || kind == ProgramElementNode.Kind.PACKAGE || kind.isSourceFileKind() || kind.isTypeKind())) {
            return true;
        }
        if (granularity == StructureViewProperties.Granularity.FILE && (kind == ProgramElementNode.Kind.PROJECT || kind == ProgramElementNode.Kind.PACKAGE || kind.isSourceFileKind())) {
            return true;
        }
        return granularity == StructureViewProperties.Granularity.PACKAGE && (kind == ProgramElementNode.Kind.PROJECT || kind == ProgramElementNode.Kind.PACKAGE);
    }

    private boolean acceptNode(StructureNode node, StructureViewProperties properties) {
        if (node instanceof ProgramElementNode) {
            ProgramElementNode pNode = (ProgramElementNode)node;
            if (!this.acceptGranularity(pNode.getProgramElementKind(), properties.getGranularity())) {
                return false;
            }
            if (pNode.isMemberKind()) {
                if (properties.getFilteredMemberAccessibility().contains(pNode.getAccessibility())) {
                    return false;
                }
                if (properties.getFilteredMemberKinds().contains(pNode.getProgramElementKind())) {
                    return false;
                }
                Iterator it = pNode.getModifiers().iterator();
                while (it.hasNext()) {
                    if (!properties.getFilteredMemberModifiers().contains(it.next())) continue;
                    return false;
                }
            }
        } else {
            if (node instanceof RelationNode) {
                Relation relation = ((RelationNode)node).getRelation();
                return properties.getRelations().contains(relation);
            }
            return true;
        }
        return true;
    }

    private void sortView(StructureViewNode node, Comparator comparator) {
        if (node == null || node.getChildren() == null) {
            return;
        }
        Collections.sort(node.getChildren(), comparator);
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            StructureViewNode nextNode = (StructureViewNode)it.next();
            if (nextNode == null) continue;
            this.sortView(nextNode, comparator);
        }
    }

    private StructureViewNode buildCustomTree(GlobalStructureView view, StructureModel model) {
        StructureNode rootNode = model.getRoot();
        StructureViewNode treeNode = this.nodeFactory.createNode(rootNode);
        ArrayList rootNodes = new ArrayList();
        this.getRoots(rootNode, rootNodes, view.getGlobalViewProperties().getHierarchy());
        Iterator it = rootNodes.iterator();
        while (it.hasNext()) {
            if (view.getGlobalViewProperties().getHierarchy().equals(StructureViewProperties.Hierarchy.CROSSCUTTING)) {
                treeNode.add(this.getCrosscuttingChildren((StructureNode)it.next()));
                continue;
            }
            if (!view.getGlobalViewProperties().getHierarchy().equals(StructureViewProperties.Hierarchy.INHERITANCE)) continue;
            treeNode.add(this.getInheritanceChildren((StructureNode)it.next(), view.getViewProperties().getRelations()));
        }
        return treeNode;
    }

    private void getRoots(StructureNode rootNode, List roots, StructureViewProperties.Hierarchy hierarchy) {
        if (rootNode.getChildren() != null) {
            Iterator it = rootNode.getChildren().iterator();
            while (it.hasNext()) {
                StructureNode node = (StructureNode)it.next();
                if (node instanceof ProgramElementNode && this.acceptNodeAsRoot((ProgramElementNode)node, hierarchy)) {
                    ProgramElementNode pNode = (ProgramElementNode)node;
                    List relations = pNode.getRelations();
                    String delimiter = "";
                    if (hierarchy.equals(StructureViewProperties.Hierarchy.CROSSCUTTING)) {
                        delimiter = "uses pointcut";
                    } else if (hierarchy.equals(StructureViewProperties.Hierarchy.INHERITANCE)) {
                        delimiter = "inherits";
                    }
                    if (relations != null && relations.toString().indexOf(delimiter) == -1) {
                        boolean found = false;
                        Iterator it2 = roots.iterator();
                        while (it2.hasNext()) {
                            if (!((ProgramElementNode)it2.next()).equals(pNode)) continue;
                            found = true;
                        }
                        if (!found) {
                            roots.add(pNode);
                        }
                    }
                }
                this.getRoots(node, roots, hierarchy);
            }
        }
    }

    public boolean acceptNodeAsRoot(ProgramElementNode node, StructureViewProperties.Hierarchy hierarchy) {
        if (hierarchy.equals(StructureViewProperties.Hierarchy.CROSSCUTTING)) {
            return node.getProgramElementKind().equals(ProgramElementNode.Kind.ADVICE) || node.getProgramElementKind().equals(ProgramElementNode.Kind.POINTCUT);
        }
        if (hierarchy.equals(StructureViewProperties.Hierarchy.INHERITANCE)) {
            return node.getProgramElementKind().equals(ProgramElementNode.Kind.CLASS);
        }
        return false;
    }

    private StructureViewNode getInheritanceChildren(StructureNode node, List associations) {
        StructureViewNode treeNode = this.nodeFactory.createNode(node);
        List relations = ((ProgramElementNode)node).getRelations();
        if (relations != null) {
            Iterator it = relations.iterator();
            while (it.hasNext()) {
                RelationNode relation = (RelationNode)it.next();
                if (!relation.getName().equals("is inherited by")) continue;
                Iterator it2 = relation.getChildren().iterator();
                while (it2.hasNext()) {
                    ProgramElementNode pNode = ((LinkNode)it2.next()).getProgramElementNode();
                    StructureViewNode newNode = this.getInheritanceChildren(pNode, associations);
                    StructureViewNode typeChildren = this.buildTree(newNode.getStructureNode(), associations);
                    int i = 0;
                    while (i < typeChildren.getChildren().size()) {
                        newNode.add((StructureViewNode)typeChildren.getChildren().get(i));
                        ++i;
                    }
                    treeNode.add(newNode);
                }
            }
        }
        return treeNode;
    }

    private StructureViewNode getCrosscuttingChildren(StructureNode node) {
        StructureViewNode treeNode = this.nodeFactory.createNode(node);
        List relations = ((ProgramElementNode)node).getRelations();
        if (relations != null) {
            Iterator it = relations.iterator();
            while (it.hasNext()) {
                RelationNode relation = (RelationNode)it.next();
                if (relation.getName().equals("pointcut used by")) {
                    Iterator it2 = relation.getChildren().iterator();
                    while (it2.hasNext()) {
                        ProgramElementNode pNode = ((LinkNode)it2.next()).getProgramElementNode();
                        StructureViewNode newNode = this.getCrosscuttingChildren(pNode);
                        Iterator it3 = pNode.getRelations().iterator();
                        while (it3.hasNext()) {
                            RelationNode relationNode = (RelationNode)it3.next();
                            if (relationNode.getName().indexOf("pointcut") != -1) continue;
                            newNode.add(this.getRelations(relationNode));
                        }
                        treeNode.add(newNode);
                    }
                    continue;
                }
                if (relations.toString().indexOf("uses pointcut") != -1) continue;
                Iterator it4 = relations.iterator();
                while (it4.hasNext()) {
                    RelationNode relationNode = (RelationNode)it4.next();
                    if (relationNode.getName().indexOf("pointcut") != -1) continue;
                    treeNode.add(this.getRelations(relationNode));
                }
            }
        }
        return treeNode;
    }

    private StructureViewNode buildTree(StructureNode node, List associations) {
        List relations;
        StructureViewNode treeNode = this.nodeFactory.createNode(node);
        if (node instanceof ProgramElementNode && (relations = ((ProgramElementNode)node).getRelations()) != null) {
            Iterator it = relations.iterator();
            while (it.hasNext()) {
                RelationNode relationNode = (RelationNode)it.next();
                if (!associations.contains(relationNode.getRelation().toString())) continue;
                treeNode.add(this.buildTree(relationNode, associations));
            }
        }
        if (node != null) {
            List children = null;
            children = node.getChildren();
            if (children != null) {
                ArrayList<StructureViewNode> childList = new ArrayList<StructureViewNode>();
                Iterator itt = children.iterator();
                while (itt.hasNext()) {
                    StructureNode child = (StructureNode)itt.next();
                    if (child instanceof ProgramElementNode) {
                        ProgramElementNode progNode = (ProgramElementNode)child;
                        if (progNode.isCode()) continue;
                        childList.add(this.buildTree(child, associations));
                        continue;
                    }
                    childList.add(this.buildTree(child, associations));
                }
                Iterator it = childList.iterator();
                while (it.hasNext()) {
                    treeNode.add((StructureViewNode)it.next());
                }
            }
        }
        return treeNode;
    }

    private StructureViewNode getRelations(RelationNode node) {
        StructureViewNode treeNode = this.nodeFactory.createNode(node);
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            treeNode.add(this.nodeFactory.createNode((StructureNode)it.next()));
        }
        return treeNode;
    }

    private void dumpView(StructureViewNode root, int level) {
        System.out.println(root.getStructureNode());
        Iterator it = root.getChildren().iterator();
        while (it.hasNext()) {
            this.dumpView((StructureViewNode)it.next(), level++);
        }
        int i = 0;
        while (i < level) {
            System.out.print(' ');
            ++i;
        }
    }
}

