/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.UserPreferencesAdapter;

public class UserPreferencesStore
implements UserPreferencesAdapter {
    public static final String FILE_NAME = "/.ajbrowser";
    private final String VALUE_SEP = ";";
    private Properties properties = new Properties();

    public UserPreferencesStore() {
        try {
            if (new File(this.getPropertiesFilePath()).exists()) {
                this.properties.load(new FileInputStream(this.getPropertiesFilePath()));
            }
        }
        catch (IOException ioe) {
            Ajde.getDefault().getErrorHandler().handleError("Could not read properties", ioe);
        }
    }

    public String getProjectPreference(String name) {
        return this.properties.getProperty(name);
    }

    public List getProjectMultivalPreference(String name) {
        ArrayList<String> values = new ArrayList<String>();
        String valuesString = this.properties.getProperty(name);
        if (valuesString != null && !valuesString.trim().equals("")) {
            StringTokenizer st = new StringTokenizer(valuesString, ";");
            while (st.hasMoreTokens()) {
                values.add(st.nextToken());
            }
        }
        return values;
    }

    public void setProjectPreference(String name, String value) {
        this.properties.setProperty(name, value);
        this.saveProperties();
    }

    public void setProjectMultivalPreference(String name, List values) {
        String valuesString = "";
        Iterator it = values.iterator();
        while (it.hasNext()) {
            valuesString = valuesString + (String)it.next() + ';';
        }
        this.properties.setProperty(name, valuesString);
        this.saveProperties();
    }

    public String getPropertiesFilePath() {
        String path = System.getProperty("user.home");
        if (path == null) {
            path = ".";
        }
        return path + FILE_NAME;
    }

    public String getGlobalPreference(String name) {
        return this.getProjectPreference(name);
    }

    public List getGlobalMultivalPreference(String name) {
        return this.getProjectMultivalPreference(name);
    }

    public void setGlobalPreference(String name, String value) {
        this.setProjectPreference(name, value);
    }

    public void setGlobalMultivalPreference(String name, List values) {
        this.setProjectMultivalPreference(name, values);
    }

    public void saveProperties() {
        try {
            this.properties.store(new FileOutputStream(this.getPropertiesFilePath()), "AJDE Settings");
        }
        catch (IOException ioe) {
            Ajde.getDefault().getErrorHandler().handleError("Could not write properties", ioe);
        }
    }
}

