/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.aspectj.ajde.ui.swing.AjdeUIManager;
import org.aspectj.ajde.ui.swing.StructureTree;
import org.aspectj.ajde.ui.swing.SwingTreeViewNode;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.StructureNode;

class BrowserViewTreeListener
implements TreeSelectionListener,
MouseListener {
    private StructureTree tree = null;

    public BrowserViewTreeListener(StructureTree tree) {
        this.tree = tree;
    }

    public void valueChanged(TreeSelectionEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.singleClickNavigation(e);
        this.maybeShowPopup(e);
    }

    public void singleClickNavigation(MouseEvent e) {
        StructureNode currNode;
        SwingTreeViewNode treeNode = (SwingTreeViewNode)this.tree.getLastSelectedPathComponent();
        if (treeNode == null || e.isControlDown() || e.isShiftDown() || e.getModifiers() == 4 || (currNode = (StructureNode)treeNode.getUserObject()) instanceof ProgramElementNode && !e.isControlDown() && !e.isShiftDown() && e.getModifiers() != 4 || currNode instanceof LinkNode) {
            // empty if block
        }
    }

    public void doubleClickNavigation(MouseEvent e) {
        StructureNode currNode;
        int clickCount = e.getClickCount();
        SwingTreeViewNode treeNode = (SwingTreeViewNode)this.tree.getLastSelectedPathComponent();
        if (treeNode == null || (currNode = (StructureNode)treeNode.getUserObject()) instanceof ProgramElementNode && !e.isControlDown() && !e.isShiftDown() && e.getModifiers() != 4 || !(currNode instanceof LinkNode) || clickCount == 1 || clickCount == 2) {
            // empty if block
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.getModifiers() == 4 && this.tree.getSelectionCount() > 0) {
            TreePath[] selectionPaths = this.tree.getSelectionPaths();
            final ArrayList<StructureNode> signatures = new ArrayList<StructureNode>();
            int i = 0;
            while (i < selectionPaths.length) {
                StructureNode currNode = (StructureNode)((SwingTreeViewNode)selectionPaths[i].getLastPathComponent()).getUserObject();
                if (currNode instanceof LinkNode || currNode instanceof ProgramElementNode) {
                    signatures.add(currNode);
                }
                ++i;
            }
            JPopupMenu popup = new JPopupMenu();
            JMenuItem showSourcesItem = new JMenuItem("Display sources", AjdeUIManager.getDefault().getIconRegistry().getStructureSwingIcon(ProgramElementNode.Kind.CODE));
            showSourcesItem.setFont(new Font("Dialog", 0, 11));
            showSourcesItem.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                }
            });
            popup.add(showSourcesItem);
            popup.addSeparator();
            JMenuItem generatePCD = new JMenuItem("Pointcut Wizard (alpha)...", AjdeUIManager.getDefault().getIconRegistry().getStructureSwingIcon(ProgramElementNode.Kind.POINTCUT));
            generatePCD.setFont(new Font("Dialog", 0, 11));
            generatePCD.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    AjdeUIManager.getDefault().getViewManager().extractAndInsertSignatures(signatures, true);
                }
            });
            popup.add(generatePCD);
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

