/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.aspectj.ajde.ui.swing.AjdeUIManager;
import org.aspectj.ajde.ui.swing.AjdeWidgetStyles;
import org.aspectj.ajde.ui.swing.StructureTree;
import org.aspectj.ajde.ui.swing.SwingTreeViewNode;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.RelationNode;
import org.aspectj.asm.StructureMessage;
import org.aspectj.asm.StructureNode;

class SwingTreeViewNodeRenderer
extends DefaultTreeCellRenderer {
    SwingTreeViewNodeRenderer() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public Component getTreeCellRendererComponent(JTree tree, Object treeNode, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (treeNode == null) {
            return null;
        }
        SwingTreeViewNode viewNode = (SwingTreeViewNode)treeNode;
        StructureNode node = viewNode.getStructureNode();
        if (node instanceof LinkNode) {
            if (((LinkNode)node).getProgramElementNode().getSourceLocation().getSourceFilePath() == null) {
                this.setTextNonSelectionColor(AjdeWidgetStyles.LINK_NODE_NO_SOURCE_COLOR);
            } else {
                this.setTextNonSelectionColor(AjdeWidgetStyles.LINK_NODE_COLOR);
            }
        } else {
            this.setTextNonSelectionColor(new Color(0, 0, 0));
        }
        super.getTreeCellRendererComponent(tree, treeNode, sel, expanded, leaf, row, hasFocus);
        this.setFont(StructureTree.DEFAULT_FONT);
        if (viewNode.getIcon() != null && viewNode.getIcon().getIconResource() != null) {
            this.setIcon((Icon)viewNode.getIcon().getIconResource());
        } else {
            this.setIcon(null);
        }
        if (node instanceof ProgramElementNode) {
            ProgramElementNode pNode = (ProgramElementNode)node;
            if (pNode.isRunnable()) {
                // empty if block
            }
            if (pNode.isImplementor()) {
                // empty if block
            }
            if (!pNode.isOverrider()) {
                // empty if block
            }
        } else if (node instanceof RelationNode) {
            this.setFont(new Font(((Component)this).getFont().getName(), 2, ((Component)this).getFont().getSize()));
        }
        if (node.getMessage() == null) return this;
        if (node.getMessage().getKind().equals(StructureMessage.Kind.WARNING)) {
            this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getWarningIcon());
            return this;
        }
        if (node.getMessage().getKind().equals(StructureMessage.Kind.ERROR)) {
            this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getErrorIcon());
            return this;
        }
        this.setIcon(AjdeUIManager.getDefault().getIconRegistry().getInfoIcon());
        return this;
    }
}

