/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import java.io.ObjectStreamException;
import java.io.Serializable;

public class StructureMessage
implements Serializable {
    private Kind kind;
    private String message;

    public StructureMessage(String message, Kind kind) {
        this.message = message;
        this.kind = kind;
    }

    public String getMessage() {
        return this.message;
    }

    public Kind getKind() {
        return this.kind;
    }

    public static class Kind
    implements Serializable {
        public static final Kind ERROR = new Kind("error");
        public static final Kind WARNING = new Kind("warning");
        public static final Kind INFO = new Kind("info");
        public static final Kind[] ALL = new Kind[]{ERROR, WARNING, INFO};
        private final String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private Kind(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() throws ObjectStreamException {
            return ALL[this.ordinal];
        }
    }
}

