/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.SourceLocation;
import org.aspectj.asm.StructureNode;

public class StructureModel
implements Serializable {
    protected StructureNode root = null;
    protected String configFile = null;
    private Map fileMap = null;
    public static final ProgramElementNode NO_STRUCTURE = new ProgramElementNode("<build to view structure>", ProgramElementNode.Kind.ERROR, null);

    public StructureNode getRoot() {
        return this.root;
    }

    public void setRoot(StructureNode root) {
        this.root = root;
    }

    public Map getFileMap() {
        return this.fileMap;
    }

    public void setFileMap(HashMap fileMap) {
        this.fileMap = fileMap;
    }

    public boolean isValid() {
        return this.root != null && this.fileMap != null;
    }

    public StructureNode findRootNodeForSourceFile(String sourceFilePath) {
        if (!this.isValid() || sourceFilePath == null) {
            return NO_STRUCTURE;
        }
        String correctedPath = sourceFilePath.replace('\\', '/');
        StructureNode node = (StructureNode)this.getFileMap().get(correctedPath);
        if (node != null) {
            return node;
        }
        return this.createFileStructureNode(sourceFilePath);
    }

    public StructureNode findNodeForSourceLine(String sourceFilePath, int lineNumber) {
        String correctedPath = sourceFilePath.replace('\\', '/');
        StructureNode node = this.findNodeForSourceLineHelper(this.root, correctedPath, lineNumber);
        if (node != null) {
            return node;
        }
        return this.createFileStructureNode(sourceFilePath);
    }

    private StructureNode createFileStructureNode(String sourceFilePath) {
        String fileName = new File(sourceFilePath).getName();
        ProgramElementNode fileNode = new ProgramElementNode(fileName, ProgramElementNode.Kind.FILE_JAVA, null);
        fileNode.setSourceLocation(new SourceLocation(sourceFilePath, 1, 1));
        fileNode.addChild(NO_STRUCTURE);
        return fileNode;
    }

    private StructureNode findNodeForSourceLineHelper(StructureNode node, String sourceFilePath, int lineNumber) {
        if (this.matches(node, sourceFilePath, lineNumber) && !this.hasMoreSpecificChild(node, sourceFilePath, lineNumber)) {
            return node;
        }
        if (node != null && node.getChildren() != null) {
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                StructureNode foundNode = this.findNodeForSourceLineHelper((StructureNode)it.next(), sourceFilePath, lineNumber);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    private boolean matches(StructureNode node, String sourceFilePath, int lineNumber) {
        return node != null && node.getSourceLocation() != null && node.getSourceLocation().getSourceFilePath().equals(sourceFilePath) && (node.getSourceLocation().getLineNumber() <= lineNumber && node.getSourceLocation().getEndLineNumber() >= lineNumber || lineNumber <= 1 && node instanceof ProgramElementNode && ((ProgramElementNode)node).getProgramElementKind().isSourceFileKind());
    }

    private boolean hasMoreSpecificChild(StructureNode node, String sourceFilePath, int lineNumber) {
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            ProgramElementNode child = (ProgramElementNode)it.next();
            if (!this.matches(child, sourceFilePath, lineNumber)) continue;
            return true;
        }
        return false;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

