/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.aspectj.asm.Association;
import org.aspectj.asm.ModelWalker;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.StructureModel;
import org.aspectj.asm.StructureModelListener;
import org.aspectj.asm.StructureNode;
import org.aspectj.asm.associations.Advice;
import org.aspectj.asm.associations.Inheritance;
import org.aspectj.asm.associations.Introduction;
import org.aspectj.asm.associations.Reference;
import org.aspectj.asm.internal.StructureNodeFactory;
import org.aspectj.compiler.base.AbstractCompilerPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.World;
import org.aspectj.compiler.crosscuts.AspectJCompiler;
import org.aspectj.compiler.crosscuts.Correspondences;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;

public class StructureModelManager {
    public static StructureModelManager INSTANCE = new StructureModelManager();
    private boolean shouldSaveModel = true;
    protected StructureModel model = new StructureModel();
    private List structureListeners = new ArrayList();
    private List associations = new ArrayList();
    public static Correspondences correspondences = null;

    protected StructureModelManager() {
        this.associations.add(new Advice());
        this.associations.add(new Introduction());
        this.associations.add(new Inheritance());
        this.associations.add(new Reference());
    }

    public StructureModel getStructureModel() {
        return this.model;
    }

    public StructureNode buildStructureModel(AspectJCompiler compiler) {
        try {
            try {
                StructureNodeFactory.clear();
                correspondences = compiler.getCorrespondences();
                World world = compiler.getWorld();
                String configFile = compiler.getBuildConfigFile();
                this.buildProgramStructurePass(world, configFile);
                this.buildRelationsPass(this.model.getRoot());
                this.notifyListeners();
                if (configFile != null && this.shouldSaveModel) {
                    this.writeStructureModel(configFile);
                }
                this.model.setConfigFile(configFile);
                this.clearAstObjectReferences(this.model);
            }
            catch (Throwable t) {
                System.err.println("AspectJ ASM Error: could not buld structure model.");
                t.printStackTrace();
                Object var5_6 = null;
                return this.model.getRoot();
            }
            Object var5_5 = null;
            return this.model.getRoot();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            return this.model.getRoot();
        }
    }

    public void fireModelUpdated() {
        this.notifyListeners();
        if (this.model.getConfigFile() != null) {
            this.writeStructureModel(this.model.getConfigFile());
        }
    }

    public HashMap getInlineAnnotations(String sourceFile, boolean showSubMember, boolean showMemberAndType) {
        if (!this.model.isValid()) {
            return null;
        }
        HashMap annotations = new HashMap();
        StructureNode node = this.model.findRootNodeForSourceFile(sourceFile);
        if (node == StructureModel.NO_STRUCTURE) {
            return null;
        }
        ProgramElementNode fileNode = (ProgramElementNode)node;
        ArrayList peNodes = new ArrayList();
        this.getAllStructureChildren(fileNode, peNodes, showSubMember, showMemberAndType);
        Iterator it = ((AbstractList)peNodes).iterator();
        while (it.hasNext()) {
            ProgramElementNode peNode = (ProgramElementNode)it.next();
            ArrayList<ProgramElementNode> entries = new ArrayList<ProgramElementNode>();
            entries.add(peNode);
            Integer hash = new Integer(peNode.getSourceLocation().getLineNumber());
            List existingEntry = (List)annotations.get(hash);
            if (existingEntry != null) {
                entries.addAll(existingEntry);
            }
            annotations.put(hash, entries);
        }
        return annotations;
    }

    private void getAllStructureChildren(ProgramElementNode node, List result, boolean showSubMember, boolean showMemberAndType) {
        List children = node.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            StructureNode next = (StructureNode)it.next();
            if (!(next instanceof ProgramElementNode)) continue;
            ProgramElementNode pNode = (ProgramElementNode)next;
            if (pNode != null && (pNode.isCode() && showSubMember || !pNode.isCode() && showMemberAndType) && pNode.getRelations() != null && pNode.getRelations().size() > 0) {
                result.add(next);
            }
            this.getAllStructureChildren((ProgramElementNode)next, result, showSubMember, showMemberAndType);
        }
    }

    public void addListener(StructureModelListener listener) {
        this.structureListeners.add(listener);
    }

    public void removeStructureListener(StructureModelListener listener) {
        this.structureListeners.remove(listener);
    }

    private void notifyListeners() {
        Iterator it = this.structureListeners.iterator();
        while (it.hasNext()) {
            ((StructureModelListener)it.next()).modelUpdated(this.model);
        }
    }

    public List getAssociations() {
        return this.associations;
    }

    private void buildProgramStructurePass(World world, String configFile) {
        if (world == null) {
            return;
        }
        String rootName = "<model root>";
        if (configFile != null) {
            rootName = new File(configFile).getName();
        }
        ArrayList<ProgramElementNode> files = new ArrayList<ProgramElementNode>();
        HashMap<String, ProgramElementNode> modelFileMap = new HashMap<String, ProgramElementNode>();
        Iterator it = world.getCompilationUnits().iterator();
        while (it.hasNext()) {
            CompilationUnit compilationUnit = (CompilationUnit)it.next();
            ProgramElementNode fileNode = this.makeProgramElementNode(compilationUnit, correspondences);
            files.add(fileNode);
            modelFileMap.put(compilationUnit.getSourceFileName().replace('\\', '/'), fileNode);
        }
        this.model.setFileMap(modelFileMap);
        this.model.setRoot(this.mapFilesIntoPackages(rootName));
    }

    private void clearAstObjectReferences(StructureModel model) {
        ModelWalker walker = new ModelWalker(){

            public void preProcess(StructureNode node) {
                if (node.getChildren() == null) {
                    return;
                }
                Iterator it = node.getChildren().iterator();
                while (it.hasNext()) {
                    StructureNode childNode = (StructureNode)it.next();
                    if (!(childNode instanceof ProgramElementNode)) continue;
                    ((ProgramElementNode)childNode).clearAstObject();
                }
            }
        };
        model.getRoot().walk(walker);
    }

    private StructureNode mapFilesIntoPackages(String rootName) {
        ProgramElementNode root = new ProgramElementNode(rootName, ProgramElementNode.Kind.PROJECT, null);
        ArrayList packages = new ArrayList();
        Set fileSet = this.model.getFileMap().entrySet();
        TreeSet<String> packageSet = new TreeSet<String>();
        Iterator it = fileSet.iterator();
        while (it.hasNext()) {
            ProgramElementNode peNode = (ProgramElementNode)it.next().getValue();
            if (peNode.getPackageName() == null) continue;
            packageSet.add(peNode.getPackageName());
        }
        Iterator it2 = packageSet.iterator();
        while (it2.hasNext()) {
            this.addPackageToRoot(root, (String)it2.next());
        }
        Iterator it3 = fileSet.iterator();
        while (it3.hasNext()) {
            this.addFileToPackage(root, (ProgramElementNode)it3.next().getValue());
        }
        return root;
    }

    private void addPackageToRoot(StructureNode node, String packageName) {
        List children = node.getChildren();
        int dotIndex = packageName.indexOf(46);
        if (dotIndex == -1) {
            if (!node.getChildren().contains(packageName)) {
                node.addChild(new ProgramElementNode(packageName, ProgramElementNode.Kind.PACKAGE, null));
            }
        } else {
            String pkgTop = packageName.substring(0, dotIndex);
            String pkgRest = packageName.substring(dotIndex + 1, packageName.length());
            boolean added = false;
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                StructureNode child = (StructureNode)it.next();
                if (!child.getName().equals(pkgTop)) continue;
                this.addPackageToRoot(child, pkgRest);
                added = true;
            }
            if (!added) {
                ProgramElementNode newChild = new ProgramElementNode(pkgTop, ProgramElementNode.Kind.PACKAGE, null);
                node.addChild(newChild);
                this.addPackageToRoot(newChild, pkgRest);
            }
        }
    }

    private void addFileToPackage(StructureNode root, ProgramElementNode fileNode) {
        if (fileNode.getPackageName() == null) {
            root.addChild(fileNode);
        } else {
            this.addFileToPackageHelper(root, fileNode, new StringTokenizer(fileNode.getPackageName(), "."));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addFileToPackageHelper(StructureNode root, ProgramElementNode fileNode, StringTokenizer pkgPath) {
        block3: {
            if (pkgPath != null) ** GOTO lbl14
            root.addChild(fileNode);
            break block3;
lbl-1000:
            // 1 sources

            {
                nextElement = (String)pkgPath.nextElement();
                it = root.getChildren().iterator();
                while (it.hasNext()) {
                    pkgNode = (StructureNode)it.next();
                    if (!pkgNode.getName().equals(nextElement)) continue;
                    if (!pkgPath.hasMoreElements()) {
                        pkgNode.addChild(fileNode);
                        continue;
                    }
                    this.addFileToPackageHelper(pkgNode, fileNode, pkgPath);
                }
lbl14:
                // 2 sources

                ** while (pkgPath.hasMoreElements())
            }
        }
    }

    private void buildRelationsPass(StructureNode node) {
        List children;
        if (node instanceof ProgramElementNode) {
            ProgramElementNode peNode = (ProgramElementNode)node;
            ArrayList relations = new ArrayList();
            Iterator it = this.associations.iterator();
            while (it.hasNext()) {
                Association association = (Association)it.next();
                if (peNode.getAstObject() == null) continue;
                relations.addAll(association.getRelationNodes(peNode.getAstObject()));
            }
            peNode.setRelations(relations);
        }
        if ((children = node.getChildren()) != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.buildRelationsPass((StructureNode)it.next());
            }
        }
    }

    private ProgramElementNode makeProgramElementNode(ASTObject astObject, Correspondences correspondences) {
        ArrayList<ProgramElementNode> children = new ArrayList<ProgramElementNode>();
        List childNodes = CompositionHierarchy.makeChildren(astObject, correspondences);
        Iterator it = childNodes.iterator();
        while (it.hasNext()) {
            children.add(this.makeProgramElementNode((ASTObject)it.next(), correspondences));
        }
        return StructureNodeFactory.makeNode(astObject, null, children);
    }

    public void writeStructureModel(String configFilePath) {
        try {
            String filePath = this.genExternFilePath(configFilePath);
            ObjectOutputStream s = new ObjectOutputStream(new FileOutputStream(filePath));
            s.writeObject(this.model);
            s.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readStructureModel(String configFilePath) {
        try {
            block5: {
                try {
                    if (configFilePath == null) {
                        this.model.setRoot(StructureModel.NO_STRUCTURE);
                        break block5;
                    }
                    String filePath = this.genExternFilePath(configFilePath);
                    FileInputStream in = new FileInputStream(filePath);
                    ObjectInputStream s = new ObjectInputStream(in);
                    this.model = (StructureModel)s.readObject();
                }
                catch (Exception e) {
                    this.model.setRoot(StructureModel.NO_STRUCTURE);
                    Object var6_7 = null;
                    this.notifyListeners();
                }
            }
            Object var6_6 = null;
            this.notifyListeners();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.notifyListeners();
            throw throwable;
        }
    }

    private String genExternFilePath(String configFilePath) {
        return configFilePath.substring(0, configFilePath.lastIndexOf(".lst")) + ".ajsym";
    }

    public void setShouldSaveModel(boolean shouldSaveModel) {
        this.shouldSaveModel = shouldSaveModel;
    }

    private static class CompositionHierarchy {
        private CompositionHierarchy() {
        }

        static List makeChildren(ASTObject astObject, Correspondences correspondeces) {
            ArrayList<ASTObject> children;
            block4: {
                Set affectsSet;
                block6: {
                    block5: {
                        block3: {
                            children = new ArrayList<ASTObject>();
                            if (!(astObject instanceof CompilationUnit)) break block3;
                            List definedTypes = ((CompilationUnit)astObject).getDefinedTypes();
                            Iterator it = definedTypes.iterator();
                            while (it.hasNext()) {
                                TypeDec typeDec = (TypeDec)it.next();
                                children.add(typeDec);
                            }
                            break block4;
                        }
                        if (!(astObject instanceof TypeDec)) break block5;
                        CompositionHierarchy.addCodeLevelChildren(astObject, correspondeces, children);
                        TypeDec typeDec = (TypeDec)astObject;
                        List decs = typeDec.getBody().getList();
                        Iterator it = decs.iterator();
                        while (it.hasNext()) {
                            Dec bodyDec = (Dec)it.next();
                            if (bodyDec == null || bodyDec instanceof InitializerDec || bodyDec.isSynthetic() || bodyDec.getBeginLine() == bodyDec.getDeclaringType().getCorrespondingDec().getBeginLine()) continue;
                            children.add(bodyDec);
                        }
                        break block4;
                    }
                    if (astObject instanceof FieldDec) break block4;
                    if (!(astObject instanceof MethodDec) && !(astObject instanceof ConstructorDec)) break block6;
                    CompositionHierarchy.addCodeLevelChildren(astObject, correspondeces, children);
                    break block4;
                }
                if (!(astObject instanceof AdviceDec) || (affectsSet = correspondeces.getAffects(astObject)) == null || affectsSet.size() <= 0) break block4;
                Iterator it = affectsSet.iterator();
                while (it.hasNext()) {
                    ASTObject stmtDec = (ASTObject)it.next();
                    if (!astObject.getSourceFileName().equals(stmtDec.getSourceFileName()) || astObject.getBeginLine() >= stmtDec.getBeginLine() || astObject.getEndLine() <= stmtDec.getEndLine()) continue;
                    children.add(stmtDec);
                }
            }
            return children;
        }

        private static void addCodeLevelChildren(ASTObject astObject, Correspondences correspondeces, List children) {
            Set affectsSet = correspondeces.getAffects(astObject);
            if (affectsSet != null && affectsSet.size() > 0) {
                Iterator it = affectsSet.iterator();
                while (it.hasNext()) {
                    ASTObject stmtDec = (ASTObject)it.next();
                    children.add(stmtDec);
                }
            }
        }
    }

    public static class UpdateStructurePass
    extends AbstractCompilerPass {
        private StructureModelManager structureManager = null;

        public UpdateStructurePass(JavaCompiler jc, StructureModelManager structureManager) {
            super(jc);
            this.structureManager = structureManager;
        }

        public String getDisplayName() {
            return "structure model update";
        }

        public void transformWorld() {
            this.structureManager.buildStructureModel((AspectJCompiler)super.getCompiler());
        }
    }
}

