/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import org.aspectj.compiler.base.CodeText;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.LineMap;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Comment;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;

public class CodeWriter
extends CompilerObject {
    private boolean writeComments = false;
    private LineMap lineMap = null;
    private CodeText out;
    private boolean onlySignatures = false;
    private boolean onlyPatch = false;
    private int lineStart = 0;
    private int lastGoodBreak = -1;
    private int lastPossibleBreak = -1;
    final int MAX_PAREN_DEPTH = 32;
    private int[] parenPositions = new int[33];
    private int parenDepth = 0;
    private int indents = 0;
    final String newLine = "\n";
    final int COMMENT_COLUMN = 67;
    final int MAX_COLUMNS = 100;
    private boolean needIndent = false;
    public static final String HEADER_START = "/*   Generated by AspectJ version ";

    public CodeWriter(JavaCompiler compiler) {
        this(compiler, 1024, null);
    }

    public CodeWriter(JavaCompiler compiler, int expectedSize, LineMap lineMap) {
        super(compiler);
        this.out = new CodeText(expectedSize);
        this.lineMap = lineMap;
        this.writeComments = !compiler.getOptions().nocomments;
    }

    public String getString() {
        return this.out.getString();
    }

    public void writeTo(OutputStream ostream) throws IOException {
        this.out.writeTo(ostream);
    }

    public boolean isOnlySignatures() {
        return this.onlySignatures;
    }

    public void setOnlySignatures(boolean v) {
        this.onlySignatures = v;
    }

    public boolean isOnlyPatch() {
        return this.onlyPatch;
    }

    public void setOnlyPatch(boolean v) {
        this.onlyPatch = v;
    }

    public void parenExpr(Expr expr) {
        this.openParen('(');
        this.write(expr);
        this.closeParen(')');
    }

    public void parenExprs(Exprs exprs) {
        this.openParen('(');
        this.write(exprs);
        this.closeParen(')');
    }

    public void writeChildren(ASTObject parent) {
        if (parent == null) {
            return;
        }
        int N = parent.getChildCount();
        if (N > 0) {
            this.write(parent.getChildAt(0));
        }
        int i = 1;
        while (i < N) {
            this.write(parent.getChildAt(i));
            ++i;
        }
    }

    public void writeChildrenWithCommas(ASTObject parent) {
        if (parent == null) {
            return;
        }
        int N = parent.getChildCount();
        if (N > 0) {
            this.write(parent.getChildAt(0));
        }
        int i = 1;
        while (i < N) {
            this.comma();
            this.write(parent.getChildAt(i));
            ++i;
        }
    }

    public void write(ASTObject node) {
        try {
            if (node == null) {
                return;
            }
            if (this.writeComments) {
                Comment comment = node.getComment();
                while (comment != null) {
                    comment.unparse(this);
                    comment = comment.getNextComment();
                }
            }
            if (this.lineMap != null) {
                this.lineMap.noteNode(node);
            }
            node.unparse(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getIndentSize() {
        return 2;
    }

    public void noteGoodBreak() {
        this.breakTooLongLine();
        this.lastGoodBreak = this.out.getIndex();
    }

    public void notePossibleBreak() {
        this.breakTooLongLine();
        this.lastPossibleBreak = this.out.getIndex();
    }

    public void breakTooLongLine() {
        int column = this.out.getIndex() - this.lineStart;
        if (column < 100) {
            return;
        }
        int breakPoint = -1;
        if (this.lastGoodBreak != -1) {
            breakPoint = this.lastGoodBreak;
        } else if (this.lastPossibleBreak != -1) {
            breakPoint = this.lastPossibleBreak;
        } else {
            return;
        }
        this.insertNewLine(breakPoint);
    }

    public void insertNewLine(int breakAtIndex) {
        byte[] saveData = this.out.backup(breakAtIndex);
        this.out.write("\n");
        this.lineStart = this.out.getIndex();
        this.lastGoodBreak = -1;
        this.lastPossibleBreak = -1;
        this.writeSpaces(this.indents + 4);
        this.out.write(saveData);
        this.lastPossibleBreak = this.out.getIndex();
    }

    public void comma() {
        this.write(',');
        this.optionalSpace();
        this.noteGoodBreak();
    }

    public void requiredSpace() {
        this.out.write(32);
        this.notePossibleBreak();
    }

    public void optionalSpace() {
        this.out.write(32);
        this.notePossibleBreak();
    }

    public void writeKeyword(String keyword) {
        this.write(keyword);
    }

    public void writeOp(String op) {
        this.optionalSpace();
        this.write(op);
        this.optionalSpace();
    }

    public void openParen(char paren) {
        this.write(paren);
        ++this.parenDepth;
        this.parenPositions[this.parenDepth > 32 ? 32 : this.parenDepth] = this.out.getIndex();
        this.notePossibleBreak();
    }

    public void closeParen(char paren) {
        this.write(paren);
        --this.parenDepth;
    }

    public void closeStmt() {
        this.write(';');
    }

    public int getIndents() {
        return this.indents;
    }

    public void setIndents(int indents) {
        this.indents = indents;
    }

    public void openBlock() {
        this.writeln("{");
        this.indent();
    }

    public void closeBlock() {
        this.dedent();
        this.write("} ");
    }

    public void indent() {
        this.indents += this.getIndentSize();
    }

    public void dedent() {
        this.indents -= this.getIndentSize();
    }

    public void writeLines(String text) {
        int newlinePos;
        if (text == null) {
            return;
        }
        int currentPos = 0;
        while ((newlinePos = text.indexOf(10, currentPos)) != -1) {
            this.writeln(text.substring(currentPos, newlinePos));
            currentPos = newlinePos + 1;
        }
        this.write(text.substring(currentPos));
    }

    public void write(String text) {
        this.doIndent();
        this.out.write(text);
    }

    public void write(char ch) {
        this.doIndent();
        this.out.write(ch);
    }

    public void writeln(String text) {
        this.write(text);
        this.newLine();
    }

    public void newLine() {
        this.breakTooLongLine();
        if (this.writeComments && this.lineMap != null && this.lineMap.hasCurrentSourceLine()) {
            int column = this.out.getIndex() - this.lineStart;
            if (column < 67) {
                this.writeSpaces(67 - column);
            } else {
                this.out.write(32);
            }
            this.out.write("//");
            this.out.write(new File(this.lineMap.getCurrentSourceFile()).getName());
            this.out.write(":" + this.lineMap.getCurrentSourceLine());
        }
        this.out.write("\n");
        if (this.lineMap != null) {
            this.lineMap.noteNewLine();
        }
        this.lineStart = this.out.getIndex();
        this.needIndent = true;
        this.lastGoodBreak = -1;
        this.lastPossibleBreak = -1;
    }

    void doIndent() {
        if (!this.needIndent) {
            return;
        }
        this.needIndent = false;
        this.writeSpaces(this.indents);
    }

    final void writeSpaces(int N) {
        int i = 0;
        while (i < N) {
            this.out.write(32);
            ++i;
        }
    }

    public static boolean isGeneratedSource(File file) {
        try {
            FileReader reader = new FileReader(file);
            int i = 0;
            while (i < HEADER_START.length()) {
                int ch = ((Reader)reader).read();
                if (ch != HEADER_START.charAt(i)) {
                    return false;
                }
                ++i;
            }
            ((Reader)reader).close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public void writeHeader() {
        this.writeln("/*   Generated by AspectJ version 1.0.6 */");
    }
}

