/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CatchClauses;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.NewInstanceExpr;
import org.aspectj.compiler.base.ast.ThrowStmt;
import org.aspectj.compiler.base.ast.TryCatchStmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.crosscuts.ast.ProceedExpr;

public class ExceptionFinder
extends Walker {
    boolean deFacto;
    Set exceptions = new HashSet();
    Set findingInMethods = new HashSet();

    public static Set getPossibleExceptions(ASTObject ast, boolean deFacto) {
        if (ast == null) {
            return new HashSet();
        }
        ExceptionFinder finder = new ExceptionFinder(ast.getCompiler());
        finder.deFacto = deFacto;
        finder.process(ast);
        return finder.exceptions;
    }

    private ExceptionFinder(JavaCompiler compiler) {
        super(compiler);
    }

    void addAll(Set set, TypeDs typeDs) {
        if (typeDs == null) {
            return;
        }
        int N = typeDs.size();
        int i = 0;
        while (i < N) {
            set.add(typeDs.get(i).getType());
            ++i;
        }
    }

    void removeSubtypes(Set types, Type baseType) {
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            Type checkType = (Type)iter.next();
            if (!checkType.isSubtypeOf(baseType)) continue;
            iter.remove();
        }
    }

    void removeCaughtExceptions(Set exceptions, CatchClauses catchClauses) {
        if (catchClauses == null) {
            return;
        }
        int N = catchClauses.size();
        int i = 0;
        while (i < N) {
            Type exceptionType = catchClauses.get(i).getFormal().getType();
            this.removeSubtypes(exceptions, exceptionType);
            ++i;
        }
    }

    public ASTObject process(ASTObject node) {
        if (node instanceof TryCatchStmt) {
            TryCatchStmt tryStmt = (TryCatchStmt)node;
            Set bodyExceptions = ExceptionFinder.getPossibleExceptions(tryStmt.getBody(), this.deFacto);
            this.removeCaughtExceptions(bodyExceptions, tryStmt.getCatches());
            this.exceptions.addAll(bodyExceptions);
            super.process(tryStmt.getCatches());
            return node;
        }
        if (node instanceof ThrowStmt) {
            ThrowStmt throwStmt = (ThrowStmt)node;
            this.exceptions.add(throwStmt.getExpr().getType());
        } else if (node instanceof CallExpr) {
            CallExpr callExpr = (CallExpr)node;
            if (callExpr.getId().equals("aspectOf")) {
                return super.process(node);
            }
            Method method = callExpr.getMethod();
            if (method == null) {
                return super.process(node);
            }
            this.addAll(this.exceptions, method.getThrows());
        } else if (node instanceof NewInstanceExpr) {
            NewInstanceExpr newExpr = (NewInstanceExpr)node;
            Constructor init = newExpr.getConstructor();
            this.addAll(this.exceptions, init.getThrows());
        } else if (node instanceof ProceedExpr) {
            this.exceptions.addAll(((ProceedExpr)node).getPossibleExceptions(this.deFacto));
        }
        if (node instanceof TypeDec) {
            return node;
        }
        return super.process(node);
    }
}

