/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ControlContext;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.TryStmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.VarDec;

public final class FlowCheckerPass
extends WalkerPass {
    private Type currentType = null;
    int i = 0;
    private Vars vars = Vars.noVars;
    private Set possbilyAssigned = Set.access$000();
    private ESet possibleExns = ESet.getEmpty();
    private boolean liveFlag = true;
    private ControlContext context = new ControlContext();
    java.util.Set errorVars = new HashSet();
    private Map breaks = new HashMap();
    private Map continues = new HashMap();
    private Map tries = new HashMap();
    private java.util.Set broken = new HashSet();
    private java.util.Set continued = new HashSet();
    private Map pendingTransfers = new HashMap();

    public FlowCheckerPass(JavaCompiler jc) {
        super(jc);
    }

    public FlowCheckerPass(JavaCompiler jc, TypeDec currentTypeDec) {
        super(jc);
        this.currentType = currentTypeDec.getType();
    }

    public FlowCheckerPass(JavaCompiler jc, Set da, TypeDec currentTypeDec) {
        super(jc);
        this.setVars(Vars.makeSets(da, Set.getNone()));
        this.currentType = currentTypeDec.getType();
    }

    public FlowCheckerPass(JavaCompiler jc, Vars v, TypeDec currentTypeDec) {
        super(jc);
        this.setVars(v);
        this.currentType = currentTypeDec.getType();
    }

    public boolean isCurrent(FieldDec fd) {
        return fd.getDeclaringType() == this.currentType;
    }

    public String getDisplayName() {
        return "analyzing control flow";
    }

    public ASTObject process(ASTObject object) {
        return this.process(object, true);
    }

    public ASTObject processBoolean(ASTObject object) {
        return this.process(object, false);
    }

    private ASTObject process(ASTObject object, boolean cleanUp) {
        if (object == null) {
            return object;
        }
        if (!this.isLive() && object instanceof Stmt && ((Stmt)object).mustBeLive()) {
            object.showError("unreachable statement");
        } else {
            object.walkFlow(this);
        }
        if (cleanUp) {
            this.setVars(this.getVars().getTrue().join(this.getVars().getFalse()));
        }
        return object;
    }

    private void printDebug(int i, ASTObject object, boolean in) {
        int j = 0;
        while (j < i) {
            System.err.print(" ");
            ++j;
        }
        System.err.println("[" + i + "] da/dua:" + this.vars + " pa:" + this.possbilyAssigned + " exns:" + this.getExns() + " " + (this.liveFlag ? "live" : "dead") + " " + (in ? " --> " : " <-- ") + object);
    }

    public Vars getVars() {
        return this.vars;
    }

    public void setVars(Vars v) {
        this.vars = v;
    }

    public void setVars(Vars v0, Vars v1) {
        this.vars = Vars.makePair(v0, v1);
    }

    public void addPossiblyAssigned(VarDec dec) {
        this.possbilyAssigned = this.possbilyAssigned.add(dec);
    }

    public Set popPossiblyAssigned() {
        Set pa = this.possbilyAssigned;
        this.possbilyAssigned = Set.empty;
        return pa;
    }

    public void mergePossiblyAssigned(Set pa) {
        this.possbilyAssigned = this.possbilyAssigned.union(pa);
    }

    public ESet popExns() {
        ESet e = this.possibleExns;
        this.possibleExns = ESet.getEmpty();
        return e;
    }

    public void setExns(ESet e) {
        this.possibleExns = e;
    }

    public ESet getExns() {
        return this.possibleExns;
    }

    public TypeDs getCheckedExns() {
        AST ast = this.getAST();
        TypeDs ds = ast.makeTypeDs();
        Iterator i = this.possibleExns.iterator();
        while (i.hasNext()) {
            NameType ty = (NameType)i.next();
            if (ty.isSubtypeOf(this.getTypeManager().getRuntimeExceptionType()) || ty.isSubtypeOf(this.getTypeManager().getErrorType())) continue;
            ds.add(ty.makeTypeD());
        }
        return ds;
    }

    public void setLive(boolean b) {
        this.liveFlag = b;
    }

    public boolean isLive() {
        return this.liveFlag;
    }

    public static Vars getAllVars() {
        return Vars.allVars;
    }

    public static Vars getNoVars() {
        return Vars.noVars;
    }

    public void showVarError(ASTObject o, VarDec v, String msg) {
        if (!this.errorVars.contains(v)) {
            o.showError(msg);
            this.errorVars.add(v);
        }
    }

    public ControlContext popControlContext() {
        ControlContext c = this.context;
        this.context = new ControlContext();
        return c;
    }

    public void enterContext(Stmt s) {
        this.context.enter(s);
    }

    public void leaveContext() {
        this.context.exit();
    }

    public boolean isLabelUsed(String name) {
        return this.context.isLabelUsed(name);
    }

    public void doBreak(String label) {
        Stmt target = this.context.getBreakTarget(label);
        Vars v = this.getVars();
        this.annotateWindsUntil(target, v);
        this.annotate(this.breaks, target, v);
        this.addPendingTransfer(true, target);
    }

    public void doContinue(String label) {
        Stmt target = this.context.getContinueTarget(label);
        Vars v = this.getVars();
        this.annotateWindsUntil(target, v);
        this.annotate(this.continues, target, v);
        this.addPendingTransfer(false, target);
    }

    public void doReturn() {
        Vars v = this.getVars();
        this.annotateWindsUntil(null, v);
    }

    private void annotateWindsUntil(Stmt target, Vars v) {
        Iterator i = this.context.getWindsUntil(target);
        while (i.hasNext()) {
            Object o = i.next();
            this.annotate(this.tries, o, v);
        }
    }

    private void annotate(Map m, Object s, Vars v) {
        Vars tab = (Vars)m.get(s);
        if (tab == null) {
            m.put(s, v);
        } else {
            m.put(s, tab.join(v));
        }
    }

    public Vars getBreakVars(Stmt s) {
        return this.getVars(this.breaks, s);
    }

    public Vars getContinueVars(Stmt s) {
        return this.getVars(this.continues, s);
    }

    public Vars getTryVars(Stmt s) {
        return this.getVars(this.tries, s);
    }

    private Vars getVars(Map m, Stmt s) {
        Vars tab = (Vars)m.get(s);
        if (tab == null) {
            return FlowCheckerPass.getAllVars();
        }
        return tab;
    }

    public void checkLoopingFinals(Stmt stmt, Set pa, Vars v) {
        Set s = pa.diff(v.getDua());
        while (!s.isEmpty()) {
            VarDec dec = s.first();
            s = s.rest();
            this.showVarError(stmt, dec, "variable " + dec.getId() + " might be assigned in loop");
        }
    }

    public static Vars buildCatchVars(Vars daHolder, Vars duaHolder) {
        return Vars.makeSets(daHolder.getDa(), duaHolder.getDua());
    }

    public boolean isBroken(Stmt s) {
        return this.broken.contains(s);
    }

    public boolean isContinued(Stmt s) {
        return this.continued.contains(s);
    }

    public void releasePendingTransfers(TryStmt s) {
        if (this.getOptions().strict) {
            Redo l = (Redo)this.pendingTransfers.get(s);
            if (l == null) {
                return;
            }
            l.redo();
        }
    }

    private void addPendingTransfer(boolean isBreak, Stmt target) {
        if (!this.getOptions().strict) {
            (isBreak ? this.broken : this.continued).add(target);
        } else {
            Iterator i = this.context.getWindsUntil(target);
            if (i.hasNext()) {
                this.pendingTransfers.put(i.next(), new Redo(isBreak, target));
            } else {
                (isBreak ? this.broken : this.continued).add(target);
            }
        }
    }

    public static abstract class ESet {
        static ESet empty = new Null();

        public static ESet getEmpty() {
            return empty;
        }

        abstract ESet remove(NameType var1);

        public abstract boolean containsSuperOrSub(NameType var1);

        public abstract boolean containsSuper(NameType var1);

        public abstract ESet union(ESet var1);

        public abstract ESet diff(ESet var1);

        public Iterator iterator() {
            return new Iterator(this){
                private ESet e;
                private final /* synthetic */ ESet this$0;
                {
                    this.e = this.this$0 = this$0;
                }

                public boolean hasNext() {
                    return !(this.e instanceof Null);
                }

                public Object next() {
                    One o = (One)this.e;
                    this.e = o.rest;
                    return o.v;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public String toStringRest() {
            throw new RuntimeException("can't get rest of set");
        }

        public ESet add(NameType v) {
            return v.isUncheckedThrowable() ? this : this.add1(v);
        }

        abstract ESet add1(NameType var1);

        private static class One
        extends ESet {
            NameType v;
            ESet rest;

            One(NameType v, ESet rest) {
                this.v = v;
                this.rest = rest;
            }

            ESet add1(NameType v) {
                return this.containsSuper(v) ? this : new One(v, this);
            }

            ESet remove(NameType v) {
                return v == this.v ? this.rest : this.rest.remove(v).add(this.v);
            }

            public boolean containsSuperOrSub(NameType v) {
                return v.isSubtypeOf(this.v) || this.v.isSubtypeOf(v) || this.rest.containsSuperOrSub(v);
            }

            public boolean containsSuper(NameType v) {
                return v.isSubtypeOf(this.v) || this.rest.containsSuper(v);
            }

            public ESet union(ESet s) {
                return s.containsSuper(this.v) ? this.rest.union(s) : this.rest.union(s).add(this.v);
            }

            public ESet diff(ESet s) {
                return s.containsSuper(this.v) ? this.rest.diff(s) : this.rest.diff(s).add(this.v);
            }

            public String toString() {
                return "{" + this.v.getId() + this.rest.toStringRest();
            }

            public String toStringRest() {
                return ", " + this.v.getId() + this.rest.toStringRest();
            }
        }

        private static class Null
        extends ESet {
            private Null() {
            }

            ESet add1(NameType v) {
                return new One(v, this);
            }

            ESet remove(NameType v) {
                return this;
            }

            public boolean containsSuperOrSub(NameType v) {
                return false;
            }

            public boolean containsSuper(NameType v) {
                return false;
            }

            public ESet union(ESet s) {
                return s;
            }

            public ESet diff(ESet s) {
                return this;
            }

            public boolean isEmpty() {
                return true;
            }

            public String toStringRest() {
                return "}";
            }

            public String toString() {
                return "{}";
            }
        }
    }

    public static abstract class Set {
        private static Zero empty = new Zero();
        private static Neg full = new Neg(empty);

        public static Set getAll() {
            return full;
        }

        public static Set getNone() {
            return empty;
        }

        public abstract Set neg();

        public abstract Set add(VarDec var1);

        public abstract Set remove(VarDec var1);

        public abstract boolean contains(VarDec var1);

        public abstract Set union(Set var1);

        public abstract Set inter(Set var1);

        public abstract Set diff(Set var1);

        public abstract boolean isEmpty();

        public VarDec first() {
            throw new RuntimeException("can't take first");
        }

        public NonNeg rest() {
            throw new RuntimeException("can't take first");
        }

        public String toStringRest() {
            throw new RuntimeException("can't get rest of set");
        }

        private static class One
        extends NonNeg {
            VarDec v;
            NonNeg rest;

            One(VarDec v, NonNeg rest) {
                this.v = v;
                this.rest = rest;
            }

            public Set neg() {
                return new Neg(this);
            }

            public Set add(VarDec v) {
                return this.contains(v) ? this : new One(v, this);
            }

            public Set remove(VarDec v) {
                return v == this.v ? this.rest : this.rest.remove(v).add(this.v);
            }

            public boolean contains(VarDec v) {
                return v == this.v || this.rest.contains(v);
            }

            public Set union(Set s) {
                return s instanceof Neg ? s.union(this) : this.union1(s);
            }

            public Set inter(Set s) {
                return s instanceof Neg ? s.inter(this) : this.inter1(s);
            }

            public Set diff(Set s) {
                return s instanceof Neg ? this.inter(s.neg()) : this.diff1(s);
            }

            public boolean isEmpty() {
                return false;
            }

            public VarDec first() {
                return this.v;
            }

            public NonNeg rest() {
                return this.rest;
            }

            protected Set union1(Set s) {
                return s.contains(this.v) ? this.rest.union1(s) : this.rest.union1(s).add(this.v);
            }

            protected Set inter1(Set s) {
                return s.contains(this.v) ? this.rest.inter1(s).add(this.v) : this.rest.inter1(s);
            }

            protected Set diff1(Set s) {
                return s.contains(this.v) ? this.rest.diff1(s) : this.rest.diff1(s).add(this.v);
            }

            public String toString() {
                return "{" + this.v.getId() + this.rest.toStringRest();
            }

            public String toStringRest() {
                return ", " + this.v.getId() + this.rest.toStringRest();
            }
        }

        private static class Neg
        extends Set {
            private NonNeg x;

            Neg(NonNeg x) {
                this.x = x;
            }

            public Set neg() {
                return this.x;
            }

            public Set add(VarDec v) {
                return this.x.remove(v).neg();
            }

            public Set remove(VarDec v) {
                return this.x.add(v).neg();
            }

            public boolean contains(VarDec v) {
                return !this.x.contains(v);
            }

            public Set union(Set s) {
                if (s instanceof Neg) {
                    return this.x.inter(s.neg()).neg();
                }
                return this.x.diff(s).neg();
            }

            public Set inter(Set s) {
                if (s instanceof Neg) {
                    return this.x.union(s.neg()).neg();
                }
                return s.diff(this.x);
            }

            public Set diff(Set s) {
                if (s instanceof Neg) {
                    return s.neg().diff(this.x);
                }
                return this.x.union(s).neg();
            }

            public boolean isEmpty() {
                return false;
            }

            public String toString() {
                return "!" + this.x;
            }
        }

        private static class Zero
        extends NonNeg {
            private Zero() {
            }

            public Set neg() {
                return full;
            }

            public Set add(VarDec v) {
                return new One(v, this);
            }

            public Set remove(VarDec v) {
                return this;
            }

            public boolean contains(VarDec v) {
                return false;
            }

            public Set union(Set s) {
                return s;
            }

            public Set inter(Set s) {
                return this;
            }

            public Set diff(Set s) {
                return this;
            }

            protected Set union1(Set s) {
                return s;
            }

            protected Set inter1(Set s) {
                return this;
            }

            protected Set diff1(Set s) {
                return this;
            }

            public boolean isEmpty() {
                return true;
            }

            public String toStringRest() {
                return "}";
            }

            public String toString() {
                return "{}";
            }
        }

        public static abstract class NonNeg
        extends Set {
            protected abstract Set union1(Set var1);

            protected abstract Set inter1(Set var1);

            protected abstract Set diff1(Set var1);
        }
    }

    public static abstract class Vars {
        public static Vars allVars = new Sets(Set.access$500(), Set.access$500());
        public static Vars noVars = new Sets(Set.access$000(), Set.access$000());

        public static Vars getEmpty() {
            return noVars;
        }

        public abstract Vars getTrue();

        public abstract Vars getFalse();

        public abstract Set getDa();

        public abstract Set getDua();

        public abstract Vars join(Vars var1);

        public abstract Vars joinUnion(Vars var1);

        public abstract Vars addAssigned(VarDec var1);

        public abstract Vars addUnassigned(VarDec var1);

        public abstract boolean isDefinitelyAssigned(VarDec var1);

        public abstract boolean isDefinitelyUnassigned(VarDec var1);

        public static Vars makePair(Vars v0, Vars v1) {
            return new Pair(v0, v1);
        }

        public static Vars makeSets(Set v0, Set v1) {
            return new Sets(v0, v1);
        }

        private static final class Sets
        extends Vars {
            final Set da;
            final Set dua;

            Sets(Set da, Set dua) {
                this.da = da;
                this.dua = dua;
            }

            public Vars getTrue() {
                return this;
            }

            public Vars getFalse() {
                return this;
            }

            public Set getDa() {
                return this.da;
            }

            public Set getDua() {
                return this.dua;
            }

            public Vars join(Vars other) {
                return new Sets(this.da.inter(other.getDa()), this.dua.inter(other.getDua()));
            }

            public Vars joinUnion(Vars other) {
                return new Sets(this.da.union(other.getDa()), this.dua.union(other.getDua()));
            }

            public Vars addAssigned(VarDec v) {
                return new Sets(this.da.add(v), this.dua.remove(v));
            }

            public Vars addUnassigned(VarDec v) {
                return new Sets(this.da, this.dua.add(v));
            }

            public boolean isDefinitelyAssigned(VarDec dec) {
                return this.da.contains(dec);
            }

            public boolean isDefinitelyUnassigned(VarDec dec) {
                return this.dua.contains(dec);
            }

            public String toString() {
                return "<" + this.da + ", " + this.dua + ">";
            }
        }

        private static final class Pair
        extends Vars {
            final Vars ifTrue;
            final Vars ifFalse;
            private Vars normalForm = null;

            Pair(Vars ifTrue, Vars ifFalse) {
                this.ifTrue = ifTrue;
                this.ifFalse = ifFalse;
            }

            public Vars getTrue() {
                return this.ifTrue;
            }

            public Vars getFalse() {
                return this.ifFalse;
            }

            public Set getDa() {
                return this.normalize().getDa();
            }

            public Set getDua() {
                return this.normalize().getDua();
            }

            public Vars join(Vars other) {
                return this.normalize().join(other);
            }

            public Vars joinUnion(Vars other) {
                return this.normalize().joinUnion(other);
            }

            public Vars addAssigned(VarDec v) {
                return this.normalize().addAssigned(v);
            }

            public Vars addUnassigned(VarDec v) {
                return this.normalize().addUnassigned(v);
            }

            public boolean isDefinitelyAssigned(VarDec dec) {
                return this.normalize().isDefinitelyAssigned(dec);
            }

            public boolean isDefinitelyUnassigned(VarDec dec) {
                return this.normalize().isDefinitelyUnassigned(dec);
            }

            private Vars normalize() {
                if (this.normalForm == null) {
                    this.normalForm = this.ifTrue.join(this.ifFalse);
                }
                return this.normalForm;
            }

            public String toString() {
                return "<" + this.ifTrue + ", " + this.ifFalse + ">";
            }
        }
    }

    private class Redo {
        boolean isBreak;
        Stmt target;

        Redo(boolean isBreak, Stmt target) {
            this.isBreak = isBreak;
            this.target = target;
        }

        void redo() {
            Iterator i = FlowCheckerPass.this.context.getWindsUntil(this.target);
            if (i.hasNext()) {
                FlowCheckerPass.this.pendingTransfers.put(i.next(), this);
            } else {
                (this.isBreak ? FlowCheckerPass.this.broken : FlowCheckerPass.this.continued).add(this.target);
            }
        }
    }
}

