/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.ASTObject;

public final class FrameLocPass
extends WalkerPass {
    public boolean inTryFinally = false;
    private int maxfs = 0;
    private int fs = 0;

    public FrameLocPass(JavaCompiler jc) {
        super(jc);
    }

    public String getDisplayName() {
        return "assigning frame locs";
    }

    public int getmaxfs() {
        return this.maxfs;
    }

    public int getfs() {
        return this.fs;
    }

    public void setfs(int fs) {
        if (!this.inTryFinally) {
            this.fs = fs;
        }
        this.frameInvariant();
    }

    public void incfs(int delta) {
        this.fs += delta;
        this.frameInvariant();
    }

    public int allocate(int size) {
        int ret = this.fs;
        this.incfs(size);
        return ret;
    }

    private void frameInvariant() {
        if (this.fs > this.maxfs) {
            this.maxfs = this.fs;
        }
    }

    public ASTObject process(ASTObject object) {
        object.walkFrameLoc(this);
        return object;
    }
}

