/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;

public final class InnerInfoPass
extends WalkerPass {
    private static final int CU = 0;
    private static final int MEMBER = 1;
    private static final int STATICMEMBER = 2;
    private static final int DYNAMIC = 3;
    private static final int STATIC = 4;
    private static final int NIGH_STATIC = 5;
    private int context = 0;
    private List types = new ArrayList();

    public InnerInfoPass(JavaCompiler jc) {
        super(jc);
    }

    public String getDisplayName() {
        return "setting inner info";
    }

    public ASTObject process(ASTObject object) {
        object.walkInnerInfo(this);
        object.postInnerInfo(this);
        return object;
    }

    public int inCCall() {
        return this.setContext(5);
    }

    public int inType(boolean isInterface) {
        return this.setContext(isInterface ? 2 : 1);
    }

    public int inMember(boolean isStatic) {
        return this.setContext(isStatic ? 4 : 3);
    }

    private int setContext(int c) {
        int context = this.context;
        this.context = c;
        return context;
    }

    public void restoreContext(int context) {
        this.context = context;
    }

    public boolean isStatic() {
        return this.context != 3;
    }

    public boolean hasNonStaticAccess(ASTObject node, Type type) {
        return this.isAccessible(type);
    }

    public void checkStaticAccess(ASTObject node, SemanticObject so) {
        if (so.isStatic()) {
            return;
        }
        if (!this.hasNonStaticAccess(node, so.getDeclaringType())) {
            node.showError("non-static " + so.getKind() + " " + so.getName() + " cannot be referenced from a static context");
        }
    }

    public static boolean isInner(Type t) {
        if (!(t instanceof NameType)) {
            return false;
        }
        NameType nt = (NameType)t;
        return nt.isInner() || nt.getTypeDec().fromSource() && !nt.isAspect() && !nt.isPackageMember() && !nt.isLocal() && !nt.getTypeDec().isStatic() && !nt.getDeclaringType().isInterface();
    }

    public boolean isInDynamicContext() {
        return this.context == 1 || this.context == 3;
    }

    public void enterType(TypeDec dec) {
        this.types.add(dec.getType());
    }

    public void leaveType() {
        this.types.remove(this.types.size() - 1);
    }

    public NameType currentType() {
        return (NameType)this.types.get(this.types.size() - 1);
    }

    public NameType enclosingType() {
        return (NameType)this.types.get(this.types.size() - 2);
    }

    public boolean isAccessibleExactly(Type t) {
        return this.isAccessible(t, false);
    }

    public boolean isAccessible(Type t) {
        return this.isAccessible(t, true);
    }

    public boolean isAccessible(Type t, boolean allowSubs) {
        NameType current = (NameType)this.types.get(this.types.size() - 1);
        if (current == t || allowSubs && current.isSubtypeOf(t)) {
            return this.context == 3;
        }
        if (!current.isInner()) {
            return false;
        }
        int i = this.types.size() - 2;
        while (i >= 0) {
            current = (NameType)this.types.get(i);
            if (current == t || allowSubs && current.isSubtypeOf(t)) {
                return this.context != 4;
            }
            if (!current.isInner()) {
                return false;
            }
            --i;
        }
        return false;
    }
}

