/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.ExitRequestException;
import org.aspectj.compiler.base.JavaCompiler;

public class JavaCWrapper
extends CompilerObject {
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;

    public JavaCWrapper(JavaCompiler compiler) {
        super(compiler);
    }

    private String addClassPath(File pathdir) {
        String classpath = this.getOptions().classpath;
        if (classpath != null) {
            return pathdir.getPath() + File.pathSeparator + classpath;
        }
        classpath = System.getProperty("java.class.path");
        if (classpath != null) {
            return pathdir.getPath() + File.pathSeparator + classpath;
        }
        return pathdir.getPath();
    }

    public boolean compile(File inputdir, File outputdir, File[] files) {
        ArrayList<String> args = new ArrayList<String>(files.length + 6);
        args.add("-d");
        args.add(inputdir.getPath());
        args.add("-classpath");
        args.add(this.addClassPath(outputdir));
        if (this.getOptions().deprecation) {
            args.add("-deprecation");
        }
        if (this.getOptions().O) {
            args.add("-O");
        }
        if (this.getOptions().g) {
            args.add("-g");
        }
        if (this.getOptions().source.equals("1.4")) {
            args.add("-source");
            args.add("1.4");
        }
        if (this.getOptions().target != null) {
            args.add("-target");
            args.add(this.getOptions().target);
        }
        if (this.getOptions().bootclasspath != null) {
            args.add("-bootclasspath");
            args.add(this.getOptions().bootclasspath);
        }
        if (this.getOptions().extdirs != null) {
            args.add("-extdirs");
            args.add(this.getOptions().extdirs);
        }
        int i = 0;
        while (i < files.length) {
            args.add(files[i].getPath());
            ++i;
        }
        String[] argsArray = args.toArray(new String[0]);
        try {
            Class<?> compilerClass = Class.forName("com.sun.tools.javac.Main");
            return this.doModernCompile(compilerClass, argsArray);
        }
        catch (ClassNotFoundException ce1) {
            try {
                Class<?> compilerClass = Class.forName("sun.tools.javac.Main");
                return this.doClassicCompile(compilerClass, argsArray);
            }
            catch (ClassNotFoundException ce2) {
                this.showNoJavacError();
                return false;
            }
        }
    }

    void showNoJavacError() {
        System.err.println("The -usejavac flag requires that com.sun.tools.javac.Main");
        System.err.println("is on your classpath.  Generally, this will involve editing");
        System.err.println("your launch script (ajc.bat or ajc) to include tools.jar");
        System.err.println("on the classpath that is passed to the jvm which runs ajc.");
        System.err.println("See README-TOOLS.html for suggestions on how to fix this.");
        throw new ExitRequestException(-1);
    }

    boolean doModernCompile(Class compiler, String[] args) {
        this.getCompiler().showMessage("  modern compile");
        try {
            Method m = compiler.getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = JavaCWrapper.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            Object inst = compiler.newInstance();
            Integer i = (Integer)m.invoke(inst, new Object[]{args});
            return i == 0;
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    boolean doClassicCompile(Class compiler, String[] args) {
        this.getCompiler().showMessage("  classic compile");
        try {
            Constructor c = compiler.getConstructor(class$java$io$OutputStream == null ? (class$java$io$OutputStream = JavaCWrapper.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = JavaCWrapper.class$("java.lang.String")) : class$java$lang$String);
            Object inst = c.newInstance(System.err, "ajc");
            Method m = compiler.getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = JavaCWrapper.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            Boolean b = (Boolean)m.invoke(inst, new Object[]{args});
            return b;
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

