/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.aspectj.compiler.base.CompilerErrors;
import org.aspectj.compiler.base.CompilerPass;
import org.aspectj.compiler.base.ErrorHandler;
import org.aspectj.compiler.base.ExitRequestException;
import org.aspectj.compiler.base.InternalCompilerError;
import org.aspectj.compiler.base.Options;
import org.aspectj.compiler.base.TypeManager;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.World;
import org.aspectj.compiler.base.parser.JavaParser;

public class JavaCompiler {
    private Options options = new Options();
    private TypeManager typeManager;
    protected World world;
    protected ErrorHandler errorHandler;
    protected Class scanner;
    protected List passes;
    private Stack parsers = new Stack();
    protected List filesToCompile;
    private static final String noRuntimeWarning = "Can't find org.aspectj.lang.JoinPoint on your classpath anywhere.\nYou need to include aspectjrt.jar on your classpath when compiling or\nrunning applications with ajc.  See README-TOOLS.html in the top directory of\nthe distribution for more details on how to configure this correctly.";
    private static final String oldRuntimeWarning = "You appear to have an out-of-date version of aspectjrt.jar on your classpath.\nYou need to include the latest verion of aspectjrt.jar on your classpath when\ncompiling or running applications with ajc.  See README-TOOLS.html in the top\ndirectory of the distribution for more details on how to configure this\ncorrectly.";
    private static final String noObjectWarning = "Serious configuration problem: can't find java.lang.Object";
    private static final String modifiedBootpathWarning = "Check your custom bootclasspath for validity: ";
    private static final String jviewWarning = "You must run 'claspack -auto' to use ajc with MS's jview VM";
    private Hashtable timingInformation = new Hashtable();
    private ThreadLocal sectionLabel = new ThreadLocal();
    private ThreadLocal localNodes = new ThreadLocal();
    private long startTime;
    protected double totalWorkEstimate = 0.0;
    protected double percentComplete = 0.0;
    private volatile boolean exitRequested = false;

    public final Options getOptions() {
        return this.options;
    }

    public final World getWorld() {
        return this.world;
    }

    public final TypeManager getTypeManager() {
        return this.typeManager;
    }

    public boolean willGenerateSourceCode() {
        return this.options.usejavac || this.options.preprocess;
    }

    public String getVersion() {
        return "1.0.6";
    }

    public long getBuildTime() {
        return 1027560088910L;
    }

    public List getFilesToCompile() {
        if (this.filesToCompile == null) {
            return new LinkedList();
        }
        return this.filesToCompile;
    }

    public void addFileToCompile(File f) {
        if (this.filesToCompile == null) {
            this.filesToCompile = new LinkedList();
        }
        this.filesToCompile.add(f);
    }

    public CompilationUnit newCompilationUnit(File _file) {
        return new CompilationUnit(this, _file);
    }

    public JavaCompiler(ErrorHandler errHandler) {
        this.errorHandler = errHandler != null ? errHandler : this.makeErrorHandler();
        this.errorHandler.setCompiler(this);
    }

    protected ErrorHandler makeErrorHandler() {
        return new ErrorHandler(new OutputStreamWriter(System.err));
    }

    public JavaParser makeJavaParser() {
        return new JavaParser(this);
    }

    public boolean isIncremental() {
        return this.options.incremental;
    }

    public boolean getOptionDumpStack() {
        return this.options.dumpstack;
    }

    public boolean getOptionIgnoreErrors() {
        return this.options.ignoreErrors;
    }

    public boolean getOptionVerbose() {
        return this.options.verbose;
    }

    public void clearState() {
        this.world.cleanup();
        this.filesToCompile = null;
        this.errorHandler.cleanupErrorWarningCounters();
    }

    public void compile(List filenames) {
        this.addPasses();
        if (this.getOptions().threads != 0) {
            System.out.println("warning: multi-threaded compilation not supported in this release");
            this.getOptions().threads = 0;
        }
        try {
            try {
                this.internalCompile(filenames);
            }
            catch (CompilerErrors compilerErrors) {
                throw compilerErrors;
            }
            catch (ExitRequestException exitRequest) {
                throw exitRequest;
            }
            catch (InternalCompilerError internalError) {
                if (!this.getOptions().torture) {
                    this.errorHandler.exitOnErrors();
                }
                throw internalError;
            }
            catch (Throwable throwable) {
                if (!this.getOptions().torture) {
                    this.errorHandler.exitOnErrors();
                }
                throw new InternalCompilerError(this, throwable, this.getCurrentNode());
            }
            Object var7_2 = null;
        }
        catch (Throwable throwable) {
            Object var7_3 = null;
            throw throwable;
        }
    }

    protected void createWorld(List filenames) {
        this.typeManager = new TypeManager(this);
        this.world = new World(this);
        if (!this.typeManager.checkLoadable("java.lang", "Object")) {
            this.warnNoObject();
        }
        if (!this.typeManager.checkLoadable("org.aspectj.lang", "JoinPoint")) {
            this.warnNoRuntime(false);
        }
        if (!this.typeManager.checkLoadable("org.aspectj.runtime.internal", "AroundClosure")) {
            this.warnNoRuntime(true);
        }
        Iterator i = filenames.iterator();
        while (i.hasNext()) {
            File file;
            String filename;
            Object o = i.next();
            if (o instanceof String) {
                filename = (String)o;
                file = new File(filename);
            } else {
                file = (File)o;
                filename = file.getPath();
            }
            this.world.addFile(filename);
        }
    }

    protected void warnNoRuntime(boolean foundOld) {
        System.err.println(foundOld ? oldRuntimeWarning : noRuntimeWarning);
        System.err.println();
        System.err.println("I looked in: ");
        Iterator i = this.getTypeManager().getClassPathStrings().iterator();
        while (i.hasNext()) {
            System.err.print("    ");
            System.err.println(i.next());
        }
        throw new ExitRequestException(-1);
    }

    private void warnNoObject() {
        System.err.println(noObjectWarning);
        if (this.options.bootclasspath != null) {
            System.err.println(modifiedBootpathWarning + this.options.bootclasspath);
        } else {
            String vendor = System.getProperty("java.vm.vendor");
            if (vendor != null && vendor.startsWith("Microsoft")) {
                System.err.println(jviewWarning);
            }
        }
        throw new ExitRequestException(-1);
    }

    protected void addPasses() {
    }

    public synchronized JavaParser allocateParser() {
        JavaParser parser = this.parsers.empty() ? this.makeJavaParser() : (JavaParser)this.parsers.pop();
        return parser;
    }

    public synchronized void freeParser(JavaParser parser) {
        parser.cleanup(false);
        this.parsers.push(parser);
    }

    private Stack getNodes() {
        Object nodes = this.localNodes.get();
        if (nodes == null) {
            nodes = new Stack();
            this.localNodes.set(nodes);
        }
        return (Stack)nodes;
    }

    public String getCurrentSection() {
        return (String)this.sectionLabel.get();
    }

    public void setCurrentSection(String label) {
        this.sectionLabel.set(label);
    }

    private String formatTime(long time) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumFractionDigits(2);
        format.setMaximumFractionDigits(2);
        String value = format.format((double)time / 1000.0);
        while (value.length() < 5) {
            value = " " + value;
        }
        return value;
    }

    public double getPercentComplete() {
        return this.percentComplete;
    }

    protected void updateCompileState(String section, String subSection, double pct) {
    }

    public void completedFile(CompilerPass pass, CompilationUnit cu) {
        this.exitIfRequested();
        double pct = pass.getWorkEstimate() / this.totalWorkEstimate * (1.0 / (double)this.getWorld().getCompilationUnits().size());
        this.percentComplete += pct;
        this.updateCompileState(pass.getDisplayName(), cu.getSourceCanonicalPath(), this.percentComplete);
    }

    protected void initializeWorld(List filenames) {
        this.createWorld(filenames);
        this.errorHandler.exitOnErrors();
        HashSet<String> doneFiles = new HashSet<String>();
        Iterator i = this.world.getFiles().iterator();
        while (i.hasNext()) {
            File file = new File((String)i.next());
            try {
                if (doneFiles.contains(file.getCanonicalPath())) {
                    this.showMessage(this, "ignoring duplicate file: " + file.getPath());
                    continue;
                }
                doneFiles.add(file.getCanonicalPath());
            }
            catch (IOException e) {
                this.showError(null, e.toString());
                continue;
            }
            this.world.addCompilationUnit(this.newCompilationUnit(file));
        }
    }

    private void exitIfRequested() {
        if (this.exitRequested) {
            throw new ExitRequestException(0);
        }
    }

    public void requestCompileExit() {
        this.exitRequested = true;
    }

    protected void internalCompile(List filenames) {
        this.exitRequested = false;
        this.initializeWorld(filenames);
        Iterator i = this.passes.iterator();
        while (i.hasNext()) {
            CompilerPass pass = (CompilerPass)i.next();
            pass.transformWorld();
            this.exitIfRequested();
        }
        this.errorHandler.exitOnErrors();
        this.finish();
    }

    public void beginSection(String label) {
        this.beginSection(label, true);
    }

    public void beginSection(String label, boolean show) {
        if (!this.getNodes().empty()) {
            // empty if block
        }
        if (show) {
            this.showMessage(label);
        }
        if (this.options.timings && this.options.threads == 0) {
            long thisTime = System.currentTimeMillis();
            if (this.sectionLabel.get() != null) {
                Long t = (Long)this.timingInformation.get(this.sectionLabel.get());
                t = t == null ? new Long(thisTime - this.startTime) : new Long(t + (thisTime - this.startTime));
                this.timingInformation.put(this.sectionLabel.get(), t);
            }
            this.startTime = thisTime;
        }
        this.setCurrentSection(label);
    }

    public void finish() {
        this.beginSection("compilation complete");
        if (this.options.timings && this.options.threads == 0) {
            this.errorHandler.showMessage("Timing information:");
            Map.Entry[] a = this.timingInformation.entrySet().toArray(new Map.Entry[0]);
            Arrays.sort(a, new Comparator(){

                public int compare(Object x, Object y) {
                    return ((Long)((Map.Entry)x).getValue()).compareTo(((Map.Entry)y).getValue());
                }
            });
            long totalTime = 0L;
            int i = 0;
            int len = a.length;
            while (i < len) {
                Map.Entry n = a[i];
                String sectionLabel = (String)n.getKey();
                Long tm = (Long)n.getValue();
                long thisTime = tm;
                String msg = "  " + this.formatTime(thisTime) + " seconds in " + sectionLabel;
                totalTime += thisTime;
                this.errorHandler.showMessage(msg);
                ++i;
            }
            this.errorHandler.showMessage("---------------------------------------------");
            String msg = "  " + this.formatTime(totalTime) + " total seconds";
            this.errorHandler.showMessage(msg);
        }
    }

    public void enterNode(ASTObject where) {
        this.getNodes().push(where);
    }

    public void exitNode(ASTObject where) {
        if (this.getNodes().pop() != where) {
            // empty if block
        }
    }

    public ASTObject getCurrentNode() {
        return this.getNodes().empty() ? null : (ASTObject)this.getNodes().peek();
    }

    public void internalError(Throwable uncaughtException, ASTObject where) {
        if (!this.errorHandler.willExitWithErrors()) {
            this.errorHandler.internalError(uncaughtException, where);
        }
    }

    public void internalError(String message) {
        this.internalError(null, message);
    }

    public void internalError(ASTObject where, String message) {
        if (!this.errorHandler.willExitWithErrors()) {
            this.errorHandler.showError(where, "INTERNAL: " + message);
        }
    }

    public void showError(String message) {
        this.showError(null, message);
    }

    public void showError(ASTObject where, String message) {
        this.errorHandler.showError(where, message);
    }

    public void showError(File source, int line, int column, String message) {
        this.errorHandler.showError(source, line, column, message);
    }

    public void showWarning(ASTObject where, String message) {
        this.errorHandler.showWarning(where, message);
    }

    public void showWarning(ASTObject where, ErrorHandler.Message message) {
        this.errorHandler.showWarning(where, message);
    }

    public void showMessage(Object where, String message) {
        if (where != null && where instanceof ASTObject) {
            this.errorHandler.showMessage((ASTObject)where, message);
            return;
        }
        if (this.options.verbose) {
            this.errorHandler.showMessage("  " + message);
        }
    }

    public void showMessage(String message) {
        if (this.options.verbose) {
            this.errorHandler.showMessage(message);
        }
    }

    public void warnVersion(String oldVersion, ASTObject object, String message) {
        if (this.options.porting) {
            this.showWarning(object, "Deprecated since " + oldVersion + ": " + message);
        } else {
            this.errorVersion(oldVersion, object, message);
        }
    }

    public void errorVersion(String oldVersion, ASTObject object, String message) {
        this.showError(object, "Removed in " + oldVersion + ": " + message);
    }
}

