/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.Type;

public class MemberClassMunger
extends WalkerPass {
    private Stack types = new Stack();
    private List fields = new ArrayList();

    public MemberClassMunger(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDisplayName() {
        return "munging inner classes";
    }

    public void enterType(NameType t) {
        this.types.push(t);
    }

    public void leaveType() {
        this.types.pop();
    }

    public NameType currentType() {
        return (NameType)this.types.peek();
    }

    public void pushField(FieldDec dec) {
        this.fields.add(dec);
    }

    public void popField() {
        this.fields.remove(this.fields.size() - 1);
    }

    public FieldDec currentField() {
        return (FieldDec)this.fields.get(this.fields.size() - 1);
    }

    public List saveFields() {
        List fields = this.fields;
        this.fields = new ArrayList();
        return fields;
    }

    public void restoreFields(List fields) {
        this.fields = fields;
    }

    public Expr buildExprFromEnclosing(Expr seed, NameType targetType) {
        return this.buildExpr(seed, targetType, this.fields.size() - 2);
    }

    public Expr buildExprFromThis(Expr seed, NameType targetType) {
        return this.buildExpr(seed, targetType, this.fields.size() - 1);
    }

    private Expr buildExpr(Expr seed, NameType targetType, int i) {
        AST ast = this.getAST();
        Type currType;
        while ((currType = seed.getType()) != targetType) {
            if (i < 0) {
                throw new RuntimeException("Can't get to " + targetType + " from " + seed);
            }
            seed = ast.makeGet(seed, (FieldDec)this.fields.get(i--));
        }
        return seed;
    }

    public ASTObject process(ASTObject object) {
        return object.walkMemberMunger(this);
    }
}

