/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.compiler.base.CompilationUnitPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.cst.CUScope;
import org.aspectj.compiler.base.cst.Scope;

public class NameHygienePass
extends ScopeWalker
implements CompilationUnitPass {
    static int globalId = 0;
    Map methods = new HashMap();

    public NameHygienePass(JavaCompiler compiler) {
        super(compiler);
    }

    public double getWorkEstimate() {
        return 1.0;
    }

    public void transformWorld() {
        if (this.getDisplayName() != null) {
            this.getCompiler().beginSection(this.getDisplayName());
        }
        Iterator i = this.getWorld().getCompilationUnits().iterator();
        while (i.hasNext()) {
            CompilationUnit cu = (CompilationUnit)i.next();
            this.transform(cu);
            this.getCompiler().completedFile(this, cu);
        }
    }

    public void enterCU(CompilationUnit cu) {
        this.scope = new CUScope(this.getCompiler(), null, cu){

            protected Type handleAmbiguousImport(String id, Type type1, Type type2, ASTObject showWhere) {
                return this.getTypeManager().TYPE_NOT_FOUND;
            }
        };
        this.methods = new HashMap();
    }

    private boolean varDecCollision(VarDec varDec) {
        Expr expr = this.scope.bindUnqualifiedName(varDec.getId(), varDec);
        if (expr == null) {
            return false;
        }
        if (!(expr instanceof VarExpr)) {
            return false;
        }
        return ((VarExpr)expr).getVarDec() != varDec;
    }

    /*
     * Unable to fully structure code
     */
    public void addVarDec(VarDec varDec) {
        block1: {
            index = 0;
            id = varDec.getId();
            if (!this.getCompiler().getOptions().torture) ** GOTO lbl7
            varDec.setId(id + "_" + NameHygienePass.globalId++);
            break block1;
lbl-1000:
            // 1 sources

            {
                varDec.setId(id + index++);
lbl7:
                // 2 sources

                ** while (this.varDecCollision((VarDec)varDec))
            }
        }
        super.addVarDec(varDec);
    }

    /*
     * Unable to fully structure code
     */
    public void addTypeDec(TypeDec typeDec) {
        block2: {
            index = 0;
            id = typeDec.getId();
            if (!Character.isJavaIdentifierStart(id.charAt(0))) {
                id = "_" + id;
                typeDec.setId(id);
            }
            if (!typeDec.isLocallyDefined()) break block2;
            if (!this.getCompiler().getOptions().torture) ** GOTO lbl11
            typeDec.setId(id + "_" + NameHygienePass.globalId++);
            break block2;
lbl-1000:
            // 1 sources

            {
                typeDec.setId(id + index++);
lbl11:
                // 2 sources

                ** while (this.scope.findType((String)typeDec.getId(), (ASTObject)typeDec) != null)
            }
        }
        super.addTypeDec(typeDec);
    }

    public void addMethodDec(MethodDec methodDec) {
        if (!methodDec.isPrivate() || methodDec.fromSource()) {
            return;
        }
        int index = 0;
        String id = methodDec.getId();
        while (this.scope.findMethodLookupType(methodDec.getId(), methodDec) != null || this.methods.containsKey(methodDec.getId())) {
            methodDec.setId(id + index++);
        }
        this.methods.put(methodDec.getId(), methodDec);
    }

    public boolean canUseUnqualifiedName(Type type, ASTObject fromWhere) {
        String id = type.getId();
        if (this.scope.bindUnqualifiedName(id, fromWhere = fromWhere.getBytecodeTypeDec().getBody()) != null) {
            return false;
        }
        Type foundType = this.scope.findType(id, fromWhere);
        if (foundType != type) {
            return false;
        }
        Scope searchScope = this.scope;
        while (searchScope.getStackParent() != null) {
            Type outerFoundType = (searchScope = searchScope.getStackParent()).findType(id, fromWhere);
            if (outerFoundType == null) {
                return true;
            }
            if (outerFoundType == type) continue;
            return false;
        }
        return true;
    }

    public boolean mustUseNullTrick(Type type, ASTObject fromWhere) {
        String id = type.getPackageName();
        if (id == null) {
            id = type.getId();
        } else {
            int dot = id.indexOf(46);
            if (dot != -1) {
                id = id.substring(0, dot);
            }
        }
        return this.scope.bindUnqualifiedName(id, fromWhere) != null;
    }

    public void transform(CompilationUnit cu) {
        this.process(cu);
    }

    public boolean useJavaScopes() {
        return true;
    }

    public String getDisplayName() {
        return "name hygiene";
    }
}

