/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base;

import java.io.File;
import java.util.List;
import org.aspectj.compiler.base.AbstractCompilerPass;
import org.aspectj.compiler.base.JavaCWrapper;
import org.aspectj.compiler.base.JavaCompiler;

public class RunJavacPass
extends AbstractCompilerPass {
    public RunJavacPass(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDisplayName() {
        return "running javac on generated sources";
    }

    public List getFilesToCompile() {
        return this.getCompiler().getFilesToCompile();
    }

    public void transformWorld() {
        File outputDir = this.getOptions().workingDir;
        if (!this.getOptions().preprocess) {
            this.getCompiler().beginSection("running javac");
            if (!this.compile(this.getOptions().outputDir, outputDir, this.getFilesToCompile().toArray(new File[0]))) {
                this.getCompiler().showError(null, "error in javac");
            }
        }
    }

    public boolean compile(File inputdir, File outputdir, File[] files) {
        if (files.length == 0) {
            System.err.println("Nothing for javac to compile.");
            return false;
        }
        return new JavaCWrapper(this.getCompiler()).compile(inputdir, outputdir, files);
    }
}

