/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ArrayType;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.PrimitiveType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class ArrayExpr
extends AssignableExpr {
    protected Expr expr;
    protected Expr index;

    protected Type discoverType() {
        Type exprType;
        PrimitiveType intType = this.getTypeManager().intType;
        if (!this.index.isAssignableTo(intType)) {
            this.index.showTypeError(this.index.getType(), intType);
        }
        if ((exprType = this.expr.getType()).isAnyType()) {
            return this.getTypeManager().anyType;
        }
        if (exprType instanceof ArrayType) {
            return ((ArrayType)exprType).getComponentType();
        }
        this.expr.showError("array required, but " + exprType.getString() + " found");
        return this.getTypeManager().anyType;
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.write(this.expr);
        writer.write('[');
        writer.write(this.getIndex());
        writer.write(']');
    }

    protected void cgLvalue(CodeBuilder cb) {
        this.getExpr().cgValue(cb);
        this.getIndex().cgValue(cb);
    }

    protected void cgLtoRvalue(CodeBuilder cb) {
        this.getType().emitAload(cb);
    }

    protected void cgAssignment(CodeBuilder cb) {
        this.getType().emitAstore(cb);
    }

    protected void cgDupLvalue(CodeBuilder cb) {
        cb.emitDUP2();
    }

    protected void cgDupRvalue(CodeBuilder cb) {
        this.getType().emitDupX2(cb);
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr _expr) {
        if (_expr != null) {
            _expr.setParent(this);
        }
        this.expr = _expr;
    }

    public Expr getIndex() {
        return this.index;
    }

    public void setIndex(Expr _index) {
        if (_index != null) {
            _index.setParent(this);
        }
        this.index = _index;
    }

    public ArrayExpr(SourceLocation location, Expr _expr, Expr _index) {
        super(location);
        this.setExpr(_expr);
        this.setIndex(_index);
    }

    protected ArrayExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ArrayExpr ret = new ArrayExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.expr != null) {
            ret.setExpr((Expr)walker.process(this.expr));
        }
        if (this.index != null) {
            ret.setIndex((Expr)walker.process(this.index));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.expr;
            }
            case 1: {
                return this.index;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "index";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setExpr((Expr)child);
                return;
            }
            case 1: {
                this.setIndex((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "ArrayExpr()";
    }
}

