/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.InnerAccessFixer;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AddAssignExpr;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.BangExpr;
import org.aspectj.compiler.base.ast.BasicAssignExpr;
import org.aspectj.compiler.base.ast.BitwiseAssignExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.NumericAssignExpr;
import org.aspectj.compiler.base.ast.ShiftAssignExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;

public abstract class AssignExpr
extends BangExpr {
    protected String op;
    protected Expr rhs;

    public ASTObject fixAccessToFieldSet(FieldAccessExpr expr) {
        return this.makeInPlaceSet(expr, this.getOp(), this.getRhs());
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.lhs);
        writer.writeOp(this.op + "=");
        writer.write(this.rhs);
    }

    public Expr makeReference() {
        if (this.lhs instanceof VarExpr) {
            return this.lhs.makeReference();
        }
        return super.makeReference();
    }

    public void walkFlow(FlowCheckerPass w) {
        FieldAccessExpr lhs;
        FieldDec dec;
        w.process(this.getLhs());
        w.process(this.getRhs());
        if (this.getLhs() instanceof VarExpr) {
            VarExpr lhs2 = (VarExpr)this.getLhs();
            VarDec dec2 = lhs2.getVarDec();
            if (!(!dec2.isFinal() || dec2.isBlank() && w.getVars().isDefinitelyUnassigned(dec2))) {
                w.showVarError(this, dec2, "Final variable " + dec2.getId() + " already has a value");
            }
        } else if (this.getLhs() instanceof FieldAccessExpr && (dec = (lhs = (FieldAccessExpr)this.getLhs()).getFieldDec()).isFinal() && (!dec.isBlank() || !w.getVars().isDefinitelyUnassigned(dec))) {
            w.showVarError(this, dec, "Final field " + dec.getId() + " already has a value");
        }
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        AssignableExpr lhs = this.getLhs();
        Type lhsType = lhs.getType();
        Type rhsType = this.rhs.getType();
        return this;
    }

    public ASTObject postInnerAccess(InnerAccessFixer w) {
        if (!(this.getLhs() instanceof FieldAccessExpr)) {
            return this;
        }
        FieldAccessExpr lhs = (FieldAccessExpr)this.getLhs();
        Expr q = lhs.getExpr();
        FieldDec dec = lhs.getFieldDec();
        if (w.isAccessible(dec, q)) {
            return this;
        }
        AST ast = this.getAST();
        Type qType = q.getType();
        Expr rhs = this.getRhs();
        MethodDec newMethodDec = w.getAccessMethod(qType, dec, this.getOp(), this);
        Exprs newArgs = ast.makeExprs(rhs);
        Expr newExpr = w.makeOutsidePrimary(dec.isStatic(), newArgs, q);
        return ast.makeCall(newMethodDec, newExpr, newArgs);
    }

    public MethodDec buildAccessMethod(InnerAccessFixer w) {
        AST ast = this.getAST();
        FieldAccessExpr lhs = (FieldAccessExpr)this.getLhs();
        Expr q = lhs.getExpr();
        Type qType = q.getType();
        FieldDec dec = lhs.getFieldDec();
        Type fieldType = dec.getType();
        FormalDec valFormal = ast.makeFormal(fieldType, "val$");
        Formals newFormals = ast.makeFormals(valFormal);
        Expr newExpr = w.makeInsidePrimary(dec.isStatic(), newFormals, qType);
        return w.makeAccessMethod(fieldType, newFormals, ast.makeSet(ast.makeGet(newExpr, dec), this.getOp(), (Expr)ast.makeVar(valFormal)));
    }

    public static AssignExpr build(SourceLocation source, AssignableExpr rand1, String op, Expr rand2) {
        if ((op = op.intern()) == "") {
            return new BasicAssignExpr(source, rand1, op, rand2);
        }
        if (op == "+") {
            return new AddAssignExpr(source, rand1, op, rand2);
        }
        if (op == "*" || op == "/" || op == "%" || op == "-") {
            return new NumericAssignExpr(source, rand1, op, rand2);
        }
        if (op == "&" || op == "|" || op == "^") {
            return new BitwiseAssignExpr(source, rand1, op, rand2);
        }
        if (op == "<<" || op == ">>" || op == ">>>") {
            return new ShiftAssignExpr(source, rand1, op, rand2);
        }
        throw new RuntimeException("bad op " + op);
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String _op) {
        this.op = _op;
    }

    public Expr getRhs() {
        return this.rhs;
    }

    public void setRhs(Expr _rhs) {
        if (_rhs != null) {
            _rhs.setParent(this);
        }
        this.rhs = _rhs;
    }

    public AssignExpr(SourceLocation location, AssignableExpr _lhs, String _op, Expr _rhs) {
        super(location, _lhs);
        this.setOp(_op);
        this.setRhs(_rhs);
    }

    protected AssignExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 1: {
                return this.rhs;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 1: {
                return "rhs";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 1: {
                this.setRhs((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "AssignExpr(op: " + this.op + ")";
    }
}

