/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.crosscuts.AccessFixer;

public abstract class BangExpr
extends Expr {
    protected AssignableExpr lhs;

    public Type discoverType() {
        return this.lhs.getType();
    }

    public boolean isLegalStmt() {
        return true;
    }

    public ASTObject fixAccessPost(AccessFixer fixer) {
        if (!(this.getLhs() instanceof FieldAccessExpr)) {
            return this;
        }
        FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)this.getLhs();
        Field field = fieldAccessExpr.getField();
        if (field == null) {
            return this;
        }
        if (field.getDeclaringType().isInterface() && !field.isStatic()) {
            return this.fixAccessToFieldSet(fieldAccessExpr).setSource(this);
        }
        if (field.isAccessible(this, true)) {
            return this;
        }
        this.getCompiler().showMessage("  fixing privileged set: " + field.toShortString());
        if (!fixer.apply) {
            field.getBackdoorGetterMethod();
            field.getBackdoorSetterMethod();
            return this;
        }
        return this.fixAccessToFieldSet(fieldAccessExpr).setSource(this);
    }

    public abstract ASTObject fixAccessToFieldSet(FieldAccessExpr var1);

    final Expr makeInPlaceSet(FieldAccessExpr expr, String op, Expr rhs) {
        Expr lhs = expr.getExpr();
        Field field = expr.getField();
        Expr newExpr = lhs.makeReference();
        Method getMethod = field.getBackdoorGetterMethod();
        Method setMethod = field.getBackdoorSetterMethod();
        AST ast = this.getAST();
        return ast.makeCall(setMethod, newExpr, (Expr)ast.makeBinop(op, ast.makeCall(getMethod, newExpr.makeReference()), rhs));
    }

    public void walkFlow(FlowCheckerPass w) {
        FieldAccessExpr fa;
        FieldDec dec;
        w.process(this.getLhs());
        if (this.getLhs() instanceof VarExpr) {
            VarExpr lhs = (VarExpr)this.getLhs();
            VarDec dec2 = lhs.getVarDec();
            if (!(!dec2.isFinal() || dec2.isBlank() && w.getVars().isDefinitelyUnassigned(dec2))) {
                w.showVarError(this, dec2, "Final variable " + dec2.getId() + " already has a value");
            }
        } else if (this.getLhs() instanceof FieldAccessExpr && (dec = (fa = (FieldAccessExpr)this.getLhs()).getFieldDec()).isFinal() && (!dec.isBlank() || !w.getVars().isDefinitelyUnassigned(dec))) {
            w.showVarError(this, dec, "Final field " + dec.getId() + " already has a value");
        }
    }

    public AssignableExpr getLhs() {
        return this.lhs;
    }

    public void setLhs(AssignableExpr _lhs) {
        if (_lhs != null) {
            _lhs.setParent(this);
        }
        this.lhs = _lhs;
    }

    public BangExpr(SourceLocation location, AssignableExpr _lhs) {
        super(location);
        this.setLhs(_lhs);
    }

    protected BangExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.lhs;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "lhs";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setLhs((AssignableExpr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "BangExpr()";
    }
}

